<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>booking-status-print</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap"
        rel="stylesheet">
    <style>
        @media print {
            table {
                page-break-inside: auto;
            }

            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }

            .no-print {
                display: none;
            }
        }

        @media print {
            @page {
                size: A4;
                margin: 0;
            }

            .container {
                width: 100%;
                margin: 0;
                padding: 0;
            }

            table {
                width: 100%;
                border-collapse: collapse;
            }

            th,
            td {
                padding: 4px;
            }
        }

        @media print {
            .container {
                width: 100%;
                margin: 0;
            }

            table {
                page-break-inside: auto;
                width: 100%;
            }

            th,
            td {
                page-break-inside: avoid;
            }

            @page {
                size: auto;
                margin: 0;
            }
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: "Poppins", sans-serif;

        }


        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid black;
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        .total-cell {
            border-left: none;
            text-align: center;
            font-weight: bold;
        }

        .no-border {
            border: none;
        }

        .with-border-right {
            border-right: 1px solid black;
        }
    </style>
</head>

<body>
    <div class="container" style="margin: 50px 60px; width: 88%;">
        {{-- <div class="logo-heading" style="display: flex;gap: 25%;align-items: center;text-align: center;">
            <div class="logo">
                <img src="{{ url('logo-invoice.png') }}" alt=""
                    style="width: 200px; border-left: none;border-right: none; padding-bottom: 8px;border-top: none;">
            </div>
            <div class="heading">
                <h2>YARAN SHIPPING LINE</h2>
                <p></p>

            </div>
        </div>
        <div style="display: flex; justify-content: space-between; align-items: center; margin-top: 2%;">
            <h2 style="border:3px solid;width: 68%;border-top: none; border-right: none; border-left: none;"></h2>
            <h2>{{ @$transaction_master->type->full_name }}</h2>
            <h2 style="border:3px solid;width: 8%; border-right: none; border-left: none;border-top: none;"></h2>
        </div> --}}
        <div class="logo-heading" style="display: flex;gap: 15%;align-items: center;text-align: center;">
            <div class="logo">
                <img src="{{ url('/logo-invoice.png') }}" alt=""
                    style="width: 150px; padding-bottom: px;border-top: none;">
            </div>
            <div class="heading">
                <h3>YARAN SHIPPING LINE</h3>
                <p></p>
                <p style="font-size: 12px;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div style="display: flex; align-items: center; margin-top: 10px;">
            <div style="width: 68%; border-top: 3px solid #000;"></div>
            <h3 style="margin: 0 15px; white-space: nowrap;">{{ @$transaction_master->type?->full_name }}</h3>
            <div style="width: 8%; border-top: 3px solid #000;"></div>
        </div>

        <div class="mid" style="display: flex; gap: 20px;justify-content: space-between;margin-top: 5%;">
            <div class="voucher" style="display: flex; gap: 10px;font-size: 13px;">
                <div><b>Voucher # :</b></div>
                <div style="border-bottom: 1px solid; width: 120px;">{{ $transaction_master->voucher_no }}</div>
            </div>
            <div class="source" style="display: flex; gap: 10px;font-size: 13px;">
                <div> <b>Source No : </b></div>
                <div style="border-bottom: 1px solid; width: 120px;"> </div>
            </div>
            <div class="date" style="display: flex; gap: 10px;font-size: 13px;">
                <div> <b>Date :</b> </div>
                <div style="border-bottom: 1px solid; width: 120px;"> {{ $transaction_master->date }}</div>
            </div>
        </div>

        <div class="mid" style="display: flex; gap: 20px;justify-content: space-between;margin-top: 4%;">
            <div class="source" style="display: flex; gap: 10px;font-size: 13px;">
                <div> <b>Currency : </b></div>
                <div style="border-bottom: 1px solid; width: 120px;">{{ @$transaction_master->currency?->name }}</div>
            </div>
            <div class="date" style="display: flex; gap: 10px;font-size: 13px;">
                <div> <b>Exchange Rate :</b> </div>
                <div style="border-bottom: 1px solid; width: 120px;"> {{ $transaction_master->exchange_rate }}</div>
            </div>
            <div class="date" style="display: flex; gap: 10px;font-size: 13px; visibility: hidden;">
                <div> <b>Exchange Rate :</b> </div>
                <div style="border-bottom: 1px solid; width: 120px;"> {{ $transaction_master->exchange_rate }}</div>
            </div>

        </div>

        <table style="margin-top: 4%; font-size: 13px;">
            <thead>
                <tr>
                    <th>Code</th>
                    <th>Head of Account</th>
                    <th>Cost Center</th>
                    <th>Debit</th>
                    <th>Credit</th>
                    @if ($transaction_master->currency_id != 1)
                        <th>Debit (Converted)</th>
                    @endif
                    @if ($transaction_master->currency_id != 1)
                        <th>Credit (Converted)</th>
                    @endif
                </tr>
            </thead>
            <tbody>
                @foreach ($transaction_master->detail as $detail)
                    <tr>
                        <td>{{ $detail->account?->account_code }}</td>
                        <td>{{ $detail->account?->name }}</td>
                        <td>{{ $detail->transaction?->cost_center?->name ?? 'Head Office' }}</td>
                        <td style="text-align: right;">{{ number_format($detail->debit_lc, 2) }}</td>
                        <td style="text-align: right;">{{ number_format($detail->credit_lc, 2) }}</td>
                        @if ($transaction_master->currency_id != 1)
                            <td style="text-align: right;">{{ number_format($detail->debit_vc, 2) }}</td>
                        @endif
                        @if ($transaction_master->currency_id != 1)
                            <td style="text-align: right;">{{ number_format($detail->credit_vc, 2) }}</td>
                        @endif
                    </tr>
                @endforeach
                <tr class="total-row">
                    <td colspan="3" style="text-align: right;">Total</td>
                    <td style="text-align: right;">{{ number_format($transaction_master->detail->sum('debit_lc'), 2) }}
                    </td>
                    <td style="text-align: right;">
                        {{ number_format($transaction_master->detail->sum('credit_lc'), 2) }}</td>
                    @if ($transaction_master->currency_id != 1)
                        <td style="text-align: right;">
                            {{ number_format($transaction_master->detail->sum('debit_vc'), 2) }}</td>
                        <td style="text-align: right;">
                            {{ number_format($transaction_master->detail->sum('credit_vc'), 2) }}</td>
                    @endif
            </tbody>
        </table>

        <div class="date" style="display: flex; gap: 25px; font-size: 13px; white-space: nowrap; margin-top: 3%;">
            <div> <b>Total Amounts In Word :</b></div>
            <div style="border-bottom: 1px solid; width: 100%; ">
                {{ strtoupper(@$transaction_master->currency?->name) }}
                {{ strtoupper(App\Helpers\NumberToWords::convert($transaction_master->detail->sum('debit_lc'))) }} ONLY
            </div>
        </div>

        <div class="date" style="display: flex; gap: 25px;font-size: 13px; margin-top:30px; margin-bottom: 30px;">
            <div> <b>Narration:</b> </div>
            <div style="border-bottom: 1px solid; width: 100%;">
                {{ strtoupper($transaction_master->narration) }}
            </div>
        </div>

        <div>
            <div style="margin-top:6%; margin-left: 7%;">{{ $transaction_master->created_by_user?->name ?? '' }}</div>
        </div>
        <div class="signature-section"
            style="display: flex; justify-content: space-between; align-items: flex-start; font-size: 13px; padding-top: 10px;">
            <div style="border-top: 1px solid black; padding-top: 5px; width: 20%; text-align: center;">
                Prepared By
            </div>
            <div style="border-top: 1px solid black; padding-top: 5px; width: 20%; text-align: center;">
                Checked By
            </div>
            <div style="border-top: 1px solid black; padding-top: 5px; width: 20%; text-align: center;">
                Approved By
            </div>
        </div>

    </div>
</body>

</html>
