@extends('layout.master')

@section('title')
    {{-- @if (Request::is('se_job'))
        SE Job-YARAN
    @elseif(Request::is('si_job'))
        SI Job-YARAN
    @elseif(Request::is('ae_job'))
        AE Job-YARAN
    @elseif(Request::is('ai_job'))
        AI Job-YARAN
    @endif --}}
    Job-YARAN
@endsection

@section('topbar')
    {{-- @if (Request::is('se_job'))
        <a href="" class="breadcrumb--active">SE Job</a>
    @elseif(Request::is('si_job'))
        <a href="" class="breadcrumb--active">SI Job</a>
    @elseif(Request::is('ae_job'))
        <a href="" class="breadcrumb--active">AE Job</a>
    @elseif(Request::is('ai_job'))
        <a href="" class="breadcrumb--active">AI Job</a>
    @endif --}}
    <a href="" class="breadcrumb--active">Job</a>
@endsection
@section('content')
    {{-- <h2 class="intro-y fs-lg fw-medium mt-10">
        @if (Request::is('se_job'))
            SE Job
        @elseif(Request::is('si_job'))
            SI Job
        @elseif(Request::is('ae_job'))
            AE Job
        @elseif(Request::is('ai_job'))
            AI Job
        @endif
    </h2> --}}
    <div class="intro-y d-flex align-items-center">
        <div class="d-flex align-items-center">
            <h2 class="intro-y fs-lg fw-medium mt-6">
                {{-- @if (Request::is('se_job'))
                    SE Job
                @elseif(Request::is('si_job'))
                    SI Job
                @elseif(Request::is('ae_job'))
                    AE Job
                @elseif(Request::is('ai_job'))
                    AI Job
                @endif --}}
                Job
            </h2>
        </div>
        <div class="ms-auto mt-10">
            <button class="btn btn-primary dark-text-theme-10" type="button" data-bs-toggle="collapse"
                data-bs-target="#faq-accordion-collapse-1" aria-expanded="true" aria-controls="faq-accordion-collapse-1"> <i
                    data-feather="filter" class="w-4 h-4 me-3"></i> Filters
            </button>
        </div>
    </div>
    <div id="faq-accordion-collapse-1" class="accordion-collapse collapse show mt-5" aria-labelledby="faq-accordion-content-1"
        data-bs-parent="#faq-accordion-1">
        <div class="grid columns-12 gap-6 mt-5">
            <div class="intro-y g-col-12 g-col-lg-12">
                <!-- BEGIN: Form Layout -->
                <div class="intro-y box p-5">
                    <form method="GET" id="myForm" action="{{ url('/se_job') }}">
                        <div class="row">
                            <div class="col-md-3">
                                <div>
                                    <label for="filterBy" class="form-label">Select</label>
                                    <select name="filterBy" id="filterBy" class="form-control">
                                        <option value="" {{ request('filterBy') == '' ? 'selected' : '' }}>Select
                                        </option>
                                        <option value="id" {{ request('filterBy') == 'id' ? 'selected' : '' }}>Job
                                            Number</option>
                                        <option value="cost_center"
                                            {{ request('filterBy') == 'cost_center' ? 'selected' : '' }}>Cost Center
                                        </option>
                                        <option value="job_type" {{ request('filterBy') == 'job_type' ? 'selected' : '' }}>
                                            Job Type</option>
                                        <option value="customer_reference_no"
                                            {{ request('filterBy') == 'customer_reference_no' ? 'selected' : '' }}>Customer
                                            Ref</option>
                                        <option value="client_id"
                                            {{ request('filterBy') == 'client_id' ? 'selected' : '' }}>Client ID</option>
                                        <option value="shipper_id"
                                            {{ request('filterBy') == 'shipper_id' ? 'selected' : '' }}>Shipper ID</option>
                                        <option value="consignee_id"
                                            {{ request('filterBy') == 'consignee_id' ? 'selected' : '' }}>Consignee ID
                                        </option>
                                        <option value="sales_rep_id"
                                            {{ request('filterBy') == 'sales_rep_id' ? 'selected' : '' }}>Sales Rep</option>
                                        <option value="shipping_line_id"
                                            {{ request('filterBy') == 'shipping_line_id' ? 'selected' : '' }}>Shipping Line
                                        </option>
                                        <option value="local_vendor_id"
                                            {{ request('filterBy') == 'local_vendor_id' ? 'selected' : '' }}>Local Vendor
                                            ID</option>
                                        <option value="overseas_agent_id"
                                            {{ request('filterBy') == 'overseas_agent_id' ? 'selected' : '' }}>Overseas
                                            Agent</option>
                                        <option value="vessel_id"
                                            {{ request('filterBy') == 'vessel_id' ? 'selected' : '' }}>Vessel ID</option>
                                        <option value="voyage_id"
                                            {{ request('filterBy') == 'voyage_id' ? 'selected' : '' }}>Voyage</option>
                                        <option value="c_bkg_ed" {{ request('filterBy') == 'c_bkg_ed' ? 'selected' : '' }}>
                                            CBKG No</option>
                                        <option value="ship_status_id"
                                            {{ request('filterBy') == 'ship_status_id' ? 'selected' : '' }}>Shipment Status
                                        </option>
                                        <option value="commodity_id"
                                            {{ request('filterBy') == 'commodity_id' ? 'selected' : '' }}>Commodity
                                        </option>
                                        <option value="port_of_loading_id"
                                            {{ request('filterBy') == 'port_of_loading_id' ? 'selected' : '' }}>Port of
                                            Loading</option>
                                        <option value="port_of_discharge_id"
                                            {{ request('filterBy') == 'port_of_discharge_id' ? 'selected' : '' }}>Port of
                                            Destination</option>
                                        <option value="hbl_no" {{ request('filterBy') == 'hbl_no' ? 'selected' : '' }}>HBL
                                            No</option>
                                        <option value="mbl_no" {{ request('filterBy') == 'mbl_no' ? 'selected' : '' }}>MBL
                                            No</option>
                                        <option value="file_number"
                                            {{ request('filterBy') == 'file_number' ? 'selected' : '' }}>File Number
                                        </option>
                                        <option value="container_no"
                                            {{ request('filterBy') == 'container_no' ? 'selected' : '' }}>Container No
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3" id="filterInput">
                                <label for="filterValue" class="form-label">Name / Number</label>
                                <input type="text" name="filterValue" class="form-control"
                                    value="{{ request('filterValue') }}" placeholder="Enter Name or Number"
                                    aria-label="Enter Name / Number">
                            </div>
                            <div class="col-md-3 d-none" id="jobType">
                                <label>Job Type</label>
                                <select data-placeholder="Select Job Type" id="job_type" name="job_type"
                                    class="tom-select w-full mt-2">
                                    <option {{ request('job_type') == 'Direct' ? 'selected' : '' }} value="Direct">Direct
                                    </option>
                                    <option {{ request('job_type') == 'Coloaded' ? 'selected' : '' }} value="Coloaded">
                                        Coloaded</option>
                                    <option {{ request('job_type') == 'Cross Trade' ? 'selected' : '' }}
                                        value="Cross Trade">Cross Trade</option>
                                    <option {{ request('job_type') == 'Liner Agency' ? 'selected' : '' }}
                                        value="Liner Agency">Liner Agency</option>
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="costCenter">
                                <label>Cost Center</label>
                                <select data-placeholder="Select Cost Center" id="cost_center" name="cost_center"
                                    class="tom-select w-full mt-2">
                                    <option {{ request('cost_center') == 'Head Office' ? 'selected' : '' }}
                                        value="Head Office">Head Office</option>
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="clientId">
                                <label>Client</label>
                                <select class="tom-select w-full mt-2" name="client_id" id="client_id"
                                    data-placeholder="Select Client">
                                    <option value="">Please Select</option>
                                    @foreach ($clients as $item)
                                        <option {{ request('client_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="shipperId">
                                <label>Shipper</label>
                                <select class="tom-select w-full mt-2" name="shipper_id" id="shipper_id"
                                    data-placeholder="Select Shipper">
                                    <option value="">Please Select</option>
                                    @foreach ($shippers as $item)
                                        <option {{ request('shipper_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="consigneeId">
                                <label>Consignee</label>
                                <select class="tom-select w-full mt-2" name="consignee_id" id="consignee_id"
                                    data-placeholder="Select Consignee">
                                    <option value="">Please Select</option>
                                    @foreach ($consignees as $item)
                                        <option {{ request('consignee_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="salesRep">
                                <label>Sales Rep</label>
                                <select class="tom-select w-full mt-2" name="sales_rep_id" id="sales_rep_id"
                                    data-placeholder="Select Sales Rep">
                                    <option value="">Please Select</option>
                                    @foreach ($sales_rep as $item)
                                        <option {{ request('sales_rep_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->employee_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="shippingLine">
                                <label>SLine/Carrier</label>
                                <select class="tom-select w-full mt-2" name="shipping_line_id" id="shipping_line_id"
                                    data-placeholder="Select SLine/Carrier">
                                    <option value="">Please Select</option>
                                    @foreach ($shipping_line as $item)
                                        <option {{ request('shipping_line_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="localVendor">
                                <label>Local Vendor</label>
                                <select class="tom-select w-full mt-2" name="local_vendor_id" id="local_vendor_id"
                                    data-placeholder="Select Local Vendor">
                                    <option value="">Please Select</option>
                                    @foreach ($local_vendor as $item)
                                        <option {{ request('local_vendor_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="OverseasAgent">
                                <label>Overseas Agent</label>
                                <select class="tom-select w-full mt-2" name="overseas_agent_id" id="overseas_agent_id"
                                    data-placeholder="Select Overseas Agent">
                                    <option value="">Please Select</option>
                                    @foreach ($overseas_agent as $item)
                                        <option {{ request('overseas_agent_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="vessel">
                                <label>Vessel</label>
                                <select class="tom-select w-full mt-2" name="vessel_id" id="vessel_id"
                                    data-placeholder="Select Vessel">
                                    <option value="">Please Select</option>
                                    @foreach ($vessels as $item)
                                        <option {{ request('vessel_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="voyage">
                                <label>Voyage</label>
                                <select class="tom-select w-full mt-2" name="voyage_id" id="voyage_id"
                                    data-placeholder="Select Voyage">
                                    <option value="">Please Select</option>
                                    @foreach ($voyages as $item)
                                        <option {{ request('voyage_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->voyage_no }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="shipStatus">
                                <label>Ship Status</label>
                                <select data-placeholder="Select Ship Status" id="ship_status_id" name="ship_status_id"
                                    class="tom-select w-full mt-2">
                                    @foreach ($ship_status as $item)
                                        <option {{ request('ship_status_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="commodity">
                                <label>Commodity</label>
                                <select class="tom-select w-full mt-2" name="commodity_id" id="commodity_id"
                                    data-placeholder="Select Commodity">
                                    <option value="">Please Select</option>
                                    @foreach ($commodities as $item)
                                        <option {{ request('commodity_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="portOfLoading">
                                <label>Port of Loading</label>
                                <select class="tom-select w-full mt-2" name="port_of_loading_id" id="port_of_loading_id"
                                    data-placeholder="Select Port of Loading">
                                    <option value="">Please Select</option>
                                    @foreach ($un_locations as $item)
                                        <option {{ request('port_of_loading_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="portOfDischarge">
                                <label>Port of Discharge</label>
                                <select class="tom-select w-full mt-2" name="port_of_discharge_id"
                                    id="port_of_discharge_id" data-placeholder="Select Port of Discharge">
                                    <option value="">Please Select</option>
                                    @foreach ($un_locations as $item)
                                        <option {{ request('port_of_discharge_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label>Job Status</label>
                                <select data-placeholder="Select Job Status" id="job_status_id" name="job_status_id"
                                    class="tom-select w-full mt-2">
                                    <option value="" {{ request('job_status_id') == '' ? 'selected' : '' }}>Select
                                    </option>
                                    @foreach ($job_status as $item)
                                        <option {{ request('job_status_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="date_filter" class="form-label">Date Filter</label>
                                <select name="date_filter" id="date_filter" class="form-control">
                                    <option value="" {{ request('date_filter') == '' ? 'selected' : '' }}>Select
                                    </option>
                                    <option value="today" {{ request('date_filter') == 'today' ? 'selected' : '' }}>Today
                                    </option>
                                    <option value="this_week"
                                        {{ request('date_filter') == 'this_week' ? 'selected' : '' }}>This Week</option>
                                    <option value="this_month"
                                        {{ request('date_filter') == 'this_month' ? 'selected' : '' }}>This Month</option>
                                    <option value="custom" {{ request('date_filter') == 'custom' ? 'selected' : '' }}>
                                        Custom</option>
                                </select>
                            </div>
                            <div class="col-md-3" id="customDateRange"
                                style="display: {{ request('date_filter') == 'custom' ? 'block' : 'none' }};">
                                <label for="date_from" class="form-label">From</label>
                                <input type="date" name="date_from" class="form-control"
                                    value="{{ request('date_from') }}">
                            </div>
                            <div class="col-md-3" id="customDateRangeTwo"
                                style="display: {{ request('date_filter') == 'custom' ? 'block' : 'none' }};">
                                <label for="date_to" class="form-label">To</label>
                                <input type="date" name="date_to" class="form-control"
                                    value="{{ request('date_to') }}">
                            </div>
                            <div class="col-md-3 mt-8">
                                <button type="submit" class="btn btn-sm btn-elevated-primary w-24">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20"
                                        height="20" class="main-grid-item-icon" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                        <circle cx="11" cy="11" r="8" />
                                        <line x1="21" x2="16.65" y1="21" y2="16.65" />
                                    </svg>
                                    Search</button>
                                <a href="{{ url('/se_job') }}" type="button"
                                    class="btn btn-sm btn-elevated-danger w-24">
                                    {{-- <i data-feather="x"></i> --}}
                                    <!-- https://feathericons.dev/?search=x&iconset=feather -->
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20"
                                        height="20" class="main-grid-item-icon" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                        <line x1="18" x2="6" y1="6" y2="18" />
                                        <line x1="6" x2="18" y1="6" y2="18" />
                                    </svg>
                                    Clear</a>
                            </div>
                    </form>
                </div>
            </div>
            <!-- END: Form Layout -->
        </div>
    </div>
    </div>
    {{-- end filter --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            {{-- @if (Request::is('se_job'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/se_job/add') }}">Add New</a>
            @elseif(Request::is('si_job'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/si_job/add') }}">Add New</a>
            @elseif(Request::is('ae_job'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/ae_job/add') }}">Add New</a>
            @elseif(Request::is('ai_job'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/ai_job/add') }}">Add New</a>
            @endif --}}
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $se_jobs->firstItem() }} to
                {{ $se_jobs->lastItem() }} of {{ $se_jobs->total() }} entries</div>
            {{-- <div class="w-full w-sm-auto mt-3 mt-sm-0 ms-sm-auto ms-md-0 position-end">
                    <div class="w-56 position-relative text-gray-700 dark-text-gray-300">
                        <input type="text" class="form-control w-56 box border-white dark-border-dark-3 pe-10 placeholder-theme-13" placeholder="Search...">
                        <i class="w-4 h-4 position-absolute my-auto top-0 bottom-0 me-3 end-0" data-feather="search"></i> 
                    </div>
                </div> --}}
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>JOB #</th>
                        <th>Operation Type</th>
                        <th>Client</th>
                        {{-- <th>Sales Rep</th> --}}
                        <th>HBL #</th>
                        <th>MBL #</th>
                        <th>Sline</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($se_jobs as $item)
                        <tr>
                            <td>{{ @$item->job_no }}</td>
                            <td>{{ @$item->operation->name }}</td>
                            <td>{{ @$item->job_detail->client->name }}</td>
                            {{-- <td>{{ @$item->job_detail->sales_rep->name }}</td> --}}
                            <td>{{ @$item->bl_master->hbl_no }}</td>
                            <td>{{ @$item->bl_master->mbl_no }}</td>
                            <td>{{ @$item->job_detail->shipping_line->name }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    @if ($item->operation_id == 1)
                                        <a class="btn btn-primary me-2 p-2"
                                            href="{{ url('/se_job/edit/' . $item->id) }}"><i data-feather="edit"
                                                class="w-4 h-4 me-1"></i>
                                            Edit </a>
                                    @elseif ($item->operation_id == 2)
                                        <a class="btn btn-primary me-2 p-2"
                                            href="{{ url('/si_job/edit/' . $item->id) }}"><i data-feather="edit"
                                                class="w-4 h-4 me-1"></i>
                                            Edit </a>
                                    @elseif ($item->operation_id == 3)
                                        <a class="btn btn-primary me-2 p-2"
                                            href="{{ url('/ae_job/edit/' . $item->id) }}"><i data-feather="edit"
                                                class="w-4 h-4 me-1"></i>
                                            Edit </a>
                                    @elseif ($item->operation_id == 4)
                                        <a class="btn btn-primary me-2 p-2"
                                            href="{{ url('/ai_job/edit/' . $item->id) }}"><i data-feather="edit"
                                                class="w-4 h-4 me-1"></i>
                                            Edit </a>
                                    @endif
                                    <form class="mb-0" action="{{ url('/se_job/updateStatus/' . $item->id) }}"
                                        method="post">
                                        @csrf
                                        <button title="Approve Job" class="tooltip mt-3 btn btn-success me-2 p-2"
                                            type="submit"><i data-feather="check" class="w-4 h-4 me-1"></i> Approve
                                        </button>
                                    </form>
                                    <button id="showPrintBtn{{ $item->id }}"
                                        class="btn btn-success me-2 p-2 showPrintBtn" data-bs-toggle="modal"
                                        data-bs-target="#printModal" data-item-id="{{ $item->id }}"><i
                                            data-feather="file-text" class="w-4 h-4 me-1"></i> Print </button>
                                    <a title="SE B/L" class="tooltip btn btn-primary me-2 p-2"
                                        href="{{ url('/se_bl/add/' . $item->id) }}"><i data-feather="file-text"
                                            class="w-4 h-4 me-1"></i>
                                        B/L </a>
                                    <a title="CRO" class="tooltip btn btn-warning me-2 p-2"
                                        href="{{ url('/cro/add/' . $item->id) }}"><i data-feather="file-text"
                                            class="w-4 h-4 me-1"></i>
                                        CRO </a>
                                    <button
                                        onclick="handleInvoiceButtonClick({{ $item->id }}, {{ $item->status }})"
                                        type="button" id="invoice-btn" title="Invoice"
                                        class="tooltip invoice-btn btn btn-outline-primary me-2 p-2"><i
                                            data-feather="file-text" class="w-4 h-4 me-1"></i> Invoices </button>
                                    <button onclick="handleBillButtonClick({{ $item->id }}, {{ $item->status }})"
                                        type="button" id="bill-btn" title="Bill"
                                        class="tooltip bill-btn btn btn-outline-success me-2 p-2"
                                        href="{{ url('/se_bill/add/' . $item->id) }}"><i data-feather="file-text"
                                            class="w-4 h-4 me-1"></i> Bills </button>
                                    {{-- <div class="d-flex justify-content-center me-2">
                                        <div class="dropdown">
                                            <button title="Customer Invoices" class="tooltip dropdown-toggle btn btn-outline-primary"
                                                aria-expanded="false" data-bs-toggle="dropdown"><i data-feather="printer"
                                                    class="w-4 h-4"></i></button>
                                            <div class="dropdown-menu w-48">
                                                <ul class="dropdown-content">
                                                    @foreach ($job_master->job_charges_receivable as $invoice)
                                                        <li>
                                                            <a href="" class="dropdown-item fs-base"> <i data-feather="printer"
                                                                    class="w-4 h-4 me-2"></i>
                                                                {{ $invoice->customer->name }}'s Invoice
                                                            </a>
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-center">
                                        <div class="dropdown">
                                            <button title="Vendor Invoices" class="tooltip dropdown-toggle btn btn-outline-success"
                                                aria-expanded="false" data-bs-toggle="dropdown"><i data-feather="printer"
                                                    class="w-4 h-4"></i></button>
                                            <div class="dropdown-menu w-48">
                                                <ul class="dropdown-content">
                                                    @foreach ($job_master->job_charges_payable as $invoice)
                                                        <li>
                                                            <a href="" class="dropdown-item fs-base"> <i data-feather="printer"
                                                                    class="w-4 h-4 me-2"></i>
                                                                {{ $invoice->vendor->name }}'s Invoice
                                                            </a>
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                    </div> --}}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        {{-- end Data List --}}
        <!-- Pagination -->
        <div class="g-col-12">
            <div class="d-flex justify-content-end align-items-end">
                <div class="me-3">
                    <label for="perPage" class="form-label">Show Items:</label>
                    <select id="perPage" name="perPage" class="form-select" onchange="changePerPage(this)">
                        <option value="100" @if ($perPage == 100) selected @endif>100</option>
                        <option value="200" @if ($perPage == 200) selected @endif>200</option>
                        <option value="250" @if ($perPage == 250) selected @endif>250</option>
                    </select>
                </div>
            </div>
        </div>
        {{-- end Pagination --}}
    </div>
    @include('sea_export.se_job.modals.print')
@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const printModal = document.getElementById('printModal');
        const printForm = document.getElementById('printForm');
        const selectedJobIdInput = document.getElementById('selectedJobId');

        printModal.addEventListener('show.bs.modal', function(event) {
            const button = event.relatedTarget; // Button that triggered the modal
            const jobId = button.getAttribute('data-item-id'); // Extract info from data-* attributes

            // Debugging: Log the jobId to ensure it's being retrieved correctly
            console.log('Job ID:', jobId);

            // Update the input value and form action URL
            selectedJobIdInput.value = jobId;
            const apiUrl = "{{ url('job_print') }}";
            printForm.action = `${apiUrl}/${jobId}`;

            // Debugging: Log the form action to ensure it's set correctly
            console.log('Form Action URL:', printForm.action);
        });
    });
</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Get all radio buttons
        const radioButtons = document.querySelectorAll('input[name="reportOptions"]');
        // Add event listener to each radio button
        radioButtons.forEach(function(radio) {
            radio.addEventListener('change', function() {
                // Hide all divs
                $('#divInterestRate').addClass('d-none');
                $('#divShowSummary').addClass('d-none');
                $('#divShowExtendedInformation').addClass('d-none');
                $('#divRemarks').addClass('d-none');
                $('#divShowContainer').addClass('d-none');
                $('#divShowAmountInsteadOfRate').addClass('d-none');
                $('#divShowOnlyRealized').addClass('d-none');
                $('#divExcludeConsoleShare').addClass('d-none');
                $('#divIncludeTax').addClass('d-none');
                $('#divExcludeExRateGL').addClass('d-none');
                $('#divShowSignature').addClass('d-none');
                $('#divExcludeFinancialCost').addClass('d-none');
                $('#divName').addClass('d-none');
                $('#divCurrency').addClass('d-none');
                $('#divShowContainer').addClass('d-none');
                $('#divShowBank').addClass('d-none');
                $('#divPrintOnlyUnapprovedCharges').addClass('d-none');
                $('#divAddDiscriptionWithCharges').addClass('d-none');
                $('#divAddDiscriptionOnly').addClass('d-none');
                $('#divOnlyOceanFreightCharges').addClass('d-none');
                $('#divExcludeOceanFreight').addClass('d-none');
                $('#divBankDetail').addClass('d-none');
                $('#divClient').addClass('d-none');
                $('#divRegular').addClass('d-none');
                $('#divSecurityDeposit').addClass('d-none');
                $('#divDetention').addClass('d-none');
                $('#divDemurrage').addClass('d-none');
                $('#divPrintBalanceAdjustment').addClass('d-none');
                $('#divMessageOfSystemGeneratedInvoice').addClass('d-none');
                $('#divPrincipal').addClass('d-none');
                $('#divVendor').addClass('d-none');
                $('#divEDI').addClass('d-none');

                // Show the selected div
                if (this.id === 'report1') {
                    $('#divInterestRate').removeClass('d-none');
                    $('#divCharges').removeClass('d-none');
                    $('#divPrintCompanyHeader').removeClass('d-none');
                } else if (this.id === 'report2') {
                    $('#divFormat').addClass('d-none');
                    $('#divCharges').addClass('d-none');
                    $('#divPrintCompanyHeader').addClass('d-none');
                    $('#divInterestRate').removeClass('d-none');
                    $('#divShowSummary').removeClass('d-none');
                    $('#divShowExtendedInformation').removeClass('d-none');
                    $('#divRemarks').removeClass('d-none');
                    $('#divShowContainer').removeClass('d-none');
                    $('#divShowAmountInsteadOfRate').removeClass('d-none');
                    $('#divShowOnlyRealized').removeClass('d-none');
                    $('#divExcludeConsoleShare').removeClass('d-none');
                    $('#divIncludeTax').removeClass('d-none');
                    $('#divExcludeExRateGL').removeClass('d-none');
                    $('#divShowSignature').removeClass('d-none');
                    $('#divExcludeFinancialCost').removeClass('d-none');
                } else if (this.id === 'report3') {
                    $('#divFormat').addClass('d-none');
                    $('#divCharges').addClass('d-none');
                    $('#divPrintCompanyHeader').addClass('d-none');
                    $('#divExcludeConsoleShare').removeClass('d-none');
                    $('#divIncludeTax').removeClass('d-none');
                    $('#divExcludeExRateGL').removeClass('d-none');
                } else if (this.id === 'report4') {
                    $('#divFormat').addClass('d-none');
                    $('#divCharges').addClass('d-none');
                    $('#divPrintCompanyHeader').addClass('d-none');
                } else if (this.id === 'report5') {
                    $('#divFormat').addClass('d-none');
                    $('#divCharges').addClass('d-none');
                    $('#divPrintCompanyHeader').addClass('d-none');
                    $('#divName').removeClass('d-none');
                    $('#divCurrency').removeClass('d-none');
                    $('#divShowContainer').removeClass('d-none');
                    $('#divShowBank').removeClass('d-none');
                    $('#divPrintOnlyUnapprovedCharges').removeClass('d-none');
                    $('#divAddDiscriptionWithCharges').removeClass('d-none');
                    $('#divAddDiscriptionOnly').removeClass('d-none');
                    $('#divOnlyOceanFreightCharges').removeClass('d-none');
                    $('#divExcludeOceanFreight').removeClass('d-none');
                    $('#divBankDetail').removeClass('d-none');
                } else if (this.id === 'report6') {
                    $('#divFormat').addClass('d-none');
                    $('#divCharges').addClass('d-none');
                    $('#divPrintCompanyHeader').addClass('d-none');
                    $('#divCurrency').removeClass('d-none');
                    $('#divClient').removeClass('d-none');
                    $('#divShowContainer').removeClass('d-none');
                    $('#divShowSignature').removeClass('d-none');
                    $('#divRegular').removeClass('d-none');
                    $('#divSecurityDeposit').removeClass('d-none');
                    $('#divDetention').removeClass('d-none');
                    $('#divDemurrage').removeClass('d-none');
                    $('#divPrintBalanceAdjustment').removeClass('d-none');
                    $('#divMessageOfSystemGeneratedInvoice').removeClass('d-none');
                } else if (this.id === 'report7') {
                    $('#divFormat').addClass('d-none');
                    $('#divCharges').addClass('d-none');
                    $('#divPrintCompanyHeader').addClass('d-none');
                    $('#divCurrency').removeClass('d-none');
                    $('#divPrincipal').removeClass('d-none');
                } else if (this.id === 'report8') {
                    $('#divFormat').addClass('d-none');
                    $('#divCharges').addClass('d-none');
                    $('#divPrintCompanyHeader').addClass('d-none');
                    $('#divVendor').removeClass('d-none');
                } else if (this.id === 'report9') {
                    $('#divFormat').addClass('d-none');
                    $('#divCharges').addClass('d-none');
                    $('#divPrintCompanyHeader').addClass('d-none');
                    $('#divEDI').removeClass('d-none');
                }
            });
        });
    });

    // $('.modal form').submit(function(e) {
    //         e.preventDefault();
    //         var formData = $(this).serialize();
    //         var apiUrl = $(this).closest('.modal').data('api-url');

    //         $.ajax({
    //             url: apiUrl,
    //             type: 'POST',
    //             data: formData,
    //             success: function(response) {
    //                 console.log(response);
    //             },
    //             error: function(xhr, status, error) {
    //                 // Handle error response
    //                 // console.error(xhr.responseText);
    //                 // Optionally, display an error message
    //             }
    //         });

    //     });
</script>
<script>
    $(document).ready(function() {

        document.getElementById('date_filter').addEventListener('change', function() {
            var customDateRange = document.getElementById('customDateRange');
            var customDateRangeTwo = document.getElementById('customDateRangeTwo');
            if (this.value === 'custom') {
                customDateRange.style.display = 'block';
                customDateRangeTwo.style.display = 'block';
            } else {
                customDateRange.style.display = 'none';
                customDateRangeTwo.style.display = 'none';
            }
        });

        $('#filterBy').change(function() {
            var selectedOption = $(this).val();

            // Clear all input fields
            $('#filterInput input').val('');
            $('#jobType select').val('');
            $('#costCenter select').val('');
            $('#clientId select').val('');
            $('#shipperId select').val('');
            $('#consigneeId select').val('');
            $('#salesRep select').val('');
            $('#shippingLine select').val('');
            $('#localVendor select').val('');
            $('#OverseasAgent select').val('');
            $('#vessel select').val('');
            $('#voyage select').val('');
            $('#shipStatus select').val('');
            $('#commodity select').val('');
            $('#portOfLoading select').val('');
            $('#portOfDischarge select').val('');

            // Hide all optional fields initially
            $('#filterInput').addClass('d-none');
            $('#jobType').addClass('d-none');
            $('#costCenter').addClass('d-none');
            $('#clientId').addClass('d-none');
            $('#shipperId').addClass('d-none');
            $('#consigneeId').addClass('d-none');
            $('#salesRep').addClass('d-none');
            $('#shippingLine').addClass('d-none');
            $('#localVendor').addClass('d-none');
            $('#OverseasAgent').addClass('d-none');
            $('#vessel').addClass('d-none');
            $('#voyage').addClass('d-none');
            $('#shipStatus').addClass('d-none');
            $('#commodity').addClass('d-none');
            $('#portOfLoading').addClass('d-none');
            $('#portOfDischarge').addClass('d-none');

            // Show the appropriate field based on the selected option
            switch (selectedOption) {
                case 'port_of_discharge_id':
                    $('#portOfDischarge').removeClass('d-none');
                    break;
                case 'job_type':
                    $('#jobType').removeClass('d-none');
                    break;
                case 'cost_center':
                    $('#costCenter').removeClass('d-none');
                    break;
                case 'client_id':
                    $('#clientId').removeClass('d-none');
                    break;
                case 'shipper_id':
                    $('#shipperId').removeClass('d-none');
                    break;
                case 'consignee_id':
                    $('#consigneeId').removeClass('d-none');
                    break;
                case 'sales_rep_id':
                    $('#salesRep').removeClass('d-none');
                    break;
                case 'shipping_line_id':
                    $('#shippingLine').removeClass('d-none');
                    break;
                case 'local_vendor_id':
                    $('#localVendor').removeClass('d-none');
                    break;
                case 'overseas_agent_id':
                    $('#OverseasAgent').removeClass('d-none');
                    break;
                case 'vessel_id':
                    $('#vessel').removeClass('d-none');
                    break;
                case 'voyage_id':
                    $('#voyage').removeClass('d-none');
                    break;
                case 'ship_status_id':
                    $('#shipStatus').removeClass('d-none');
                    break;
                case 'commodity_id':
                    $('#commodity').removeClass('d-none');
                    break;
                case 'port_of_loading_id':
                    $('#portOfLoading').removeClass('d-none');
                    break;
                default:
                    $('#filterInput').removeClass('d-none');
                    break;
            }
        }).trigger('change'); // Trigger change event on page load to set the correct state
    });
</script>
<script>
    function changePerPage(select) {
        const perPage = select.value;
        const urlParams = new URLSearchParams(window.location.search);

        // Add or update your own parameters
        urlParams.set('perPage', perPage);

        // Construct the new URL
        const newUrl = `{{ url('/se_job') }}?${urlParams.toString()}`;

        // Redirect to the new URL
        window.location.href = newUrl;

    }
</script>
<script>
    function handleInvoiceButtonClick(job_master_id, job_status) {
        // console.log(job_master_id)
        if (job_status == 2) {
            window.location.href = '/se_invoice/add/' + job_master_id;
        } else {
            Swal.fire({
                toast: true,
                position: 'top-end',
                icon: 'error',
                title: 'Job is not Approved!',
                showConfirmButton: false,
                timer: 2500
            });
        }
    }

    function handleBillButtonClick(job_master_id, job_status) {

        if (job_status == 2) {
            window.location.href = '/se_bill/add/' + job_master_id;
        } else {
            Swal.fire({
                toast: true,
                position: 'top-end',
                icon: 'error',
                title: 'Job is not Approved!',
                showConfirmButton: false,
                timer: 2500
            });
        }
    }
</script>