<!DOCTYPE html>
<!--
Template Name: Rubick - HTML Admin Dashboard Template
Author: Left4code
Website: http://www.left4code.com/
Contact: muhammadrizki@left4code.com
Purchase: https://themeforest.net/user/left4code/portfolio
Renew Support: https://themeforest.net/user/left4code/portfolio
License: You must have a valid license purchased only from themeforest(the above link) in order to legally use the theme for your project.
-->
<html lang="en" class="light">
<!-- BEGIN: Head -->

<head>
    <meta charset="utf-8">
    <link href="{{ url('favicon.png') }}" rel="shortcut icon">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    {{-- <title>YARAN SHIPPING LINE</title> --}}
    <title style="text-transform: uppercase !important">
        @yield('title')
    </title>
    <!-- BEGIN: CSS Assets-->
    <link rel="stylesheet" href="{{ url('dist/css/app.css') }}" />
    <link href="{{ url('dist/css/select2.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
        <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    @stack('styles')

    {{-- @livewireStyles --}}
    <!-- END: CSS Assets-->
</head>
<!-- END: Head -->

<body class="main">
    <!-- BEGIN: Mobile Menu -->
    <div class="d-flex">
        @include('layout.webmenu')
        <div class="content">

            @include('layout.topbar')

            @yield('content')
        </div>
        <!-- END: Content -->
    </div>

    <script src="https://maps.googleapis.com/maps/api/js?key=[" your-google-map-api"]&libraries=places"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js" crossorigin="anonymous"></script>
    <script src="{{ url('dist/js/app.js') }}"></script>
    <script src="{{ url('dist/js/select2.min.js') }}"></script>
    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>


    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
    <!-- END: JS Assets-->

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.27/dist/sweetalert2.all.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.3.12/jstree.min.js"></script>

    <script>
        $(document).ready(function() {
            // Handle form submission for all forms
            // $('form').on('submit', function() {
            //     // Disable the submit button within the form to prevent multiple submissions
            //     $(this).find('.submitBtn').prop('disabled', true);

            //     // Allow form submission to continue
            //     return true;
            // });

            $('form').on('submit', function(event) {
                let formIsValid = true; // Initialize form validation flag

                // Check if the form contains the input fields you want to validate
                if ($(this).find('input[name="container_seal_no[]"]').length > 0) {

                    $(this).find('input[name="container_seal_no[]"]').each(function() {
                        if ($(this).val().trim() === '') {
                            $(this).addClass('is-invalid'); // Mark input as invalid
                            $(this).next('.invalid-feedback').show(); // Show error message
                            formIsValid = false; // Mark form as invalid
                        } else {
                            $(this).removeClass(
                                'is-invalid'); // Remove invalid state if input is valid
                            $(this).next('.invalid-feedback').hide(); // Hide error message
                        }
                    });
                }
                console.log('formIsValid', formIsValid);
                // Only disable the submit button if the form is valid
                if (formIsValid) {
                    $(this).find('.submitBtn').prop('disabled', true);
                } else {
                    event.preventDefault(); // Prevent form submission if invalid
                }
            });

            $('.select2').select2({
                placeholder: 'Please Select',
                allowClear: true,
                width: '100%'
            });
        });
    </script>
    @if (session()->has('success'))
        <script>
            Swal.fire({
                toast: true,
                position: 'top-end',
                icon: 'success',
                title: {!! json_encode(session('success')) !!},
                showConfirmButton: false,
                timer: 2500
            }).then(() => {
                @php
                    session(['success' => null]);
                @endphp
            });
        </script>
    @endif

    @if ($errors->any())
        {{-- <div class="alert alert-danger">
            @foreach ($errors->all() as $error)
                {{ $error }} <br>
            @endforeach
        </div> --}}
        <script>
            var errors = {!! json_encode($errors->all()) !!};
            errors.forEach(error => {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: error,
                    showConfirmButton: false,
                    timer: 2500
                })
            });
        </script>
    @endif

    @if (session()->has('error'))
        <script>
            Swal.fire({
                toast: true,
                position: 'top-end',
                icon: 'error',
                title: {!! json_encode(session('error')) !!},
                showConfirmButton: false,
                timer: 2500
            }).then(() => {
                @php
                    session(['error' => null]);
                @endphp
            });
        </script>
    @endif
    @stack('scripts')

    {{-- @livewireScripts --}}
</body>

</html>
