@extends('layout.master')

@section('title')
Localization Setup-YARAN
@endsection

@section('topbar')
<a href="/localizationsetups" class="breadcrumb--active">Localization Setup</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Localization Setups
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('localizationsetups.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $localizationsetups->firstItem() }} to
                {{ $localizationsetups->lastItem() }} of {{ $localizationsetups->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Name</th>
                        <th>Caption</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($localizationsetups as $localizationsetup)
                        <tr>
                            <td>{{ $localizationsetup->id }}</td>
                            <td>{{ $localizationsetup->name }}</td>
                            <td>{{ $localizationsetup->caption }}</td>
                            <td>{{ $localizationsetup->status == 1 ? 'Active' : 'InActive' }}</td>
                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('localizationsetups.edit', [$localizationsetup->id]) }}"
                                        class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['localizationsetups.destroy', $localizationsetup->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
