@extends('default')

@section('title')
Location Types-YARAN
@endsection

@section('topbar')
<a href="/location_types" class="breadcrumb--active">Location Types</a>
@endsection
@section('content')

	<div class="d-flex justify-content-end mb-3"><a href="{{ route('location_types.create') }}" class="btn btn-info">Create</a></div>

	<table class="table table-bordered">
		<thead>
			<tr>
				<th>id</th>
				<th>name</th>
				<th>status</th>

				<th>Action</th>
			</tr>
		</thead>
		<tbody>
			@foreach($location_types as $location_type)

				<tr>
					<td>{{ $location_type->id }}</td>
					<td>{{ $location_type->name }}</td>
					<td>{{ $location_type->status }}</td>

					<td>
						<div class="d-flex gap-2">
                            <a href="{{ route('location_types.show', [$location_type->id]) }}" class="btn btn-info">Show</a>
                            <a href="{{ route('location_types.edit', [$location_type->id]) }}" class="btn btn-primary">Edit</a>
                            {!! Form::open(['method' => 'DELETE','route' => ['location_types.destroy', $location_type->id]]) !!}
                                {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                            {!! Form::close() !!}
                        </div>
					</td>
				</tr>

			@endforeach
		</tbody>
	</table>

@stop
