@extends('layout.master')

@section('title')
    Move Account Entries - YARAN
@endsection

@section('topbar')
    <a href="{{ url('accounts') }}" class="breadcrumb-item">Accounts</a>
    <i data-feather="chevron-right" class="breadcrumb__icon"></i>
    <a href="#" class="breadcrumb--active">Move Account Entries</a>
@endsection

@section('content')
    <div class="row mt-5">
        <div class="col-md-12">
            <form method="POST" action="{{ route('accounts.moveEntries') }}" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200">
                        <h2 class="fw-medium fs-base me-auto">
                            Move Account Entries
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Move</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div class="p-5">
                        {{-- @if(session('success'))
                            <div class="alert alert-success">{{ session('success') }}</div>
                        @elseif(session('error'))
                            <div class="alert alert-danger">{{ session('error') }}</div>
                        @endif --}}

                        <div class="row mb-5">
                            <div class="col-md-6">
                                <label for="from_account_id" class="form-label">From Account</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Account" id="from_account_id" name="from_account_id"
                                            class="tom-select w-full" required>
                                        <option value="">Please Select Source Account</option>
                                        @foreach ($accounts as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }} ({{ $account->account_code }})</option>
                                        @endforeach
                                    </select>
                                    @error('from_account_id')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <label for="to_account_id" class="form-label">To Account</label>
                                <div class="mt-2">
                                    <select data-placeholder="Select Account" id="to_account_id" name="to_account_id"
                                            class="tom-select w-full" required>
                                        <option value="">Please Select Target Account</option>
                                        @foreach ($accounts as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }} (ID: {{ $account->account_code }})</option>
                                        @endforeach
                                    </select>
                                    @error('to_account_id')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div> <!-- End of p-5 -->
                </div>
            </form>
        </div>
    </div>
@endsection
