@extends('layout.master')

@section('title')
Near By Port-YARAN
@endsection

@section('topbar')
<a href="/nearbyports" class="breadcrumb--active">Near By Port</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Near By Ports
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('nearbyports.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $nearbyports->firstItem() }} to
                {{ $nearbyports->lastItem() }} of {{ $nearbyports->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Port Code</th>
                        <th>Port Name</th>
                        <th>NearBy Port Code</th>
                        <th>NearBy Port Name</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($nearbyports as $nearbyport)
                        <tr>
                            <td>{{ $nearbyport->id }}</td>
                            <td>{{ $nearbyport->port_code }}</td>
                            <td>{{ $nearbyport->port_name }}</td>
                            <td>{{ $nearbyport->nearby_port_code }}</td>
                            <td>{{ $nearbyport->nearby_port_name }}</td>
                            <td>{{ $nearbyport->status == 1 ? 'Active' : 'InActive' }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('nearbyports.edit', [$nearbyport->id]) }}"
                                        class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['nearbyports.destroy', $nearbyport->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
