@extends('layout.master')

@section('title')
  Opening Balances-YARAN
@endsection

@push('styles')
  <link rel="stylesheet" href="https://cdn.datatables.net/2.0.8/css/dataTables.dataTables.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.3/css/buttons.dataTables.min.css">
@endpush

@section('topbar')
  <a href="{{ url('accounts/invoice') }}" class="breadcrumb--active">Opening Balances</a>
@endsection

@section('content')
  <meta name="csrf-token" content="{{ csrf_token() }}">

  <h2 class="intro-y fs-lg fw-medium mt-10">Opening Balances</h2>

  <div class="grid columns-12 gap-6 mt-5">
    <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
      <div class="col-md-2 mb-3">
        <label for="pagination-size" class="form-label">Rows per page:</label>
        <select id="pagination-size" class="form-select form-select-sm" aria-label="Rows per page">
          <option value="50">50</option>
          <option value="100">100</option>
          <option value="200">200</option>
          <option value="500">500</option>
          <option value="1000">1000</option>
        </select>
      </div>
      <div class="table-responsive">
        <table id="myTable" class="table table-bordered mt-n2" width="100%">
          <thead>
            <tr>
              <th>Id</th>
              <th>Account Code</th>
              <th>Title</th>
              <th>Debit</th>
              <th>Credit</th>
              <th>Currency</th>
              <th>Exchange Rate</th>
              <th>Debit (LC)</th>
              <th>Credit (LC)</th>
              <th>Action</th>
            </tr>
          </thead>
          <tfoot>
            <tr>
              <th colspan="3">Total</th>
              <th id="total-debit">0</th>
              <th id="total-credit">0</th>
              <th colspan="2"></th>
              <th id="total-debit-lc">0</th>
              <th id="total-credit-lc">0</th>
              <th></th>
            </tr>
          </tfoot>
        </table>
      </div>
    </div>
  </div>
@endsection

@push('scripts')
  <script src="https://cdn.datatables.net/2.0.8/js/dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/2.2.3/js/dataTables.buttons.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/vfs-fonts/2.0.0/vfs_fonts.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/2.2.3/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/2.2.3/js/buttons.print.min.js"></script>
  <script>
    $(function () {
      // sanity check
      // console.log('jQuery', $.fn.jquery, 'Has $.fn.DataTable?', !!$.fn.DataTable);

      const table = $('#myTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ url('/accounts/opening_balance/data') }}",
        pageLength: 50,
        lengthMenu: [  // This allows user to select how many rows per page
          [50, 100, 200, 500, 1000],
          [50, 100, 200, 500, 1000]  // The labels that will appear in the dropdown
        ],
        deferRender: true,
        columns: [
          { data: 'id', name: 'id' },
          { data: 'account_code', name: 'account_code' },
          { data: 'name', name: 'name' },
          { data: 'debit', orderable: false, searchable: false },
          { data: 'credit', orderable: false, searchable: false },
          { data: 'currency', orderable: false, searchable: false },
          { data: 'rate', orderable: false, searchable: false },
          { data: 'debit_lc', orderable: false, searchable: false },
          { data: 'credit_lc', orderable: false, searchable: false },
          { data: 'action', orderable: false, searchable: false },
        ],
        dom: 'Bfrtip', // Defines the position of buttons (e.g. export, print)
        buttons: [
          {
            extend: 'csv',
            text: 'Excel',
            footer: true, 
            exportOptions: {
              columns: [0, 1, 2, 3, 4, 7, 8],  // Exclude currency, exchange rate, and action columns
              format: {
                body: function (data, row, column, node) {
                  // If the column contains an input (debit, credit, debit_lc, credit_lc), get the value
                  if (node.querySelector('input')) {
                    const inputValue = node.querySelector('input').value;
                    return inputValue !== '' ? inputValue : '0';  // If input is empty, return '0'
                  }
                  return data;
                }
              }
            }
          }
        ],
        initComplete: function () {
          // Get total values from the API after the table is initialized
          $.ajax({
            url: "{{ url('/accounts/opening_balance/totals') }}",
            method: 'GET',
            success: function (response) {
              console.log('Totals response:', response);

              // Update the totals in the footer
              if (response.total_debit !== undefined && response.total_credit !== undefined) {
                $('#total-debit').text(parseFloat(response.total_debit).toFixed(2));
                $('#total-credit').text(parseFloat(response.total_credit).toFixed(2));
                $('#total-debit-lc').text(parseFloat(response.total_debit_lc).toFixed(2));
                $('#total-credit-lc').text(parseFloat(response.total_credit_lc).toFixed(2));
              }
            },
            error: function (xhr) {
              console.error('Failed to fetch totals:', xhr);
            }
          });
        },
      });
      $('#pagination-size').on('change', function () {
        const newPageLength = $(this).val();
        table.page.len(newPageLength).draw();  // Update the DataTable's pageLength and redraw the table
      });

      // Auto-calc LC when numbers change
      $('#myTable').on('input change', '.debit, .credit, .rate', function () {
        const $row = $(this).closest('tr');
        const debit = parseFloat($row.find('.debit').val()) || 0;
        const credit = parseFloat($row.find('.credit').val()) || 0;
        const rate = parseFloat($row.find('.rate').val()) || 1;
        $row.find('.debit_lc').val((debit * rate).toFixed(2));
        $row.find('.credit_lc').val((credit * rate).toFixed(2));
      });

      // Save a single row via AJAX
      $('#myTable').on('click', '.save-row', function (e) {
        const $row = $(this).closest('tr');
        const id = $(this).data('id');
        const data = {
          account_id: id,
          debit_amount: $row.find('.debit').val(),
          credit_amount: $row.find('.credit').val(),
          currency_id: $row.find('.currency').val(),
          exchange_rate: $row.find('.rate').val(),
          debit_lc: $row.find('.debit_lc').val(),
          credit_lc: $row.find('.credit_lc').val()
        };

        $.ajax({
          url: "{{ url('accounts/opening_balance/save-row') }}",
          method: 'POST',
          headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
          data
        })
          .done(() => {
            $(e.target).text('Saved').removeClass('btn-primary').addClass('btn-success');
            setTimeout(() => $(e.target).text('Save').removeClass('btn-success').addClass('btn-primary'), 1200);
          })
          .fail(xhr => alert(xhr.responseJSON?.message || 'Failed to save row'));
      });
    });
  </script>
@endpush