@extends('layout.master')

@section('title')
Package Codings-YARAN
@endsection

@section('topbar')
<a href="/packages_codings" class="breadcrumb--active">Package Codings</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Package Codings
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('packages_codings.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $packages_codings->firstItem() }} to
                {{ $packages_codings->lastItem() }} of {{ $packages_codings->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Pack Code</th>
                        <th>Pack Name</th>
                        <th>EPAS Code</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($packages_codings as $package_coding)
                        <tr>
                            <td>{{ $package_coding->id }}</td>
                            <td>{{ $package_coding->pack_code }}</td>
                            <td>{{ $package_coding->pack_name }}</td>
                            <td>{{ $package_coding->epas_code }}</td>
                            <td>{{ $package_coding->status == 1 ? 'Active' : 'InActive' }}</td>
                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('packages_codings.edit', [$package_coding->id]) }}"
                                        class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['packages_codings.destroy', $package_coding->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
