@extends('layout.master')

@section('title')
    Add-Party-YARAN
@endsection

@section('topbar')
    <a href="/party" class="breadcrumb-item">Party</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a
        href="" class="breadcrumb--active">Add</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/party/add') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Add Party
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Party</label>
                                    <select data-placeholder="Select Country" name="party_is" class="select2 w-full">
                                        <option value="customer">Customer</option>
                                        <option value="vendor">Vendor</option>
                                        <option value="customer_vendor">Customer/Vendor</option>
                                        <option value="non_gl_parties">Non GL Parties</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Name<span
                                            style="color: red;">*</span></label>
                                    <input id="regular-form-1" required type="text" class="form-control"
                                        placeholder="Enter Name" name="name">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Reg. Date</label>
                                    <input id="regular-form-1" type="date" class="form-control"
                                        placeholder="Enter Reg. Date" value="{{ \Carbon\Carbon::now()->format('Y-m-d') }}"
                                        name="reg_date">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">License No.</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter License No." name="license_no">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Operations<span style="color: red;">*</span></label>
                                    <div class="mt-2">
                                        <select multiple required data-placeholder="Select Operations" name="operation_id[]"
                                            class="select2 w-full">
                                            <option value="0">All Operations</option>
                                            @foreach ($party_operations as $party_operation)
                                                <option value="{{ $party_operation->id }}">{{ $party_operation->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Party Type<span style="color: red;">*</span></label>
                                    <div class="mt-2">
                                        <select multiple required data-placeholder="Select Party Type" id="type"
                                            name="type_id[]" class="select2 w-full">
                                            @foreach ($party_types as $party_type)
                                                <option value="{{ $party_type->id }}">{{ $party_type->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Contact Person</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Contact Person" name="contact_person">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">NTN #</label>
                                    <input id="regular-form-1" type="text" class="form-control" placeholder="Enter NTN #"
                                        name="ntn_no">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">STRN #</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter STRN #" name="strn_no">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Email</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Email" name="email">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Website</label>
                                    <input id="regular-form-1" type="text" class="form-control "
                                        placeholder="Enter Website" name="website">
                                </div>
                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Address</label>
                                    <textarea name="address" class="form-control" id="" cols="30" rows="2"></textarea>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Country</label>
                                    <select data-placeholder="Select Country" id="country_id" name="country_id"
                                        class="select2 w-full">
                                        <option value=""></option>
                                        @foreach ($countries as $country)
                                            <option value="{{ $country->id }}">{{ $country->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">City<span
                                            style="color: red;">*</span></label>
                                    <select required data-placeholder="Select City" id="city_id" name="city_id"
                                        class="select2 w-full">
                                        <option value=""></option>
                                        {{-- @foreach ($cities as $city)
                                            <option value="{{ $city->id }}">{{ $city->name }}
                                            </option>
                                        @endforeach --}}
                                    </select>
                                </div>
                                <div class="col-md-2 mt-2">
                                    <label for="regular-form-1" class="form-label">Phone No.</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Phone No." name="phone_no">
                                </div>
                                <div class="col-md-2 mt-2">
                                    <label for="regular-form-1" class="form-label">Phone No. 2</label>
                                    <input id="regular-form-1" type="text" class="form-control "
                                        placeholder="Enter Phone No." name="mobile">
                                </div>
                                {{-- <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Zip Code</label>
                                    <input id="regular-form-1" type="text" class="form-control "
                                        placeholder="Enter Zip Code" name="zip_code">
                                </div> --}}

                                <div class="col-md-3 d-flex align-items-end">
                                    <div class="form-group me-5">
                                        <input id="regular-form-1" type="checkbox" class="form-check-input"
                                            name="import_nomination" value="1">
                                        <label class="form-label" for="import_nomination">
                                            Import Nomination
                                        </label>
                                    </div>
                                    <div class="form-group">
                                        <input id="regular-form-1" type="checkbox" class="form-check-input"
                                            name="export_nomination" value="1">
                                        <label class="form-label" for="export_nomination">
                                            Export Nomination
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-3 d-flex flex-column justify-content-end mt-3">
                                    <div class="form-group">
                                        <input id="regular-form-1" type="checkbox" class="form-check-input"
                                            name="company_restriction" value="1">
                                        <label class="form-label" for="company_restriction">
                                            Apply Company Restriction
                                        </label>
                                    </div>
                                    <div class="form-group">
                                        <input id="regular-form-1" type="checkbox" class="form-check-input"
                                            name="cost_center_restriction" value="1">
                                        <label class="form-label" for="cost_center_restriction">
                                            Apply Cost Center Restriction
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <label>Status</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Status" id="status" name="status"
                                            class="tom-select w-full">
                                            <option value="1">Active</option>
                                            <option value="0">In Active</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3 d-flex flex-column justify-content-end mt-3">
                                    <div class="form-group">
                                        <input id="manual_account" type="checkbox" class="form-check-input"
                                            name="manual_account" value="1">
                                        <label class="form-label" for="manual_account">
                                            Manual Account
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-3 d-flex flex-column justify-content-end mt-3">
                                    <div class="form-group">
                                        <input id="existing_account" type="checkbox" class="form-check-input"
                                            name="existing_account" value="1">
                                        <label class="form-label" for="existing_account">
                                            Existing Account
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div id="add-acc">
                                <div class="col-md-4">
                                    <label>Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Account" id="child_account_id"
                                            name="child_account_id" class="select2 w-full">
                                            <option value="">Please Select Account
                                            </option>
                                            @foreach ($child_accounts as $account)
                                                <option value="{{ $account->id }}">
                                                    {{ $account->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div id="add-coa">
                                <div
                                    class="d-flex flex-column flex-sm-row align-items-center pb-5 border-bottom border-gray-200 dark-border-dark-5">
                                    <h2 class="fw-medium fs-base me-auto">
                                        Add Chart of Account
                                    </h2>
                                </div>

                                <div class="row mb-5">

                                    <div class="col-md-4">
                                        <label>Parent Account</label>
                                        <div class="mt-2">
                                            <select data-placeholder="Select Account" id="parent_account_id"
                                                name="parent_account_id" class="select2 w-full">
                                                <option value="">Please Select Parent Account
                                                </option>
                                                @foreach ($parent_accounts as $account)
                                                    <option value="{{ $account->id }}">
                                                        {{ $account->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <label for="regular-form-1" class="form-label">Account Code</label>
                                        <input id="regular-form-1" type="text" class="form-control"
                                            placeholder="Enter Account Code" name="account_code">
                                    </div>

                                    <div class="col-md-4 mt-2">
                                        <label for="regular-form-1" class="form-label">Name</label>
                                        <input id="regular-form-1" type="text" class="form-control"
                                            placeholder="Enter Name" name="coa_name">
                                    </div>

                                    <div class="col-md-6 mt-2">
                                        <label for="regular-form-1" class="form-label">Alias</label>
                                        <input id="regular-form-1" type="text" class="form-control"
                                            placeholder="Enter Alias" name="alias">
                                    </div>

                                    <div class="col-md-6 mt-2">
                                        <label>Max Child Account</label>
                                        <div class="mt-2">
                                            <select data-placeholder="Select Max Child Account" id="max_child_account"
                                                name="max_child_account" class="select2 w-full">
                                                <option value="99">99</option>
                                                <option value="999">999</option>
                                                <option value="999">999</option>
                                                <option value="9999">9999</option>
                                                <option value="99999">99999</option>
                                                <option value="999999">999999</option>
                                                <option value="9999999">9999999</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mt-2">
                                        <label>Category</label>
                                        <div class="mt-2">
                                            <select data-placeholder="Select Category" id="category_id"
                                                name="category_id" class="select2 w-full">
                                                <option value="">Please Select Category</option>
                                                @foreach ($account_categories as $category)
                                                    <option value="{{ $category->id }}">
                                                        {{ $category->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mt-2">
                                        <label>Sub Category</label>
                                        <div class="mt-2">
                                            <select data-placeholder="Select Sub Category" id="sub_category_id"
                                                name="sub_category_id" class="select2 w-full">
                                                <option value="">Please Select Sub Category</option>
                                                @foreach ($account_sub_categories as $sub_category)
                                                    <option value="{{ $sub_category->id }}">
                                                        {{ $sub_category->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mt-2">
                                        <label for="regular-form-1" class="form-label">Reference
                                            No</label>
                                        <input id="regular-form-1" type="text" class="form-control"
                                            placeholder="Enter Reference No" name="reference_number">
                                    </div>

                                    <div class="col-md-6 mt-2">
                                        <label>Status</label>
                                        <div class="mt-2">
                                            <select data-placeholder="Select Status" id="status" name="status"
                                                class="select2 w-full">
                                                <option value="1">Active</option>
                                                <option value="0">In Active</option>
                                            </select>
                                        </div>
                                    </div>

                                </div>
                            </div>
            </form>
        </div>
    </div>
    </div>
    </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#add-coa').hide();
            $('#add-acc').hide();
            $('#manual_account').change(function() {
                if ($(this).is(':checked')) {
                    $('#existing_account').prop('checked', false);
                    $('#add-coa').show();
                    $('#add-acc').hide();
                } else {
                    $('#add-coa').hide();
                }
            });
            $('#existing_account').change(function() {
                if ($(this).is(':checked')) {
                    $('#manual_account').prop('checked', false);
                    $('#add-coa').hide();
                    $('#add-acc').show();
                } else {
                    $('#add-acc').hide();
                }
            });

            $('#country_id').change(function() {
                var countryId = $(this).val();

                if (countryId) {
                    $.ajax({
                        url: '/api/get-cities/' + countryId,
                        type: 'GET',
                        success: function(data) {
                            var citiesDropdown = $('#city_id');
                            citiesDropdown.empty(); // Clear any existing options
                            citiesDropdown.append(
                                '<option value="">Select City</option>'); // Add default option

                            $.each(data.data, function(key, city) {
                                citiesDropdown.append('<option value="' + city.id +
                                    '">' + city.name + '</option>');
                            });
                        },
                        error: function() {
                            console.log('response', 'error');
                        }
                    });
                } else {
                    $('#city_id').empty(); // Clear the cities dropdown
                    $('#city_id').append('<option value="">Select City</option>'); // Add default option
                }
            });

        })
    </script>
@endsection
