@extends('layout.master')

@section('title')
    edit-Party-YARAN
@endsection

@section('topbar')
    <a href="/party" class="breadcrumb-item">Party</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a
        href="" class="breadcrumb--active">Edit</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/party/edit' . '/' . $party->id) }}"
                enctype="multipart/form-data" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Edit Party
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Party</label>
                                    <select data-placeholder="Select Party" name="party_is" class="select2 w-full">
                                        <option {{ $party->party_is == 'customer' ? 'selected' : '' }} value="customer">
                                            Customer</option>
                                        <option {{ $party->party_is == 'vendor' ? 'selected' : '' }} value="vendor">Vendor
                                        </option>
                                        <option {{ $party->party_is == 'customer_vendor' ? 'selected' : '' }}
                                            value="customer_vendor">Customer/Vendor</option>
                                        <option {{ $party->party_is == 'non_gl_parties' ? 'selected' : '' }}
                                            value="non_gl_parties">Non GL Parties</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Name</label>
                                    <input id="regular-form-1" value="{{ $party->name }}" type="text"
                                        class="form-control" placeholder="Enter Name" name="name">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Reg. Date</label>
                                    <input id="regular-form-1" value="{{ $party->reg_date }}" type="date"
                                        class="form-control" placeholder="Enter Reg. Date" name="reg_date">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">License No.</label>
                                    <input id="regular-form-1" value="{{ $party->license_no }}" type="text"
                                        class="form-control" placeholder="Enter License No." name="license_no">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Contact Person</label>
                                    <input id="regular-form-1" value="{{ $party->contact_person }}" type="text"
                                        class="form-control" placeholder="Enter Contact Person" name="contact_person">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">NTN #</label>
                                    <input id="regular-form-1" value="{{ $party->ntn_no }}" type="text"
                                        class="form-control" placeholder="Enter NTN #" name="ntn_no">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">STRN #</label>
                                    <input id="regular-form-1" value="{{ $party->strn_no }}" type="text"
                                        class="form-control" placeholder="Enter STRN #" name="strn_no">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Email</label>
                                    <input id="regular-form-1" value="{{ $party->email }}" type="text"
                                        class="form-control" placeholder="Enter Email" name="email">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Phone No.</label>
                                    <input id="regular-form-1" value="{{ $party->phone_no }}" type="text"
                                        class="form-control" placeholder="Enter Phone No." name="phone_no">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Phone No. 2</label>
                                    <input id="regular-form-1" value="{{ $party->mobile }}" type="text"
                                        class="form-control " placeholder="Enter Phone No." name="mobile">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Website</label>
                                    <input id="regular-form-1" value="{{ $party->website }}" type="text"
                                        class="form-control " placeholder="Enter Website" name="website">
                                </div>
                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Address</label>
                                    <textarea name="address" class="form-control" id="" cols="30" rows="2">{{ $party->address }}</textarea>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Country</label>
                                    <select data-placeholder="Select Country" id="country_id" name="country_id"
                                        class="select2 w-full">
                                        <option value=""></option>
                                        @foreach ($countries as $country)
                                            <option {{ $party->country_id == $country->id ? 'selected' : '' }}
                                                value="{{ $country->id }}">{{ $country->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">City</label>
                                    <select data-placeholder="Select City" id="city_id" name="city_id"
                                        class="select2 w-full">
                                        <option value=""></option>
                                        {{-- @foreach ($cities as $city)
                                            <option value="{{ $city->id }}">{{ $city->name }}
                                            </option>
                                        @endforeach --}}
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Zip Code</label>
                                    <input id="regular-form-1" value="{{ $party->zip_code }}" type="text"
                                        class="form-control " placeholder="Enter Zip Code" name="zip_code">
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label>Operations</label>
                                    <div class="mt-2">
                                        <select multiple required data-placeholder="Select Operations"
                                            name="operation_id[]" class="select2 w-full">
                                            <option
                                                {{ $party->party_operations->contains('operation_id', 0) ? 'selected' : '' }}
                                                value="0">All Operations</option>
                                            @foreach ($party_operations as $party_operation)
                                                <option
                                                    {{ $party->party_operations->contains('operation_id', $party_operation->id) ? 'selected' : '' }}
                                                    value="{{ $party_operation->id }}">{{ $party_operation->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label>Party Type</label>
                                    <div class="mt-2">
                                        <select multiple required data-placeholder="Select Party Type" id="type_id"
                                            name="type_id[]" class="select2 form-control w-full">
                                            @foreach ($party_types as $party_type)
                                                <option
                                                    {{ $party->party_type->contains('type_id', $party_type->id) ? 'selected' : '' }}
                                                    value="{{ $party_type->id }}">{{ $party_type->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 d-flex align-items-end">
                                    <div class="form-group me-5">
                                        <input id="regular-form-1" {{ $party->import_nomination == '1' ? 'checked' : '' }}
                                            type="checkbox" class="form-check-input" name="import_nomination"
                                            value="1">
                                        <label class="form-label" for="import_nomination">
                                            Import Nomination
                                        </label>
                                    </div>
                                    <div class="form-group">
                                        <input id="regular-form-1" type="checkbox" class="form-check-input"
                                            name="export_nomination"
                                            {{ $party->export_nomination == '1' ? 'checked' : '' }} value="1">
                                        <label class="form-label" for="export_nomination">
                                            Export Nomination
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-4 d-flex flex-column justify-content-end mt-3">
                                    <div class="form-group">
                                        <input id="regular-form-1" type="checkbox" class="form-check-input"
                                            name="company_restriction" value="1"
                                            {{ $party->company_restriction == '1' ? 'checked' : '' }}>
                                        <label class="form-label" for="company_restriction">
                                            Apply Company Restriction
                                        </label>
                                    </div>
                                    <div class="form-group">
                                        <input id="regular-form-1" type="checkbox" class="form-check-input"
                                            name="cost_center_restriction" value="1"
                                            {{ $party->cost_center_restriction == '1' ? 'checked' : '' }}>
                                        <label class="form-label" for="cost_center_restriction">
                                            Apply Cost Center Restriction
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label>Status</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Status" id="status" name="status"
                                            class="tom-select w-full">
                                            <option {{ $party->status == '1' ? 'selected' : '' }} value="1">Active
                                            </option>
                                            <option {{ $party->status == '0' ? 'selected' : '' }} value="0">In Active
                                            </option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div
                                class="d-flex flex-column flex-sm-row align-items-center pb-5 border-bottom border-gray-200 dark-border-dark-5">
                                <h2 class="fw-medium fs-base me-auto">
                                    Edit Chart of Account
                                </h2>
                            </div>

                            <div class="row mb-5">

                                <div class="col-md-6">
                                    <label>Parent Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Account" id="parent_account_id"
                                            name="parent_account_id" class="select2 w-full">
                                            <option value="">Please Select Parent Account</option>
                                            @foreach ($parent_accounts as $account)
                                                <option
                                                    {{ @$party->chart_of_account->parent_account_id == $account->id ? 'selected' : '' }}
                                                    value="{{ $account->id }}">{{ $account->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label for="regular-form-1" class="form-label">Account Code</label>
                                    <input value="{{ @$party->chart_of_account->account_code }}" id="regular-form-1"
                                        type="text" class="form-control name-validate"
                                        placeholder="Enter Account Code" name="account_code">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Name</label>
                                    <input value="{{ @$party->chart_of_account->name }}" id="regular-form-1" required
                                        type="text" class="form-control name-validate" placeholder="Enter Name"
                                        name="coa_name">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Alias</label>
                                    <input value="{{ @$party->chart_of_account->alias }}" id="regular-form-1"
                                        type="text" class="form-control name-validate" placeholder="Enter Alias"
                                        name="alias">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Max Child Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Max Child Account" id="max_child_account"
                                            name="max_child_account" class="select2 w-full">
                                            <option
                                                {{ @$party->chart_of_account->max_child_account == '99' ? 'selected' : '' }}
                                                value="99">99</option>
                                            <option
                                                {{ @$party->chart_of_account->max_child_account == '999' ? 'selected' : '' }}
                                                value="999">999</option>
                                            <option
                                                {{ @$party->chart_of_account->max_child_account == '999' ? 'selected' : '' }}
                                                value="999">999</option>
                                            <option
                                                {{ @$party->chart_of_account->max_child_account == '9999' ? 'selected' : '' }}
                                                value="9999">9999</option>
                                            <option
                                                {{ @$party->chart_of_account->max_child_account == '99999' ? 'selected' : '' }}
                                                value="99999">99999</option>
                                            <option
                                                {{ @$party->chart_of_account->max_child_account == '999999' ? 'selected' : '' }}
                                                value="999999">999999</option>
                                            <option
                                                {{ @$party->chart_of_account->max_child_account == '9999999' ? 'selected' : '' }}
                                                value="9999999">9999999</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Category</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Category" id="category_id" name="category_id"
                                            class="select2 w-full">
                                            <option value="">Please Select Category</option>
                                            @foreach ($account_categories as $category)
                                                <option
                                                    {{ @$party->chart_of_account->category_id == $category->id ? 'selected' : '' }}
                                                    value="{{ $category->id }}">{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Sub Category</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Sub Category" id="sub_category_id"
                                            name="sub_category_id" class="select2 w-full">
                                            <option value="">Please Select Sub Category</option>
                                            @foreach ($account_sub_categories as $sub_category)
                                                <option
                                                    {{ @$party->chart_of_account->sub_category_id == $sub_category->id ? 'selected' : '' }}
                                                    value="{{ $sub_category->id }}">{{ $sub_category->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Reference No</label>
                                    <input value="{{ @$party->chart_of_account->reference_number }}" id="regular-form-1"
                                         type="text" class="form-control name-validate"
                                        placeholder="Enter Reference No" name="reference_number">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Status</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Status" id="status" name="status"
                                            class="select2 w-full">
                                            <option {{ @$party->chart_of_account->status == 1 ? 'selected' : '' }}
                                                value="1">Active
                                            </option>
                                            <option {{ @$party->chart_of_account->status == 0 ? 'selected' : '' }}
                                                value="0">In Active
                                            </option>
                                        </select>
                                    </div>
                                </div>

                            </div>
            </form>
        </div>
    </div>
    </div>
    </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            var countryId = $('#country_id').val();
            loadCitiesByCountry(countryId);

            $('#add-coa').hide();
            $('#manual_account').change(function() {
                if ($(this).is(':checked')) {
                    $('#add-coa').show();
                } else {
                    $('#add-coa').hide();
                }
            });

            function loadCitiesByCountry(countryId) {
                if (countryId) {
                    var selectedCityId = '{{ $party->city_id }}';
                    $.ajax({
                        url: '/api/get-cities/' + countryId,
                        type: 'GET',
                        success: function(data) {
                            var citiesDropdown = $('#city_id');
                            citiesDropdown.empty(); // Clear any existing options
                            citiesDropdown.append(
                                '<option value="">Select City</option>'); // Add default option

                            // Append city options from the response data
                            $.each(data.data, function(key, city) {
                                var isSelected = city.id == selectedCityId ? 'selected' : '';
                                citiesDropdown.append('<option value="' + city.id + '" ' +
                                    isSelected + '>' + city.name + '</option>');
                            });
                        },
                        error: function() {
                            console.log('response', 'error');
                        }
                    });
                } else {
                    // Clear the cities dropdown and add the default option
                    $('#city_id').empty().append('<option value="">Select City</option>');
                }
            }

            // Call the function on country dropdown change event
            $('#country_id').change(function() {
                var countryId = $(this).val();
                loadCitiesByCountry(countryId);
            });


            // Call the function on country dropdown change event
            $('#country_id').change(function() {
                var countryId = $(this).val();
                loadCitiesByCountry(countryId);
            });

        })
    </script>
@endsection
