@extends('layout.master')

@section('title')
    Party-YARAN
@endsection

@section('topbar')
    <a href="/party" class="breadcrumb--active">Party</a>
@endsection
@section('content')
    <div class="intro-y d-flex align-items-center">
        <div class="d-flex align-items-center">
            <h2 class="intro-y fs-lg fw-medium mt-6">
                Party
            </h2>
        </div>
        <div class="ms-auto mt-10">
            <button class="btn btn-primary dark-text-theme-10" type="button" data-bs-toggle="collapse"
                data-bs-target="#faq-accordion-collapse-1" aria-expanded="true" aria-controls="faq-accordion-collapse-1"> <i
                    data-feather="filter" class="w-4 h-4 me-3"></i> Filters
            </button>
        </div>
    </div>
    <div id="faq-accordion-collapse-1" class="accordion-collapse collapse mt-5" aria-labelledby="faq-accordion-content-1"
        data-bs-parent="#faq-accordion-1">
        <div class="grid columns-12 gap-6 mt-5">
            <div class="intro-y g-col-12 g-col-lg-12">
                <!-- BEGIN: Form Layout -->
                <div class="intro-y box p-5">
                    <form method="GET" id="myForm" action="{{ url('/party') }}">
                        <div class="row">
                            <div class="col-md-3">
                                <div>
                                    <label for="filterBy" class="form-label">Select</label>
                                    <select name="filterBy" id="filterBy" class="form-control">
                                        <option value="" {{ request('filterBy') == '' ? 'selected' : '' }}>Select
                                        </option>
                                        <option value="party_is" {{ request('filterBy') == 'party_is' ? 'selected' : '' }}>
                                            Party</option>
                                        <option value="name" {{ request('filterBy') == 'name' ? 'selected' : '' }}>Name
                                        </option>
                                        <option value="ntn_no" {{ request('filterBy') == 'ntn_no' ? 'selected' : '' }}>NTN #
                                        </option>
                                        <option value="strn_no" {{ request('filterBy') == 'strn_no' ? 'selected' : '' }}>
                                            STRN #</option>
                                        <option value="city_id" {{ request('filterBy') == 'city_id' ? 'selected' : '' }}>
                                            City</option>
                                        <option value="country_id"
                                            {{ request('filterBy') == 'country_id' ? 'selected' : '' }}>Country</option>
                                        <option value="email" {{ request('filterBy') == 'email' ? 'selected' : '' }}>Email
                                        </option>
                                        <option value="phone_no" {{ request('filterBy') == 'phone_no' ? 'selected' : '' }}>
                                            Phone No.</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3" id="filterInput">
                                <label for="filterValue" class="form-label">Name</label>
                                <input type="text" name="filterValue" class="form-control"
                                    value="{{ request('filterValue') }}" placeholder="Enter Name or ID" name="name"
                                    aria-label="Enter Name">
                            </div>
                            <div class="col-md-3 d-none" id="partyIs">
                                <label for="party_is" class="form-label">Party</label>
                                <select data-placeholder="Select Party" id="party_is" name="party_is"
                                    class="tom-select w-full">
                                    <option {{ request('party_is') == 'customer' ? 'selected' : '' }} value="customer">
                                        Customer</option>
                                    <option {{ request('party_is') == 'vendor' ? 'selected' : '' }} value="vendor">Vendor
                                    </option>
                                    <option {{ request('party_is') == 'customer_vendor' ? 'selected' : '' }}
                                        value="customer_vendor">Customer/Vendor</option>
                                    <option {{ request('party_is') == 'non_gl_parties' ? 'selected' : '' }}
                                        value="non_gl_parties">Non GL Parties</option>
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="cityId">
                                <label for="city_id" class="form-label">City</label>
                                <select data-placeholder="Select City" id="city_id" name="city_id"
                                    class="tom-select w-full">
                                    <option value=""></option>
                                    @foreach ($cities as $city)
                                        <option {{ request('city_id') == $city->id ? 'selected' : '' }}
                                            value="{{ $city->id }}">{{ $city->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none" id="countryId">
                                <label for="country_id" class="form-label">Country</label>
                                <select data-placeholder="Select Country" id="country_id" name="country_id"
                                    class="tom-select w-full">
                                    <option value=""></option>
                                    @foreach ($countries as $country)
                                        <option {{ request('country_id') == $country->id ? 'selected' : '' }}
                                            value="{{ $country->id }}">{{ $country->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label>Status</label>
                                <select data-placeholder="Select Status" id="status" name="status"
                                    class="tom-select w-full mt-2">
                                    <option value="" {{ request('status') == '' ? 'selected' : '' }}>Select
                                    </option>
                                    <option {{ request('status') == '1' ? 'selected' : '' }} value="1">Active
                                    </option>
                                    <option {{ request('status') == '2' ? 'selected' : '' }} value="2">In Active
                                    </option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="date_filter" class="form-label">Date Filter</label>
                                <select name="date_filter" id="date_filter" class="form-control">
                                    <option value="" {{ request('date_filter') == '' ? 'selected' : '' }}>Select
                                    </option>
                                    <option value="today" {{ request('date_filter') == 'today' ? 'selected' : '' }}>Today
                                    </option>
                                    <option value="this_week"
                                        {{ request('date_filter') == 'this_week' ? 'selected' : '' }}>This Week</option>
                                    <option value="this_month"
                                        {{ request('date_filter') == 'this_month' ? 'selected' : '' }}>This Month</option>
                                    <option value="custom" {{ request('date_filter') == 'custom' ? 'selected' : '' }}>
                                        Custom</option>
                                </select>
                            </div>
                            <div class="col-md-3" id="customDateRange"
                                style="display: {{ request('date_filter') == 'custom' ? 'block' : 'none' }};">
                                <label for="date_from" class="form-label">From</label>
                                <input type="date" name="date_from" class="form-control"
                                    value="{{ request('date_from') }}">
                            </div>
                            <div class="col-md-3" id="customDateRangeTwo"
                                style="display: {{ request('date_filter') == 'custom' ? 'block' : 'none' }};">
                                <label for="date_to" class="form-label">To</label>
                                <input type="date" name="date_to" class="form-control"
                                    value="{{ request('date_to') }}">
                            </div>
                            <div class="col-md-3 mt-8">
                                <button type="submit" class="btn btn-sm btn-elevated-primary w-24">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20"
                                        height="20" class="main-grid-item-icon" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                        <circle cx="11" cy="11" r="8" />
                                        <line x1="21" x2="16.65" y1="21" y2="16.65" />
                                    </svg>
                                    Search</button>
                                <a href="{{ url('/party') }}" type="button"
                                    class="btn btn-sm btn-elevated-danger w-24">
                                    {{-- <i data-feather="x"></i> --}}
                                    <!-- https://feathericons.dev/?search=x&iconset=feather -->
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20"
                                        height="20" class="main-grid-item-icon" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                        <line x1="18" x2="6" y1="6" y2="18" />
                                        <line x1="6" x2="18" y1="6" y2="18" />
                                    </svg>
                                    Clear</a>
                            </div>
                    </form>
                </div>
            </div>
            <!-- END: Form Layout -->
        </div>
    </div>
    </div>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ url('/party/add') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $partys->firstItem() }} to
                {{ $partys->lastItem() }} of {{ $partys->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <form id="MyForm" method="post" action="{{ url('/role/index') }}">
                        @csrf
                        <tr>
                            <th>Id</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Status</th>
                            <th>Actions</th>
                    </form>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($partys as $party)
                        <tr>
                            <td>{{ $party->id }}</td>
                            <td>{{ $party->name }}</td>
                            <td>{{ $party->email }}</td>
                            <td>{{ $party->status == 1 ? 'Active' : 'InActive' }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    @can('User_Edit')
                                        <a class="btn btn-primary me-2 p-2" href="{{ url('/party/edit/' . $party->id) }}"><i
                                                data-feather="edit" class="w-4 h-4"></i> </a>
                                    @endcan
                                    @can('User_Delete')
                                        <form method="post" action="{{ url('/party/delete/' . $party->id) }}">
                                            @csrf
                                            <button type="submit" class="btn btn-danger p-2">
                                                <i data-feather="trash-2" class="w-4 h-4"></i>
                                            </button>
                                        </form>
                                        {{-- <div class="g-col-6 g-col-sm-3 g-col-lg-2 g-col-xl-1">
                                    <i data-feather="trash-2" class="d-block mx-auto"></i>
                                    <div class="text-center fs-xs mt-2">trash-2</div>
                                </div> --}}
                                    @endcan
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="grid columns-12 gap-6 mt-4">
            <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center">
                <div class="d-flex d-md-block mx-auto text-gray-600">
                    <?php echo $partys->appends(request()->query())->links('pagination::bootstrap-4'); ?>
                </div>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {

            document.getElementById('date_filter').addEventListener('change', function() {
                var customDateRange = document.getElementById('customDateRange');
                var customDateRangeTwo = document.getElementById('customDateRangeTwo');
                if (this.value === 'custom') {
                    customDateRange.style.display = 'block';
                    customDateRangeTwo.style.display = 'block';
                } else {
                    customDateRange.style.display = 'none';
                    customDateRangeTwo.style.display = 'none';
                }
            });

            $('#filterBy').change(function() {
                var selectedOption = $(this).val();

                // Clear all input fields
                $('#filterInput input').val('');
                $('#partyIs select').val('');
                $('#cityId select').val('');
                $('#countryId select').val('');

                // Hide all optional fields initially
                $('#filterInput').addClass('d-none');
                $('#partyIs').addClass('d-none');
                $('#cityId').addClass('d-none');
                $('#countryId').addClass('d-none');

                // Show the appropriate field based on the selected option
                switch (selectedOption) {
                    case 'party_is':
                        $('#partyIs').removeClass('d-none');
                        break;
                    case 'city_id':
                        $('#cityId').removeClass('d-none');
                        break;
                    case 'country_id':
                        $('#countryId').removeClass('d-none');
                        break;
                    default:
                        $('#filterInput').removeClass('d-none');
                        break;
                }
            }).trigger('change'); // Trigger change event on page load to set the correct state
        });
    </script>
@endsection
