@extends('layout.master')

@section('title')
    Add-Party Location-YARAN
@endsection

@section('topbar')
    <a href="/party_location" class="breadcrumb-item">Party Location</a><i data-feather="chevron-right"
        class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/party_location/add') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Add Party Location
                        </h2>
                        
                        <button type="submit" class="btn btn-primary submitBtn"
                            id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="col-md-4 mt-2">
                                    <label for="regular-form-1" class="form-label">Party</label>
                                    <select data-placeholder="Select City" id="party_id" name="party_id"
                                        class="tom-select w-full">
                                        <option value=""></option>
                                        @foreach ($parties as $party)
                                            <option value="{{ $party->id }}">{{ $party->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="regular-form-1" class="form-label">Name</label>
                                    <input id="regular-form-1" type="text" class="form-control" placeholder="Enter Name"
                                        name="name">
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="regular-form-1" class="form-label">Contact Person</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Contact Person" name="contact_person">
                                </div>
                                <div class="col-md-8 mt-2">
                                    <label for="regular-form-1" class="form-label">Address</label>
                                    <textarea name="address" class="form-control" id="" cols="30" rows="2"></textarea>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="regular-form-1" class="form-label">City</label>
                                    <select data-placeholder="Select City" id="type" name="city_id"
                                        class="tom-select w-full">
                                        <option value=""></option>
                                        @foreach ($cities as $city)
                                            <option value="{{ $city->id }}">{{ $city->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="regular-form-1" class="form-label">State</label>
                                    <input id="regular-form-1" type="text" class="form-control "
                                        placeholder="Enter State" name="state">
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="regular-form-1" class="form-label">Country</label>
                                    <select data-placeholder="Select Country" id="type" name="country_id"
                                        class="tom-select w-full">
                                        <option value=""></option>
                                        @foreach ($countries as $country)
                                            <option value="{{ $country->id }}">{{ $country->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="regular-form-1" class="form-label">Remarks</label>
                                    <textarea name="remarks" class="form-control" id="" cols="30" rows="2"></textarea>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label>Location Type</label>
                                    <div class="mt-2">
                                        <select multiple data-placeholder="Select Location Type" id="type"
                                            name="type_id[]" class="tom-select w-full">
                                            @foreach ($location_types as $location_type)
                                                <option value="{{ $location_type->id }}">{{ $location_type->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label>Status</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Status" id="status" name="status"
                                            class="tom-select w-full">
                                            <option value="1">Active</option>
                                            <option value="0">In Active</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
            </form>
        </div>
    </div>
    </div>
    </div>
    </div>
@endsection
