@extends('layout.master')

@section('title')
Party Location-YARAN
@endsection


@section('topbar')
<a href="/party_location" class="breadcrumb--active">Party Location</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Party Location
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ url('/party_location/add') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $party_locations->firstItem() }} to
                {{ $party_locations->lastItem() }} of {{ $party_locations->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($party_locations as $party_location)
                        <tr>
                            <td>{{ $party_location->id }}</td>
                            <td>{{ $party_location->name }}</td>
                            <td>{{ $party_location->email }}</td>
                            <td>{{ $party_location->status == 1 ? 'Active' : 'InActive' }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    @can('User_Edit')
                                        <a class="btn btn-primary me-2 p-2"
                                            href="{{ url('/party_location/edit/' . $party_location->id) }}"><i
                                                data-feather="edit" class="w-4 h-4"></i> </a>
                                    @endcan
                                    @can('User_Delete')
                                        <form method="post"
                                            action="{{ url('/party_location/delete/' . $party_location->id) }}">
                                            @csrf
                                            <button type="submit" class="btn btn-danger p-2">
                                                <i data-feather="trash-2" class="w-4 h-4"></i>
                                            </button>
                                        </form>
                                        {{-- <div class="g-col-6 g-col-sm-3 g-col-lg-2 g-col-xl-1">
                                    <i data-feather="trash-2" class="d-block mx-auto"></i>
                                    <div class="text-center fs-xs mt-2">trash-2</div>
                                </div> --}}
                                    @endcan
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
