@extends('layout.master')

@section('title')
Party SCAC/IATA Codes-YARAN
@endsection

@section('topbar')
<a href="/party_s_c_a_c__i_a_t_a__codes" class="breadcrumb--active">Party SCAC/IATA Codes</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Party SCAC/IATA Codes
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('party_s_c_a_c__i_a_t_a__codes.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $party_s_c_a_c__i_a_t_a__codes->firstItem() }} to
                {{ $party_s_c_a_c__i_a_t_a__codes->lastItem() }} of {{ $party_s_c_a_c__i_a_t_a__codes->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Code</th>
                        <th>Name</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($party_s_c_a_c__i_a_t_a__codes as $party_scac_iata_code)
                        <tr>
                            <td>{{ $party_scac_iata_code->id }}</td>
                            <td>{{ $party_scac_iata_code->code }}</td>
                            <td>{{ $party_scac_iata_code->name }}</td>
                            <td>{{ $party_scac_iata_code->status == 1 ? 'Active' : 'InActive' }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('party_s_c_a_c__i_a_t_a__codes.edit', [$party_scac_iata_code->id]) }}"
                                        class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['party_s_c_a_c__i_a_t_a__codes.destroy', $party_scac_iata_code->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
