@extends('layout.master')

@section('title')
Party Mapping-YARAN
@endsection

@section('topbar')
<a href="/partymappings" class="breadcrumb--active">Party Mapping</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Party Mappings
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('partymappings.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $partymappings->firstItem() }} to
                {{ $partymappings->lastItem() }} of {{ $partymappings->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Integration Code</th>
                        <th>Integration Name</th>
                        <th>CSUL Code</th>
                        <th>CSUL Name</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($partymappings as $partymapping)
                        <tr>
                            <td>{{ $partymapping->id }}</td>
                            <td>{{ $partymapping->integration_code }}</td>
                            <td>{{ $partymapping->integration_name }}</td>
                            <td>{{ $partymapping->csul_code }}</td>
                            <td>{{ $partymapping->csul_name }}</td>
                            <td>{{ $partymapping->status == 1 ? 'Active' : 'InActive' }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('partymappings.edit', [$partymapping->id]) }}"
                                        class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['partymappings.destroy', $partymapping->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
