@extends('layout.master')

@section('title')
Party Type-YARAN
@endsection

@section('topbar')
<a href="/partytypes" class="breadcrumb--active">Party Type</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Party Types
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('partytypes.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $partytypes->firstItem() }} to
                {{ $partytypes->lastItem() }} of {{ $partytypes->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Name</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($partytypes as $partytype)
                        <tr>
                            <td>{{ $partytype->id }}</td>
                            <td>{{ $partytype->name }}</td>
                            <td>{{ $partytype->status == 1 ? 'Active' : 'InActive' }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('partytypes.edit', [$partytype->id]) }}"
                                        class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['partytypes.destroy', $partytype->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="grid columns-12 gap-6 mt-4">
                <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center">
                    <div class="d-none d-md-block mx-auto text-gray-600">
                        <?php echo $partytypes->appends(request()->query())->links('pagination::bootstrap-4'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
