@extends('layout.master')

@section('title')
Payment-YARAN
@endsection

@section('topbar')
<a href="{{ url('accounts/payment') }}" class="breadcrumb--active">Payment</a>
@endsection
@section('content')
<h2 class="intro-y fs-lg fw-medium mt-10">
    Payment
</h2>
<div class="grid columns-12 gap-6 mt-5">
    <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
        <a class="btn btn-primary shadow-md me-2" href="{{ url('accounts/payment/add') }}">Add New</a>
        <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $data->firstItem() }} to
            {{ $data->lastItem() }} of {{ $data->total() }} entries</div>
    </div>
    <!-- BEGIN: Data List -->

    <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
        <table class="table table-bordered mt-n2">
            <thead>
                <tr>
                    <th>Id</th>
                    <th>Date</th>
                    <th>Voucher No</th>
                    <th>Due Date</th>
                    <th>Amount VC</th>
                    <th>Amount LC</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($data as $transaction)
                <tr>
                    <td>{{ $transaction->id }}</td>
                    <td>{{ $transaction->date }}</td>
                    <td>{{ @$transaction->voucher_no }}</td>
                    <td>{{ $transaction->due_date }}</td>
                    <td>{{ @$transaction->detail->sum('amount_vc') }}</td>
                    <td>{{ @$transaction->detail->sum('amount_lc') }}</td>
                    <td>
                        <div class="d-flex gap-2">
                            <a href="{{ url('accounts/payment/edit', $transaction->id) }}"
                                class="btn btn-primary">Edit</a>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        <div class="grid columns-12 gap-6 mt-4">
            <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center">
                <div class="d-flex d-md-block mx-auto text-gray-600">
                    <?php echo $data->appends(request()->query())->links('pagination::bootstrap-4'); ?>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection