@extends('layout.master')

@section('title')
    add-Receipt-YARAN
@endsection

@section('topbar')
    <a href="{{ url('accounts/receipt/add') }}" class="breadcrumb-item">Receipt</a><i data-feather="chevron-right"
        class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('accounts/receipt/add') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Add Receipt
                        </h2>
                        
                        <button type="submit" class="btn btn-primary submitBtn"
                            id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Date</label>
                                    <input id="regular-form-1" required type="date" class="form-control name-validate"
                                        name="date">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Type</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Type" id="transaction_type_master_id"
                                            name="transaction_type_master_id" class="tom-select w-full">
                                            <option value="">Please Select Type</option>
                                            @foreach ($transaction_type_master as $type)
                                                <option value="{{ $type->id }}">{{ $type->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Cheque Type</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Cheque Type" id="cheque_type" name="cheque_type"
                                            class="tom-select w-full">
                                            <option value="">Please Select Cheque Type</option>
                                            <option value="Open Cheque">Open Cheque</option>
                                            <option value="PDC">PDC</option>
                                            <option value="Regular">Regular</option>

                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Settlement Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Settlement Account" id="settlement_account"
                                            name="settlement_account" class="tom-select w-full">
                                            <option value="">Please Select Settlement Account</option>
                                            @foreach ($chart_of_accounts as $account)
                                                <option value="{{ $account->id }}">
                                                    {{ $account->name . ' - ' . $account->account_code }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Party Account</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Party Account" id="account_id"
                                            name="master_account_id" class="tom-select w-full">
                                            <option value="">Please Select Party Account</option>
                                            @foreach ($chart_of_accounts as $account)
                                                <option value="{{ $account->id }}">
                                                    {{ $account->name . ' - ' . $account->account_code }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Amount</label>
                                    <input id="regular-form-1" required type="text" class="form-control name-validate"
                                        name="amount">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Cost Center</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Cost Center" id="cost_center_id"
                                            name="cost_center_id" class="tom-select w-full">
                                            <option value="">Please Select Cost Center</option>
                                            @foreach ($cost_centers as $cost_center)
                                                <option value="{{ $cost_center->id }}">{{ $cost_center->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Bank Sub Type</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Bank Type" id="bank_sub_type" name="bank_sub_type"
                                            class="tom-select w-full">
                                            <option value="">Please Select Bank Type</option>
                                            <option value="ACH">ACH</option>
                                            <option value="Wire Transfer">Wire Transfer</option>
                                            <option value="Online Transfer">Online Transfer</option>
                                            <option value="Credit Card">Credit Card</option>
                                            <option value="Cheque">Cheque</option>
                                            <option value="PO">PO</option>
                                            <option value="TT">TT</option>
                                            <option value="Cash">Cash</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label>Currency</label>
                                    <div class="mt-2">
                                        <select data-placeholder="Select Currency" id="currency_id" name="currency_id"
                                            class="tom-select w-full">
                                            <option value="">Please Select Currency</option>
                                            <option value="1">PAK RUPEES</option>
                                            <option value="2">US DOLLAR</option>
                                            <option value="3">DIRHAM</option>
                                            <option value="4">POUND</option>
                                            <option value="5">EURO</option>
                                            <option value="6">BDT</option>
                                            <option value="7">OMANI RIYAL</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Exchange Rate</label>
                                    <input id="regular-form-1" required type="number" class="form-control name-validate"
                                        placeholder="Enter Exchange Rate" value="1.000000" name="exchange_rate">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Cheque Number</label>
                                    <input id="regular-form-1" type="text" class="form-control name-validate"
                                        placeholder="Enter Cheque Number" name="cheque_number">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Cheque Date</label>
                                    <input id="regular-form-1" type="date" class="form-control name-validate"
                                        placeholder="Enter Cheque Date" name="cheque_date">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Received From</label>
                                    <input id="regular-form-1" type="text" class="form-control name-validate"
                                        placeholder="Enter Received From" name="pay_to_or_received_from">
                                </div>

                                <div class="col-md-6 mt-2">
                                    <label for="regular-form-1" class="form-label">Drawn At</label>
                                    <input id="regular-form-1" type="date" class="form-control name-validate"
                                        name="drawn_at">
                                </div>

                            </div>

                            <div class="row mb-5">
                                <div class="mt-5">
                                    <div class="g-col-12 g-col-lg-4 g-col-xxl-3">
                                        <div class="intro-y pe-1">
                                            <div class="box p-2">
                                                <ul class="nav nav-pills rounded-2" role="tablist">
                                                    <li id="invoice_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5 active"
                                                            data-bs-toggle="pill" data-bs-target="#invoice"
                                                            type="button" role="tab" aria-controls="invoice_tab"
                                                            aria-selected="true">Invoice</button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="tab-content mt-2">
                                            <div class="tab-pane fade show active" id="charges" role="tabpanel"
                                                aria-labelledby="charges_tab">
                                                <div class="row">
                                                    <div class="g-col-4">
                                                        <h1>Outstanding Invoices</h1>
                                                        <div class="text-end mt-3 me-5">
                                                            <button id="addRowReceivableButton" type="button"
                                                                class="btn btn-primary">Add
                                                                Row</button>
                                                        </div>
                                                        <div class="row">
                                                            <div class="intro-y g-col-12 overflow-auto">
                                                                <table id="receiveableTable"
                                                                    class="table table-bordered mt-n2">
                                                                    <thead>
                                                                        <tr>
                                                                            <th class="text-nowrap">Invoice No</th>
                                                                            <th class="text-nowrap">Balance</th>
                                                                            <th class="text-nowrap">Date</th>
                                                                            <th class="text-nowrap">Due Date</th>
                                                                            <th class="text-nowrap">Doc No</th>
                                                                            <th class="text-nowrap">Narration</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <tr>
                                                                            <td>
                                                                                <input class="form-control w-24"
                                                                                    type="text" name="invoice_no[]">
                                                                            </td>
                                                                            <td>
                                                                                <input class="form-control w-24"
                                                                                    type="text" name="balance[]">
                                                                            </td>
                                                                            <td>
                                                                                <input class="form-control w-24"
                                                                                    type="date" name="date[]">
                                                                            </td>
                                                                            <td>
                                                                                <input class="form-control w-24"
                                                                                    type="date" name="due_date[]">
                                                                            </td>
                                                                            <td>
                                                                                <input class="form-control w-24"
                                                                                    type="text" name="doc_no[]">
                                                                            </td>
                                                                            <td>
                                                                                <input class="form-control w-24"
                                                                                    type="text" name="narration[]">
                                                                            </td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>

                                                        </div>
                                                    </div>
                                                    <div class="g-col-4 d-flex justify-content-center">
                                                        <!-- Buttons for moving rows -->
                                                        <div class="text-center mt-3">
                                                            <button id="moveToTable2" type="button"
                                                                class="btn btn-success">↓</button>
                                                        </div>
                                                        <div class="text-center mt-3 mx-3">
                                                            <button id="moveToTable1" type="button"
                                                                class="btn btn-warning">↑</button>
                                                        </div>
                                                    </div>
                                                    <div class="g-col-8">
                                                        <h1>Invoice Adjustment</h1>
                                                        <div class="text-end mt-3 me-5">
                                                            <button id="addRowReceivableButton" type="button"
                                                                class="btn btn-primary">Add
                                                                Row</button>
                                                        </div>
                                                        <div class="row">
                                                            <div class="intro-y g-col-12 overflow-auto">
                                                                <table id="receiveableTable"
                                                                    class="table table-bordered mt-n2">
                                                                    <thead>
                                                                        <tr>
                                                                            <th class="text-nowrap">Invoice No</th>
                                                                            <th class="text-nowrap">Date</th>
                                                                            <th class="text-nowrap">Inv Date</th>
                                                                            <th class="text-nowrap">Invoice Amount</th>
                                                                            <th class="text-nowrap">Settled Amount</th>
                                                                            <th class="text-nowrap">Bal Amount</th>
                                                                            <th class="text-nowrap">Doc No</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <tr>
                                                                            <td>
                                                                                <input class="form-control w-24"
                                                                                    type="text" name="invoice_no[]">
                                                                            </td>
                                                                            <td>
                                                                                <input class="form-control w-24"
                                                                                    type="text" name="date[]">
                                                                            </td>
                                                                            <td>
                                                                                <input class="form-control w-24"
                                                                                    type="date" name="inv_date[]">
                                                                            </td>
                                                                            <td>
                                                                                <input class="form-control w-24"
                                                                                    type="date" name="amount[]">
                                                                            </td>
                                                                            <td>
                                                                                <input class="form-control w-24"
                                                                                    type="text"
                                                                                    name="settled_amount[]">
                                                                            </td>
                                                                            <td>
                                                                                <input class="form-control w-24"
                                                                                    type="text" name="bal_amount[]">
                                                                            </td>
                                                                            <td>
                                                                                <input class="form-control w-24"
                                                                                    type="text" name="doc_no[]">
                                                                            </td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
            </form>
        </div>
    </div>
    </div>
    </div>
    </div>
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function() {
        const dropdownOptions = {
            chart_of_accounts: {!! json_encode($chart_of_accounts) !!},
            cost_centers: {!! json_encode($cost_centers) !!},
            tran_type: ["Dr", "Cr"],
            tax_type: ["N/A", "STAX", "VAT", "ASTX"]
        };

        function createDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option + '">' + option + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createDynamicDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option.id + '">' + option.name + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createInput(type, name, placeholder) {
            if (type == "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '"value="1" class="form-check-input" placeholder="' +
                    placeholder + '">';
            } else {
                return '<input type="' + type + '" name="' + name +
                    '" class="form-control w-24" placeholder="' +
                    placeholder + '">';
            }
        }

        let rowReceivableCounter = 1;

        function addRowReceivable() {

            let row = '<tr>' +
                '<td class="text-nowrap">' + (rowReceivableCounter + 1) +
                '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('account_id[]', dropdownOptions
                    .chart_of_accounts) +
                '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('cost_center_id[]', dropdownOptions
                    .cost_centers) + '</td>' +
                '<td class="text-nowrap">' + createDropdown('dr_cr[]', dropdownOptions
                    .tran_type) + '</td>' +
                // '<td class="text-nowrap">' + createInput('text', 'debit_vc[]', '') + '</td>' +
                // '<td class="text-nowrap">' + createInput('text', 'credit_vc[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'amount_vc[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'amount_lc[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'narration[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('tax_type[]', dropdownOptions
                    .tax_type) + '</td>' +
                '</tr>';
            $('#receiveableTable tbody').append(row);
            rowReceivableCounter++;
        }

        $('#addRowReceivableButton').click(addRowReceivable);
    });
</script>
