@extends('layout.master')

@section('title')
    Receipt / Payment-YARAN
@endsection

@section('topbar')
    <a href="/receipt" class="breadcrumb--active"> Receipt / Payment</a>
@endsection
@section('content')
    <div class="intro-y d-flex align-items-center">
        <div class="d-flex align-items-center">
            <h2 class="intro-y fs-lg fw-medium mt-6">
                Receipt / Payment
            </h2>
        </div>
        <div class="ms-auto mt-10">
            <button class="btn btn-primary dark-text-theme-10" type="button" data-bs-toggle="collapse"
                data-bs-target="#faq-accordion-collapse-1" aria-expanded="true" aria-controls="faq-accordion-collapse-1"> <i
                    data-feather="filter" class="w-4 h-4 me-3"></i> Filters
            </button>
        </div>
    </div>
    <div id="faq-accordion-collapse-1" class="accordion-collapse collapse show mt-5"
        aria-labelledby="faq-accordion-content-1" data-bs-parent="#faq-accordion-1">
        <div class="grid columns-12 gap-6 mt-5">
            <div class="intro-y g-col-12 g-col-lg-12">
                <!-- BEGIN: Form Layout -->
                <div class="intro-y box p-5">
                    <form method="GET" id="myForm" action="{{ url('/receipt') }}">
                        <div class="row">
                            <div class="col-md-4 mb-2">
                                <div>
                                    <label for="type" class="form-label">Type</label>
                                    <select name="type" id="type" class="tom-select w-full">
                                        <option value="">Please Select type</option>
                                        <option value="receipt" {{ request('type') == 'receipt' ? 'selected' : '' }}>Receipt
                                        </option>
                                        <option value="payment" {{ request('type') == 'payment' ? 'selected' : '' }}>Payment
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 mb-2">
                                <div>
                                    <label for="trans_no" class="form-label">Trans #</label>
                                    <select name="trans_no" id="trans_no" class="tom-select w-full">
                                        <option value="">Please Select trans #</option>
                                        @foreach ($transaction_numbers as $trans_no)
                                            <option {{ request('trans_no') == $trans_no ? 'selected' : '' }}
                                                value="{{ $trans_no }}">{{ $trans_no }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 mb-2">
                                <div>
                                    <label for="operation_id" class="form-label">Operation</label>
                                    <select name="operation_id" id="operation_id" class="tom-select w-full">
                                        <option value="">Please Select operation</option>
                                        @foreach ($operations as $op)
                                            <option {{ request('operation_id') == $op->id ? 'selected' : '' }}
                                                value="{{ $op->id }}">{{ $op->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 mb-2">
                                <label class="lbl_account_1">Account</label>
                                <div class="mt-2">
                                    <select id="account_id" name="account_id" class="tom-select w-full">
                                        <option value="">Please Select Account</option>
                                        @foreach ($accounts as $account)
                                            <option {{ request('account_id') == $account->id ? 'selected' : '' }}
                                                value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            {{-- {{ dd(request('filterValue')) }} --}}
                            <div class="col-md-4 " id="cost_center_id">
                                <label class="lbl_account_1">Client</label>
                                <div class="mt-2">
                                    <select id="client_id" name="client_id" class="tom-select w-full">
                                        <option value="">Please Select Client</option>
                                        @foreach ($clients as $cl)
                                            <option {{ request('client_id') == $cl->id ? 'selected' : '' }}
                                                value="{{ $cl->id }}">{{ $cl->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <label for="date_from" class="form-label">From</label>
                                <input type="date" name="date_from" class="form-control"
                                    value="{{ request('date_from') }}">
                            </div>
                            <div class="col-md-4" id="customDateRangeTwo">
                                <label for="date_to" class="form-label">To</label>
                                <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                            </div>
                            <div class="col-md-4 mt-8">
                                <button type="submit" class="btn btn-sm btn-elevated-primary w-24">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20"
                                        height="20" class="main-grid-item-icon" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                        <circle cx="11" cy="11" r="8" />
                                        <line x1="21" x2="16.65" y1="21" y2="16.65" />
                                    </svg>
                                    Search</button>
                                <a href="{{ url('/receipt') }}" type="button"
                                    class="btn btn-sm btn-elevated-danger w-24">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20"
                                        height="20" class="main-grid-item-icon" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                        <line x1="18" x2="6" y1="6" y2="18" />
                                        <line x1="6" x2="18" y1="6" y2="18" />
                                    </svg>
                                    Clear</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!-- END: Form Layout -->
        </div>
    </div>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ url('/receipt/add') }}">Add New</a>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>S.No</th>
                        <th>Date</th>
                        <th>Trans #</th>
                        <th>Operation</th>
                        <th>Type</th>
                        <th>Voucher No</th>
                        <th>Main Account</th>
                        <th>Party Account</th>
                        <th>Cheque / Ref No</th>
                        <th>Cheque / Ref Date</th>
                        <th>Method</th>
                        <th>Amount</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($receipt_payment as $index => $item)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $item->trans_date }}</td>
                            <td>{{ $item->trans_no }}</td>
                            <td>{{ $item->operation?->name ?? 'All' }}</td>
                            <td>{{ $item->transaction?->type?->name ?? '' }}</td>
                            <td>{{ $item->transaction?->voucher_no ?? '' }}</td>
                            <td>{{ $item->account?->name ?? '' }}</td>
                            <td>{{ $item->party?->name ?? '' }}</td>
                            <td>{{ $item->cheque_number }}</td>
                            <td>{{ $item->cheque_date }}</td>
                            <td>{{ $item->nature }}</td>
                            <td>{{ $item->total_amount_conv }}</td>
                            <td>{{ $item->transaction?->status_master?->name }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <a title="Edit" class="tooltip btn btn-primary me-2 p-2"
                                        href="{{ url('/receipt/edit/' . $item->id) }}"><i data-feather="edit"
                                            class="w-4 h-4"></i> </a>
                                    {{-- <a target="_blank" href={{ url('receipt_print/' . $item->id) }}
                                        class="btn btn-success me-2 p-2"><i data-feather="file-text"
                                            class="w-4 h-4 me-1"></i>Print</a> --}}
                                    <button id="showPrintBtn{{ $item->id }}" class="btn btn-success me-2 p-2 showPrintBtn"
                                        data-bs-toggle="modal" data-bs-target="#printModal" data-item-id="{{ $item->id }}"><i
                                            data-feather="file-text" class="w-4 h-4 me-1"></i> Print </button>
                                    <form action="{{ url('se_receipt/delete', $item->id) }}" method="POST">
                                        @csrf
                                        <button type="submit" class="btn btn-danger me-2 p-2">Delete</button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @include('sea_export.se_receipt.modals.print')

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Add event listener to all buttons with the class 'showPrintBtn'
            document.querySelectorAll('.showPrintBtn').forEach(button => {
                button.addEventListener('click', function () {
                    // Get the bl_id from the button's data-item-id attribute
                    const receiptID = this.getAttribute('data-item-id');

                    // Set the value of the hidden input field
                    // document.getElementById('selectedBLId').value = blId;
                    const form = document.getElementById(
                        'printForm');
                    form.setAttribute('action', `/receipt_print/${receiptID}`);
                });
            });
        });
    </script>
@endsection