@extends('layout.master')

@section('title')
    BL-RELEASE-STATUS-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Bl Release Status</a>
@endsection

@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="GET" id="myForm" action="{{ url('/report/show_bl_release_status') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Bl Release Status
                        </h2>

                        <button type="submit" class="btn btn-primary">Report</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>



                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="col-md-4 mt-2">
                                    <label>Date Type</label>
                                    <select data-placeholder="Select Date Type" id="date_type" name="date_type"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        <option value="1" {{ request('date_type') == 1 ? 'selected' : '' }} selected>All
                                        </option>
                                        <option value="2" {{ request('date_type') == 2 ? 'selected' : '' }}>Sailing
                                            Date</option>
                                    </select>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="regular-form-1" class="form-label">Date From</label>
                                    <input id="date_from" type="date" class="form-control" placeholder="Enter Date From"
                                        name="date_from" value="{{ request('date_from', $date_from) }}">
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="regular-form-1" class="form-label">Date Till</label>
                                    <input id="date_till" type="date" class="form-control" name="date_till"
                                        value="{{ request('date_till', $date_to) }}">
                                </div>
                                <hr class="col-md-12 my-4">

                                <div class="col-md-3 mt-2">
                                    <label>Client</label>
                                    <select id="client_id" name="client_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($clients as $item)
                                            <option {{ request('client_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Shipping / Air Line</label>
                                    <select id="shipping_line_id" name="shipping_line_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($shipping_line as $item)
                                            <option {{ request('shipping_line_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>


                                <div class="col-md-3 mt-2">
                                    <label>Sales Rep</label>
                                    <select id="sales_rep_id" name="sales_rep_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($sales_rep as $item)
                                            <option {{ request('sales_rep_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Job #</label>
                                    <select id="job_id" name="job_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($jobs as $item)
                                            <option {{ request('job_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->job_no }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Final Dest</label>
                                    <select id="final_dest_id" name="final_dest_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($un_locations as $item)
                                            <option {{ request('final_dest_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>


                                <div class="col-md-3 mt-2">
                                    <label>Vessel</label>
                                    <select id="vessel_id" name="vessel_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($vessels as $item)
                                            <option {{ request('vessel_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>


                                <div class="col-md-3 mt-2">
                                    <label>Shipper</label>
                                    <select id="shipper_id" name="shipper_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($shippers as $item)
                                            <option {{ request('shipper_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>



                                <div class="col-md-3 mt-2">
                                    <label>Voyage</label>
                                    <select id="voyage_id" name="voyage_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($voyages as $item)
                                            <option {{ request('voyage_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>




                                <div class="col-md-3 mt-2">
                                    <label>Port of Loading</label>
                                    <select id="port_of_loading_id" name="port_of_loading_id"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($un_locations as $item)
                                            <option {{ request('port_of_loading_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>POD</label>
                                    <select id="pod_id" name="pod_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($un_locations as $item)
                                            <option {{ request('pod_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>




                                <hr class="col-md-12 my-4">
                                <div class="col-md-3 mt-10">
                                    <input id="all_operation_types" type="checkbox" class="form-check-input"
                                        name="all_operation_types"
                                        {{ request('all_operation_types') == '1' ? 'checked' : '' }} value="1">
                                    <label class="form-label" for="all_operation_types">
                                        All Operation Types
                                    </label>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Operation</label>
                                    <select id="operation_id" name="operation_id[]" class="tom-select w-full mt-2" multiple>
                                        <option value=""></option>
                                        @foreach ($operations as $item)
                                            <option {{ request('operation_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const allOperationTypesCheckbox = document.getElementById('all_operation_types');
        const operationSelect = document.getElementById('operation_id');

        allOperationTypesCheckbox.addEventListener('change', function() {
            if (this.checked) {
                operationSelect.disabled = true;
                operationSelect.value = '';
            } else {
                operationSelect.disabled = false;
            }
        });
    });
</script>
