@extends('layout.master')

@section('title')
    BL-STATUS-RELEASE-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">BL Status Release</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none;border-right: none; padding-bottom: 8px;border-top: none; margin-right: 70px; margin-bottom: 10px;">
            <!-- Added margin-bottom for gap -->
            <div class="text-center">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight:bold">YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10">Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.</h3>
                <p>Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2 display nowrap" id="jobBalancingReport"
                style="display: none; width:100%">
                <thead>
                    <tr>
                        <th>Job Number</th>
                        <th>HBL Number</th>
                        <th>MBL Number</th>
                        <th>Client Name</th>
                        <th>Carrier Booking No</th>
                        <th>Shipper Name</th>
                        <th>Consignee</th>
                        <th>Overseas Agent</th>
                        <th>Shipping Line</th>
                        <th>Sub Type</th>
                        <th>Hand Over Type</th>
                        <th>BL Status</th>
                        <th>Release or Stop</th>
                        <th>Remarks</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($query as $j => $bl_master)
                        <tr>
                            <td>{{ @$bl_master->job_master->job_no }}</td>
                            <td>{{ @$bl_master->hbl_no }}</td>
                            <td>{{ @$bl_master->mbl_no }}</td>
                            <td>{{ @$bl_master->job_master->job_detail->client->name }}</td>
                            <td></td>
                            <td>{{ @$bl_master->shipper->name }}</td>
                            <td>{{ @$bl_master->consignee->name }}</td>
                            <td>{{ @$bl_master->bl_booking_info->overseas_agent->name }}</td>
                            <td>{{ @$bl_master->bl_booking_info->shipping_line->name }}</td>
                            <td>{{ @$bl_master->job_master->sub_type_one }}</td>
                            <td></td>
                            <td>{{ @$bl_master->bl_status }}</td>
                            <td></td>
                            <td>{{ @$bl_master->job_master->job_other_info->remarks }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        {{-- end Pagination --}}
    </div>
    <!-- jQuery (Required for DataTables) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>

    <script>
        $(document).ready(function() {
            // Check if DataTable library is loaded
            if ($.fn.dataTable) {
                // Initialize the DataTable
                $('#jobBalancingReport').DataTable({
                    dom: 'Bfrtip', // Include export buttons in the DOM
                    buttons: [{
                            extend: 'excelHtml5',
                            text: 'Export to Excel',
                            title: 'BL Status Release',
                            exportOptions: {
                                columns: ':visible' // Export only visible columns
                            }
                        },
                        // {
                        //     extend: 'pdfHtml5',
                        //     text: 'Export to PDF',
                        //     title: 'Party Statement Of Account',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     },
                        //     customize: function(doc) {
                        //         // Customize PDF output if needed
                        //         doc.content[1].margin = [0, 0, 0, 0]; // Adjust margins
                        //         doc.content[1].table.widths = '*'.repeat(doc.content[1].table.body[
                        //             0].length).split('');
                        //     }
                        // },
                        // {
                        //     extend: 'print',
                        //     text: 'Print Table',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     }
                        // }
                    ],
                    initComplete: function() {
                        // Show the table after DataTables initialization is complete
                        $('#jobBalancingReport').show();
                    }
                });
            }
        });
    </script>
@endsection
