@extends('layout.master')

@section('title')
    CARGO-MOVEMENTS-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Cargo Movements</a>
@endsection

@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="GET" id="myForm" action="{{ url('/report/show_cargo_movements') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Cargo Movements </h2>

                        <button type="submit" class="btn btn-primary">Report</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>



                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="col-md-4 mt-2">
                                    <label>Date Type</label>
                                    <select data-placeholder="Select Date Type" id="date_type" name="date_type"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        <option value="1" {{ request('date_type') == 1 ? 'selected' : '' }} selected>
                                            Job Date
                                        </option>
                                        <option value="2" {{ request('date_type') == 2 ? 'selected' : '' }}>
                                            Sailing/Arrival Date</option>
                                    </select>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="regular-form-1" class="form-label">Date From</label>
                                    <input id="date_from" type="date" class="form-control" placeholder="Enter Date From"
                                        name="date_from" value="{{ request('date_from', $date_from) }}">
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="regular-form-1" class="form-label">Date Till</label>
                                    <input id="date_till" type="date" class="form-control" name="date_till"
                                        value="{{ request('date_till', $date_to) }}">
                                </div>
                                <hr class="col-md-12 my-4">
                                <div class="col-md-3 mt-2">
                                    <label>Company</label>
                                    <select data-placeholder="Select Company" id="company" name="company"
                                        class="tom-select w-full mt-2">
                                        <option value="1" {{ request('company') == 1 ? 'selected' : '' }}>YARAN
                                            SHIPPING LINE</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Client</label>
                                    <select id="client_id" name="client_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($clients as $item)
                                            <option {{ request('client_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Shipper</label>
                                    <select id="shipper_id" name="shipper_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($shippers as $item)
                                            <option {{ request('shipper_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Clearing Agent</label>
                                    <select id="clearing_agent_id" name="clearing_agent_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($custom_clearance as $item)
                                            <option {{ request('clearing_agent_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Sales Rep</label>
                                    <select id="sales_rep_id" name="sales_rep_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($sales_rep as $item)
                                            <option {{ request('sales_rep_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Port Of Discharge</label>
                                    <select id="pod_id" name="pod_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($un_locations as $item)
                                            <option {{ request('pod_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Local Vendor</label>
                                    <select id="vendor_id" name="vendor_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($vendors as $item)
                                            <option {{ request('vendor_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Shipping Line</label>
                                    <select id="shipping_line_id" name="shipping_line_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($shipping_line as $item)
                                            <option {{ request('shipping_line_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Vessel</label>
                                    <select id="vessel_id" name="vessel_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($vessels as $item)
                                            <option {{ request('vessel_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Voyage</label>
                                    <select id="voyage_id" name="voyage_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($voyages as $item)
                                            <option {{ request('voyage_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Cost Center</label>
                                    <select data-placeholder="Select Cost Center" id="cost_center" name="cost_center"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        <option {{ request('cost_center') == 'Head Office' ? 'selected' : '' }}
                                            value="Head Office">Head Office</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Sub Type</label>
                                    <select data-placeholder="Select category" id="sub_type" name="sub_type"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        <option value="LCL" {{ request('sub_type') == 'LCL' ? 'selected' : '' }}>LCL
                                        </option>
                                        <option value="FCL" {{ request('sub_type') == 'FCL' ? 'selected' : '' }}>FCL
                                        </option>
                                        <option value="Car" {{ request('sub_type') == 'Car' ? 'selected' : '' }}>Car
                                        </option>
                                        <option value="BreakBulk"
                                            {{ request('sub_type') == 'BreakBulk' ? 'selected' : '' }}>BreakBulk</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Type</label>
                                    <select id="type" name="type" class="form-select mt-2">
                                        <option value="1" {{ request('type') == '1' ? 'selected' : '' }} selected>
                                            Cargo Not Received
                                        </option>
                                        <option value="2" {{ request('type') == '2' ? 'selected' : '' }}>
                                            Cargo Received</option>
                                        <option value="3" {{ request('type') == '3' ? 'selected' : '' }}>Overall
                                            Cargo Movement</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
