@extends('layout.master')

@section('title')
    @if ($type == 1)
        CARGO-NOT-RECEIVED-REPORT-YARAN
    @elseif($type == 2)
        CARGO-RECEIVED-REPORT-YARAN
    @elseif($type == 3)
        OVERALL-CARGO-REPORT-YARAN
    @endif
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">
        @if ($type == 1)
            Cargo Not Received Report
        @elseif($type == 2)
            Cargo Received Report
        @elseif($type == 3)
            Overall Cargo Received Report
        @endif
    </a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none;border-right: none; padding-bottom: 8px;border-top: none; margin-right: 70px; margin-bottom: 10px;">
            <!-- Added margin-bottom for gap -->
            <div class="text-center">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight:bold">YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10">Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.</h3>
                <p>Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2 display nowrap" id="jobBalancingReport"
                style="display: none; width:100%">
                <thead>
                    <tr>
                        <th rowspan="2">Job #</th>
                        <th rowspan="2">Booking Date</th>
                        <th rowspan="2">No. of Packgs</th>
                        <th rowspan="2">Comd</th>
                        <th rowspan="2">Shipper's Name</th>
                        <th rowspan="2">Clearing Agnet Name</th>
                        <th rowspan="2">STN-Cod Buy-Cod PRF-Cod</th>
                        <th rowspan="2">CBM Station</th>
                        <th rowspan="2">Con Stat</th>
                        <th rowspan="2">Size</th>
                        <th rowspan="2">Port of Discharge</th>
                        <th rowspan="2">Place of Delivery</th>
                        <th colspan="3">Planned On</th>
                        @if ($type == 1)
                            <th rowspan="2">Loading Program</th>
                        @elseif ($type == 3)
                            <th rowspan="2">Arrived On</th>
                        @endif
                    </tr>
                    <tr>
                        <th>Vessel</th>
                        <th>Voy</th>
                        <th>ETA</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $totalCbm = 0;
                    @endphp
                    @foreach ($query as $job_master)
                        @if ($job_master->bl_master)
                            @if ($job_master->bl_master->bl_container_info->isNotEmpty())
                                @php
                                    $total20 = 0;
                                    $total40 = 0;
                                @endphp
                                @foreach ($job_master->bl_master->bl_container_info as $detail)
                                    @php
                                        if (
                                            !empty($detail->container_size_type) &&
                                            $detail->container_size_type !== 'Please Select' &&
                                            $detail->container_size_type !== 'M3'
                                        ) {
                                            if (substr($detail->container_size_type, 0, 2) === '20') {
                                                $total20++;
                                            } else {
                                                $total40++;
                                            }
                                        }
                                    @endphp
                                @endforeach
                            @endif
                        @endif
                        <tr>
                            <td>{{ $job_master->job_no ?? '-' }}</td>
                            <td>-</td>
                            <td>{{ $job_master->bl_master->bl_details->pkgs ?? '-' }}
                                {{ $job_master->bl_master->bl_details->pkg_unit ?? '' }}</td>
                            <td>-</td>
                            <td>{{ $job_master->job_detail->shipper->name ?? '-' }}</td>
                            <td>{{ $job_master->job_detail->custom_clearance->name ?? '-' }}</td>
                            <td>-</td>
                            <td>{{ $job_master->bl_master->bl_details->cbm ?? '-' }}</td>
                            <td>{{ $job_master->sub_type_one ?? '-' }}</td>
                            <td>{{ $total20 != 0 ? $total20 . ' x 20' : ($total40 != 0 ? $total40 . ' x 40' : '-') }}</td>
                            <td>{{ $job_master->job_detail->port_of_discharge->name ?? '-' }}</td>
                            <td>{{ $job_master->bl_master->bl_details->place_of_delivery->name ?? '-' }}</td>
                            <td>{{ $job_master->job_vessel->vessel->name ?? '-' }}</td>
                            <td>{{ $job_master->job_vessel->voyage->voyage_no ?? '-' }}</td>
                            <td>{{ $job_master->job_vessel->eta ?? '-' }}</td>
                            @if ($type == 1)
                                <td>{{ $job_master->job_routing->loading_date ?? '-' }}</td>
                            @elseif ($type == 3)
                                <td>{{ $job_master->bl_master->arrival_date ?? '-' }}</td>
                            @endif
                        </tr>
                        @php
                            $totalCbm += floatval(str_replace(',', '', $job_master->bl_master?->bl_details?->cbm ?? 0));
                        @endphp
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="7" class="text-end">Total</th>
                        <th colspan="9">{{ $totalCbm }}</th>
                    </tr>
                </tfoot>
            </table>
        </div>
        {{-- end Pagination --}}
    </div>
    <!-- jQuery (Required for DataTables) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>

    <script>
        $(document).ready(function() {
            // Check if DataTable library is loaded
            if ($.fn.dataTable) {
                // Initialize the DataTable
                $('#jobBalancingReport').DataTable({
                    dom: 'Bfrtip', // Include export buttons in the DOM
                    buttons: [{
                            extend: 'excelHtml5',
                            text: 'Export to Excel',
                            title: 'Cargo Movements',
                            exportOptions: {
                                columns: ':visible' // Export only visible columns
                            }
                        },
                        // {
                        //     extend: 'pdfHtml5',
                        //     text: 'Export to PDF',
                        //     title: 'Party Statement Of Account',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     },
                        //     customize: function(doc) {
                        //         // Customize PDF output if needed
                        //         doc.content[1].margin = [0, 0, 0, 0]; // Adjust margins
                        //         doc.content[1].table.widths = '*'.repeat(doc.content[1].table.body[
                        //             0].length).split('');
                        //     }
                        // },
                        // {
                        //     extend: 'print',
                        //     text: 'Print Table',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     }
                        // }
                    ],
                    initComplete: function() {
                        // Show the table after DataTables initialization is complete
                        $('#jobBalancingReport').show();
                    }
                });
            }
        });
    </script>
@endsection
