@extends('layout.master')

@section('title')
    CHARGES-WISE-JOB-REPORT-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Charges Wise Job Report</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none;border-right: none; padding-bottom: 8px;border-top: none; margin-right: 70px; margin-bottom: 10px;">
            <!-- Added margin-bottom for gap -->
            <div class="text-center">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight:bold">YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10">Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.</h3>
                <p>Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2 display nowrap" id="jobBalancingReport" style="display: none; width:100%">
                <thead>
                    <tr>
                        <th>S#</th>
                        <th>Job No</th>
                        <th>Job Date</th>
                        <th>MBL #</th>
                        <th>HBL #</th>
                        @if ($type == 1)
                            <th>Customer</th>
                        @elseif($type == 2)
                            <th>Vendor</th>
                        @else
                            <th>Party</th>
                        @endif
                        <th>Shipper</th>
                        <th>Consignee</th>
                        <th>Vessel/Flight</th>
                        <th>Inv/Bill #</th>
                        @if ($type == 3)
                            <th>Type</th>
                        @endif
                        <th>Qty</th>
                        <th>Rate</th>
                        <th>Curr</th>
                        <th>Amount</th>
                        <th>Local Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $totalqty = 0;
                        $totalrate = 0;
                        $totalamount = 0;
                        $totalLocalAmount = 0;
                    @endphp
                    @foreach ($query as $i => $job)
                        @if ($type == 1 || $type == 3)
                            @foreach (@$job->job_charges_receivable as $charge)
                                <tr>
                                    <td>{{ $i + 1 }}</td>
                                    <td>{{ @$job->job_no }}</td>
                                    <td>{{ @$job->job_date }}</td>
                                    <td>{{ @$job->bl_master->mbl_no }}</td>
                                    <td>{{ @$job->bl_master->hbl_no }}</td>
                                    <td>{{ @$charge->customer->name }}</td>
                                    <td>{{ @$job->job_detail->shipper->name }}</td>
                                    <td>{{ @$job->job_detail->consignee->name }}</td>
                                    <td>{{ @$job->job_vessel->vessel->name }}</td>
                                    <td>{{ @$charge->bill_invoice }}</td>
                                    @if ($type == 3)
                                        <td>Receivable</td>
                                    @endif
                                    <td>{{ @$charge->qty }}</td>
                                    <td>{{ @$charge->rate }}</td>
                                    @if (@$charge->currency == 1)
                                        <td>PKR</td>
                                    @elseif(@$charge->currency == 2)
                                        <td>USD</td>
                                    @elseif(@$charge->currency == 3)
                                        <td>AED</td>
                                    @elseif(@$charge->currency == 4)
                                        <td>BDT</td>
                                    @elseif(@$charge->currency == 5)
                                        <td>OMR</td>
                                    @elseif(@$charge->currency == 6)
                                        <td>EUR</td>
                                    @elseif(@$charge->currency == 7)
                                        <td>GBP</td>
                                    @endif
                                    <td>{{ @$charge->amount }}</td>
                                    <td>{{ @$charge->local_amount }}</td>
                                    @php
                                        $totalqty += $charge->qty;
                                        $totalrate += $charge->rate;
                                        $totalamount += $charge->net_amount;
                                        $totalLocalAmount += $charge->local_amount;
                                    @endphp
                                </tr>
                            @endforeach
                        @endif
                        @if ($type == 2 || $type == 3)
                            @foreach ($job->job_charges_payable as $charge)
                                <tr>
                                    <td>{{ $i + 1 }}</td>
                                    <td>{{ 'SEJ-' . $job->id . '-' . $job->created_at->format('Y') }}</td>
                                    <td>{{ @$job->job_date }}</td>
                                    <td>{{ @$job->bl_master->mbl_no }}</td>
                                    <td>{{ @$job->bl_master->hbl_no }}</td>
                                    <td>{{ @$charge->customer->name }}</td>
                                    <td>{{ @$job->job_detail->shipper->name }}</td>
                                    <td>{{ @$job->job_detail->consignee->name }}</td>
                                    <td>{{ @$job->job_vessel->vessel->name }}</td>
                                    <td>{{ @$charge->bill_invoice }}</td>
                                    @if ($type == 3)
                                        <td>Payable</td>
                                    @endif
                                    <td>{{ @$charge->qty }}</td>
                                    <td>{{ @$charge->rate }}</td>
                                    @if (@$charge->currency == 1)
                                        <td>PKR</td>
                                    @elseif(@$charge->currency == 2)
                                        <td>USD</td>
                                    @elseif(@$charge->currency == 3)
                                        <td>AED</td>
                                    @elseif(@$charge->currency == 4)
                                        <td>BDT</td>
                                    @elseif(@$charge->currency == 5)
                                        <td>OMR</td>
                                    @elseif(@$charge->currency == 6)
                                        <td>EUR</td>
                                    @elseif(@$charge->currency == 7)
                                        <td>GBP</td>
                                    @endif
                                    <td>{{ @$charge->amount }}</td>
                                    <td>{{ @$charge->local_amount }}</td>
                                    @php
                                        $totalqty += $charge->qty;
                                        $totalrate += $charge->rate;
                                        $totalamount += $charge->net_amount;
                                        $totalLocalAmount += $charge->local_amount;
                                    @endphp
                                </tr>
                            @endforeach
                        @endif
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="{{ $type == 3 ? 11 : 10 }}">Total</th>
                        <th>{{ $totalqty }}</th>
                        <th>{{ $totalrate }}</th>
                        <th></th>
                        <th>{{ $totalamount }}</th>
                        <th>{{ $totalLocalAmount }}</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
    <!-- jQuery (Required for DataTables) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>

    <script>
        $(document).ready(function() {
            // Check if DataTable library is loaded
            if ($.fn.dataTable) {
                // Initialize the DataTable
                $('#jobBalancingReport').DataTable({
                    dom: 'Bfrtip', // Include export buttons in the DOM
                    buttons: [{
                            extend: 'excelHtml5',
                            text: 'Export to Excel',
                            title: 'Charges Wise Job Report',
                            exportOptions: {
                                columns: ':visible' // Export only visible columns
                            }
                        }
                        // {
                        //     extend: 'pdfHtml5',
                        //     text: 'Export to PDF',
                        //     title: 'Charges Wise Job Report',
                        //     orientation: 'landscape', // Change to landscape mode
                        //     pageSize: 'A4', // Use A4 paper size
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     },
                        //     customize: function(doc) {
                        //         // Customize PDF output if needed
                        //         doc.content[1].margin = [0, 0, 0, 0]; // Adjust margins
                        //         doc.content[1].table.widths = '*'.repeat(doc.content[1].table.body[
                        //             0].length).split('');
                        //     }
                        // },
                        // {
                        //     extend: 'print',
                        //     text: 'Print Table',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     }
                        // }
                    ],
                    initComplete: function() {
                        // Show the table after DataTables initialization is complete
                        $('#jobBalancingReport').show();
                    }
                });
            }
        });
    </script>
@endsection
