@extends('layout.master')

@section('title')
    CLIENT-EXPOSURE-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Client Exposure</a>
@endsection

@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="GET" id="myForm" action="{{ url('/report/show_client_exposure') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Client Exposure
                        </h2>

                        <button type="submit" class="btn btn-primary">Report</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>



                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="row align-items-center">

                                    <div class="col-md-3">
                                        <label>Client</label>
                                        <select id="client_id" name="client_id" class="tom-select w-full">
                                            <option value=""></option>
                                            @foreach ($clients as $item)
                                                <option {{ request('client_id') == $item->id ? 'selected' : '' }}
                                                    value="{{ $item->id }}">{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>


                                    <div class="col-md-3">
                                        <label>Operation</label>
                                        <select id="operation_id" name="operation_id[]" class="tom-select w-full" multiple>
                                            <option value=""></option>
                                            @foreach ($operations as $item)
                                                <option {{ request('operation_id') == $item->id ? 'selected' : '' }}
                                                    value="{{ $item->id }}">{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>


                                    <div class="col-md-3">
                                        <label>Report Type</label>
                                        <select data-placeholder="Select Report Type" id="report_type" name="report_type"
                                            class="tom-select w-full">
                                            <option value="1" {{ request('report_type') == '1' ? 'selected' : '' }}>
                                                Detail Report</option>
                                            <option value="2" {{ request('report_type') == '2' ? 'selected' : '' }}>
                                                Summary Report</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
