@extends('layout.master')

@section('title')
        JOB-WISE-CONTAINER-LIST-YARAN
@endsection

@section('topbar')
        <a href="" class="breadcrumb--active">Job Wise Container List</a>
@endsection

@section('content')

<div class="row  mt-5">
    <div class="  col-md-12 ">
        <!-- BEGIN: Input -->
        <form method="GET" id="myForm" action="{{ url('/report/show_container_wise') }}" enctype="multipart/form-data"
            class="row g-3">
            @csrf
            <div class="intro-y box">
                <div
                    class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                    <h2 class="fw-medium fs-base me-auto">
                        Job Wise Container List
                    </h2>

                    <button type="submit" class="btn btn-primary">Report</button>
                    <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                        Back
                    </a>
                </div>



                <div id="input" class="p-5">
                    <div class=" col-md-12">
                        <div class="row mb-5">
                            <div class="col-md-4 mt-2">
                                <label>Date Type</label>
                                <select data-placeholder="Select Date Type" id="date_type"
                                    name="date_type" class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    <option value="1" {{  request('date_type') == 1 ? 'selected' : '' }} selected>Job Date</option>
                                    <option value="2" {{  request('date_type') == 2 ? 'selected' : '' }}>Sailing/Arrival Date</option>
                                </select>
                            </div>
                            <div class="col-md-4 mt-2">
                                <label for="regular-form-1" class="form-label">Date From</label>
                                <input id="date_from" type="date" class="form-control"
                                    placeholder="Enter Date From" name="date_from" value="{{ request('date_from', $date_from) }}">
                            </div>
                            <div class="col-md-4 mt-2">
                                <label for="regular-form-1" class="form-label">Date Till</label>
                                <input id="date_till" type="date" class="form-control"
                                    name="date_till" value="{{ request('date_till', $date_to) }}">
                            </div>
                            <hr class="col-md-12 my-4">
                            <div class="col-md-3 mt-2">
                                <label>Vessel</label>
                                <select id="vessel_id" name="vessel_id"
                                    class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    @foreach ($vessels as $item)
                                        <option
                                            {{  request('vessel_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 mt-2">
                                <label>Voyage</label>
                                <select id="voyage_id" name="voyage_id"
                                    class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    @foreach ($voyages as $item)
                                        <option
                                            {{  request('voyage_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 mt-2">
                                <label>Overseas Agent</label>
                                <select id="overseas_agent_id" name="overseas_agent_id"
                                    class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    @foreach ($overseas_agent as $item)
                                        <option
                                            {{  request('overseas_agent_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 mt-2">
                                <label>Shipping / Air Line</label>
                                <select id="shipping_line_id" name="shipping_line_id"
                                    class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    @foreach ($shipping_line as $item)
                                        <option
                                            {{  request('shipping_line_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 mt-2">
                                <label>Client</label>
                                <select id="client_id" name="client_id"
                                    class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    @foreach ($clients as $item)
                                        <option
                                            {{  request('client_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 mt-2">
                                <label>Consignee</label>
                                <select id="consignee_id" name="consignee_id"
                                    class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    @foreach ($consignees as $item)
                                        <option
                                            {{  request('consignee_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 mt-2">
                                <label>Port of Loading</label>
                                <select id="port_of_loading_id" name="port_of_loading_id"
                                    class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    @foreach ($un_locations as $item)
                                        <option
                                            {{  request('port_of_loading_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 mt-2">
                                <label for="principal" class="form-label">Principal</label>
                                <input id="principal" type="text" class="form-control"
                                    placeholder="Enter Principal" name="principal" value="{{ request('principal') }}">
                            </div>
                            <div class="col-md-3 mt-2">
                                <label>Sales Rep</label>
                                <select id="sales_rep_id" name="sales_rep_id"
                                    class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    @foreach ($sales_rep as $item)
                                        <option
                                            {{  request('sales_rep_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 mt-2">
                                <label>Shipper</label>
                                <select id="shipper_id" name="shipper_id"
                                    class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    @foreach ($shippers as $item)
                                        <option
                                            {{  request('shipper_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 mt-2">
                                <label>Cost Center</label>
                                <select data-placeholder="Select Cost Center" id="cost_center"
                                    name="cost_center" class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    <option
                                        {{ request('cost_center') == 'Head Office' ? 'selected' : '' }}
                                        value="Head Office">Head Office</option>
                                </select>
                            </div>
                            <div class="col-md-3 mt-10">
                                <input id="all_operation_types" type="checkbox"
                                    class="form-check-input" name="all_operation_types"
                                    {{ request('all_operation_types') == '1' ? 'checked' : '' }} value="1">
                                <label class="form-label" for="all_operation_types">
                                    All Operation Types
                                </label>
                            </div>
                            <div class="col-md-3 mt-2">
                                <label>Operation</label>
                                <select id="operation_id" name="operation_id[]"
                                    class="tom-select w-full mt-2" multiple>
                                    <option value=""></option>
                                    @foreach ($operations as $item)
                                        <option
                                            {{  request('operation_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 mt-2">
                                <label>Job Type</label>
                                <select data-placeholder="Select Job Type" id="job_type"
                                    name="job_type" class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    <option value="Direct" {{  request('job_type') == 'Direct' ? 'selected' : '' }}>Direct</option>
                                    <option value="Coloaded" {{  request('job_type') == 'Coloaded' ? 'selected' : '' }}>Coloaded</option>
                                    <option value="Cross Trade" {{  request('job_type') == 'Cross Trade' ? 'selected' : '' }}>Cross Trade</option>
                                    <option value="Liner Agency" {{  request('job_type') == 'Liner Agency' ? 'selected' : '' }}>Liner Agency</option>
                                </select>
                            </div>
                            <div class="col-md-3 mt-2">
                                <label>Sub Type</label>
                                <select data-placeholder="Select category" id="sub_type"
                                    name="sub_type" class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    <option value="LCL" {{  request('sub_type') == 'LCL' ? 'selected' : '' }}>LCL</option>
                                    <option value="FCL" {{  request('sub_type') == 'FCL' ? 'selected' : '' }}>FCL</option>
                                    <option value="Car" {{  request('sub_type') == 'Car' ? 'selected' : '' }}>Car</option>
                                    <option value="BreakBulk" {{  request('sub_type') == 'BreakBulk' ? 'selected' : '' }}>BreakBulk</option>
                                </select>
                            </div>
                            <div class="col-md-3 mt-2">
                                <label>Sort By</label>
                                <select data-placeholder="Select Sort By" id="sort_by"
                                    name="sort_by" class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    <option value="1" {{  request('sort_by') == 1 ? 'selected' : '' }} selected>Job No</option>
                                    <option value="2" {{  request('sort_by') == 2 ? 'selected' : '' }}>Date</option>
                                    <option value="3" {{  request('sort_by') == 3 ? 'selected' : '' }}>BL No</option>
                                    <option value="4" {{  request('sort_by') == 4 ? 'selected' : '' }}>Job Date</option>
                                    <option value="5" {{  request('sort_by') == 5 ? 'selected' : '' }}>Arrival/Sailing</option>
                                </select>
                            </div>
                            <div class="col-md-3 mt-2">
                                <label>Job Status</label>
                                <select data-placeholder="Select Job Status" id="job_status_id"
                                    name="job_status_id" class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    @foreach ($job_status as $item)
                                    <option value="{{ $item->id }}" {{  request('job_status_id') == $item->id ? 'selected' : '' }}>{{ $item->name }}</option>
                                @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 mt-2">
                                <label>Group On</label>
                                <select data-placeholder="Select Sort By" id="group_on"
                                    name="group_on" class="tom-select w-full mt-2">
                                    {{-- <option value=""></option> --}}
                                    <option value="1" {{  request('group_on') == 1 ? 'selected' : '' }}>Vessel Wise</option>
                                    <option value="2" {{  request('group_on') == 2 ? 'selected' : '' }}>Overseas Agent</option>
                                    <option value="4" {{  request('group_on') == 4 ? 'selected' : '' }}>Client</option>
                                    <option value="5" {{  request('group_on') == 5 ? 'selected' : '' }}>Port</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const allOperationTypesCheckbox = document.getElementById('all_operation_types');
        const operationSelect = document.getElementById('operation_id');

        allOperationTypesCheckbox.addEventListener('change', function() {
            if (this.checked) {
                operationSelect.disabled = true;
                operationSelect.value = '';
            } else {
                operationSelect.disabled = false;
            }
        });
    });
</script>
