@extends('layout.master')

@section('title')
    JOB-WISE-CONTAINER-LIST-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Job Wise Container List</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none;border-right: none; padding-bottom: 8px;border-top: none; margin-right: 70px; margin-bottom: 10px;">
            <!-- Added margin-bottom for gap -->
            <div class="text-center">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight:bold">YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10">Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.</h3>
                <p>Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            {{-- <table class="table table-bordered mt-n2 display nowrap" id="jobBalancingReport" style="display: none; width:100%"> --}}
            <table class="table table-bordered mt-n2 display nowrap" style="width:100%">
                <thead>
                    <tr>
                        <th>S#</th>
                        <th>Job No</th>
                        <th>Job Date</th>
                        <th>BL No</th>
                        <th>Vessel</th>
                        <th>Voyage</th>
                        <th>Client</th>
                        <th>Principal</th>
                        <th>Port</th>
                        <th>Terminal</th>
                        <th>Container</th>
                        <th>Seal</th>
                        <th>Size</th>
                        <th>Gross Weight</th>
                        <th>Net Weight</th>
                        <th>CBM</th>
                        <th>Pkgs</th>
                        <th>Unit</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $totalgross = 0;
                        $totalnet = 0;
                        $totalcm = 0;
                        $totalpkgs = 0;
                    @endphp
                    @foreach ($query as $i => $groupItems)
                        <tr>
                            @if ($groupOn == 1)
                                <td colspan="18">Vessel: {{ optional($groupItems->first()->vessel)->name ?? 'N/A' }}</td>
                            @elseif($groupOn == 2)
                            {{-- @dd($groupItems) --}}
                                {{-- <td colspan="18">Overseas Agent: {{ @$groupItems->first()->overseas_agent->name }}</td> --}}
                                <td colspan="18">Overseas Agent: {{ optional($groupItems->first()->bl_booking_info->overseas_agent)->name ?? 'N/A' }}</td>
                            @elseif($groupOn == 4)
                                {{-- <td colspan="18">Client: {{ $groupItems->first()->client->name }}</td> --}}
                                <td colspan="18">Client: {{ optional($groupItems->first()->job_master->job_detail->client)->name ?? 'N/A' }}</td>
                            @elseif($groupOn == 5)
                                {{-- <td colspan="18">Port: {{ $groupItems->first()->port->name }}</td> --}}
                                <td colspan="18">Port of Loading: {{ optional($groupItems->first()->bl_booking_info->port_of_loading)->name ?? 'N/A' }}</td>
                            @endif
                        </tr>
                        @foreach ($groupItems as $j => $bl)
                            @foreach ($bl->bl_container_info as $index => $bl_container)
                                <tr>
                                    <td>{{ $j + 1 }}</td>
                                    <td>{{ @$bl->job_master->id }}</td>
                                    <td>{{ @$bl->job_master->job_date }}</td>
                                    <td>{{ @$bl->id }}</td>
                                    <td>{{ @$bl->vessel->name }}</td>
                                    <td>{{ @$bl->voyage->voyage_no }}</td>
                                    <td>{{ @$bl->job_master->job_detail->client->name }}</td>
                                    <td></td>
                                    <td>{{ @$bl->bl_booking_info->port_of_loading->name }}</td>
                                    <td></td>
                                    <td>{{ @$bl_container->container_no }}</td>
                                    <td>{{ @$bl_container->container_seal_no }}</td>
                                    <td>{{ @$bl_container->container_size_type }}</td>
                                    <td>{{ @$bl_container->container_gross_wt }}</td>
                                    <td>{{ @$bl_container->container_net_wt }}</td>
                                    <td>{{ @$bl_container->container_cbm }}</td>
                                    <td>{{ @$bl_container->container_packages }}</td>
                                    <td>{{ @$bl_container->container_unit }}</td>
                                    @php
                                        $totalgross += (float) str_replace(',', '', $bl_container->container_gross_wt);
                                        $totalnet += (float) str_replace(',', '', $bl_container->container_net_wt);
                                        $totalcm += (float) str_replace(',', '', $bl_container->container_cbm);
                                        $totalpkgs += (float) str_replace(',', '', $bl_container->container_packages);
                                    @endphp
                                </tr>
                            @endforeach
                        @endforeach
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="13">Total</th>
                        <th>{{ $totalgross }}</th>
                        <th>{{ $totalnet }}</th>
                        <th>{{ $totalcm }}</th>
                        <th colspan="2">{{ $totalpkgs }}</th>
                    </tr>
                </tfoot>
            </table>
        </div>
        {{-- end Pagination --}}
    </div>
    <!-- jQuery (Required for DataTables) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>

    <script>
        $(document).ready(function() {
            // Check if DataTable library is loaded
            if ($.fn.dataTable) {
                // Initialize the DataTable
                $('#jobBalancingReport').DataTable({
                    dom: 'Bfrtip', // Include export buttons in the DOM
                    buttons: [{
                            extend: 'excelHtml5',
                            text: 'Export to Excel',
                            title: 'Job Wise Container List',
                            exportOptions: {
                                columns: ':visible' // Export only visible columns
                            }
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'Export to PDF',
                            title: 'Job Wise Container List',
                            exportOptions: {
                                columns: ':visible' // Export only visible columns
                            },
                            customize: function(doc) {
                                // Customize PDF output if needed
                                doc.content[1].margin = [0, 0, 0, 0]; // Adjust margins
                                doc.content[1].table.widths = '*'.repeat(doc.content[1].table.body[
                                    0].length).split('');
                            }
                        },
                        {
                            extend: 'print',
                            text: 'Print Table',
                            exportOptions: {
                                columns: ':visible' // Export only visible columns
                            }
                        }
                    ],
                    initComplete: function() {
                        // Show the table after DataTables initialization is complete
                        $('#jobBalancingReport').show();
                    }
                });
            }
        });
    </script>
@endsection
