@extends('layout.master')

@section('title')
    JOB-BALANCING-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Job Balancing</a>
@endsection

@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="GET" id="myForm" action="{{ url('/report/show_job_balancing') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Job Balancing
                        </h2>

                        <button type="submit" class="btn btn-primary">Report</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>



                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="col-md-3 mt-2">
                                    <label>Date Type</label>
                                    <select data-placeholder="Select Date Type" id="date_type" name="date_type"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        <option value="1" {{ request('date_type') == 1 ? 'selected' : '' }}>Job Date
                                        </option>
                                        <option value="2" {{ request('date_type') == 2 ? 'selected' : '' }}>
                                            Sailing/Arrival Date</option>
                                        <option value="3" {{ request('date_type') == 3 ? 'selected' : '' }} selected>
                                            Invoice Date</option>
                                        <option value="4" {{ request('date_type') == 4 ? 'selected' : '' }}>Delivery
                                            Date</option>
                                        <option value="5" {{ request('date_type') == 5 ? 'selected' : '' }}>All
                                        </option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Date From</label>
                                    <input id="date_from" type="date" class="form-control" placeholder="Enter Date From"
                                        name="date_from" value="{{ request('date_from', $date_from) }}">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Date Till</label>
                                    <input id="date_till" type="date" class="form-control" name="date_till"
                                        value="{{ request('date_till', $date_to) }}">
                                </div>
                                <div class="col-md-3 mt-10">
                                    <input id="all_operation_types" type="checkbox" class="form-check-input"
                                        name="all_operation_types"
                                        {{ request('all_operation_types') == '1' ? 'checked' : '' }} value="1">
                                    <label class="form-label" for="all_operation_types">
                                        All Operation Types
                                    </label>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Operation</label>
                                    <select id="operation_id" name="operation_id[]" class="tom-select w-full mt-2" multiple>
                                        <option value=""></option>
                                        @foreach ($operations as $item)
                                            <option {{ request('operation_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                {{-- <div class="col-md-3 mt-2">
                                <label>Sort By</label>
                                <select data-placeholder="Select Sort By" id="sort_by"
                                    name="sort_by" class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    <option value="1" {{  request('sort_by') == 1 ? 'selected' : '' }}>Job No</option>
                                    <option value="2" {{  request('sort_by') == 2 ? 'selected' : '' }}>Invoice Date</option>
                                    <option value="3" {{  request('sort_by') == 3 ? 'selected' : '' }}>HBL/HAWB</option>
                                    <option value="4" {{  request('sort_by') == 4 ? 'selected' : '' }}>Client</option>
                                    <option value="5" {{  request('sort_by') == 5 ? 'selected' : '' }}>Final Destination</option>
                                    <option value="6" {{  request('sort_by') == 6 ? 'selected' : '' }}>Sales Rep</option>
                                </select>
                            </div> --}}
                                {{-- <div class="col-md-3 mt-2">
                                <label>Category</label>
                                <select data-placeholder="Select category" id="category"
                                    name="category" class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    <option value="1" {{  request('category') == 1 ? 'selected' : '' }}>Normal</option>
                                    <option value="2" {{  request('category') == 2 ? 'selected' : '' }}>Detention</option>
                                    <option value="3" {{  request('category') == 3 ? 'selected' : '' }}>Demurrage</option>
                                    <option value="4" {{  request('category') == 4 ? 'selected' : '' }}>Security Dep</option>
                                    <option value="5" {{  request('category') == 5 ? 'selected' : '' }}>Running Det</option>
                                    <option value="6" {{  request('category') == 6 ? 'selected' : '' }}>Sect Owt</option>
                                </select>
                            </div> --}}
                                <div class="col-md-3 mt-2">
                                    <label>Sub Type</label>
                                    <select data-placeholder="Select category" id="sub_type" name="sub_type[]"
                                        class="tom-select w-full mt-2" multiple>
                                        <option value=""></option>
                                        <option value="LCL" {{ request('sub_type') == 'LCL' ? 'selected' : '' }}
                                            selected>LCL</option>
                                        <option value="FCL" {{ request('sub_type') == 'FCL' ? 'selected' : '' }}
                                            selected>FCL</option>
                                        <option value="Car" {{ request('sub_type') == 'Car' ? 'selected' : '' }}
                                            selected>Car</option>
                                        <option value="Only Part FCL"
                                            {{ request('sub_type') == 'Only Part FCL' ? 'selected' : '' }}>Only Part FCL
                                        </option>
                                        <option value="BreakBulk"
                                            {{ request('sub_type') == 'BreakBulk' ? 'selected' : '' }} selected>BreakBulk
                                        </option>
                                    </select>
                                </div>
                                {{-- <div class="col-md-3 mt-10">
                                <input id="apply_date_range" type="checkbox"
                                    class="form-check-input" name="apply_date_range"
                                    {{ request('apply_date_range') == '1' ? 'checked' : '' }} value="1">
                                <label class="form-label" for="apply_date_range">
                                    Apply Date RangeOnRec/Pay/Adj/Adv
                                </label>
                            </div> --}}
                                {{-- <div class="col-md-9 mt-12">
                                <input class="form-check-input" type="radio" name="apply_date_range_radio"
                                    id="show_all" value="show_all"
                                    {{ request('apply_date_range_radio') == 'show_all' ? 'checked' : '' }}>
                                <label class="form-label" for="show_all">
                                    Show All
                                </label>
                                <input class="form-check-input" type="radio" name="apply_date_range_radio"
                                    id="exclude_zero" value="exclude_zero"
                                    {{ request('apply_date_range_radio') == 'exclude_zero' ? 'checked' : '' }}>
                                <label class="form-label" for="exclude_zero">
                                    Exclude Zero Balarice
                                </label>
                                <input class="form-check-input" type="radio" name="apply_date_range_radio"
                                    id="balance_amount" value="balance_amount"
                                    {{ request('apply_date_range_radio') == 'balance_amount' ? 'checked' : '' }}>
                                <label class="form-label" for="balance_amount">
                                    Balance Amount
                                </label>
                            </div> --}}
                                <div class="col-md-3 mt-2">
                                    <label>Job Status</label>
                                    <select data-placeholder="Select Job Status" id="job_status_id" name="job_status_id"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($job_status as $item)
                                            <option value="{{ $item->id }}"
                                                {{ request('job_status_id') == $item->id ? 'selected' : '' }}>
                                                {{ $item->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                {{-- <div class="col-md-3 mt-2">
                                <label>Group By</label>
                                <select data-placeholder="Select Group By" id="group_by"
                                    name="group_by" class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    <option value="1" {{  request('group_by') == 1 ? 'selected' : '' }}>Client</option>
                                    <option value="2" {{  request('group_by') == 2 ? 'selected' : '' }}>Final Dest</option>
                                    <option value="3" {{  request('group_by') == 3 ? 'selected' : '' }}>Sales Rep + Client</option>
                                    <option value="4" {{  request('group_by') == 4 ? 'selected' : '' }}>CC Group</option>
                                    <option value="5" {{  request('group_by') == 5 ? 'selected' : '' }}>Sales Rep</option>
                                    <option value="6" {{  request('group_by') == 6 ? 'selected' : '' }}>Consignee/Shipper</option>
                                    <option value="7" {{  request('group_by') == 7 ? 'selected' : '' }}>Operation Type</option>
                                    <option value="8" {{  request('group_by') == 8 ? 'selected' : '' }}>Vendor</option>
                                    <option value="9" {{  request('group_by') == 9 ? 'selected' : '' }}>Sales Rep + Vendor</option>
                                    <option value="10" {{  request('group_by') == 10 ? 'selected' : '' }}>Forwarder/coloader</option>
                                    <option value="11" {{  request('group_by') == 11 ? 'selected' : '' }}>Clearing Agent</option>
                                    <option value="12" {{  request('group_by') == 12 ? 'selected' : '' }}>Forwarder/coloader + Client</option>
                                </select>
                            </div> --}}
                                <div class="col-md-3 mt-10">
                                    <input id="exclude_zero" type="checkbox" class="form-check-input" name="exclude_zero"
                                        {{ request('exclude_zero') == '1' ? 'checked' : '' }} value="1" checked>
                                    <label class="form-label" for="exclude_zero">
                                        Exclude Zero Balance
                                    </label>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Currency</label>
                                    <select id="currency_id" name="currency_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($currencies as $item)
                                            <option {{ request('currency_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Job Type</label>
                                    <select data-placeholder="Select Job Type" id="job_type" name="job_type[]"
                                        class="tom-select w-full mt-2" multiple>
                                        <option value=""></option>
                                        <option value="Direct" {{ request('job_type') == 'Direct' ? 'selected' : '' }}
                                            selected>
                                            Direct</option>
                                        <option value="Coloaded" {{ request('job_type') == 'Coloaded' ? 'selected' : '' }}
                                            selected>
                                            Coloaded</option>
                                        <option value="Cross Trade"
                                            {{ request('job_type') == 'Cross Trade' ? 'selected' : '' }} selected>Cross
                                            Trade
                                        </option>
                                        <option value="Liner Agency"
                                            {{ request('job_type') == 'Liner Agency' ? 'selected' : '' }} selected>Liner
                                            Agency
                                        </option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Type</label>
                                    <select data-placeholder="Select Type" id="type" name="type"
                                        class="tom-select w-full mt-2">
                                        <option value="1" {{ request('type') == 1 ? 'selected' : '' }}>Receivable
                                        </option>
                                        <option value="2" {{ request('type') == 2 ? 'selected' : '' }}>Payable
                                        </option>
                                        <option value="3" {{ request('type') == 3 ? 'selected' : '' }}>Both</option>
                                    </select>
                                </div>
                                {{-- <div class="col-md-3 mt-2">
                                    <label>Type</label>
                                    <select data-placeholder="Select Type" id="type" name="type"
                                        class="tom-select w-full mt-2">
                                        <option value="1" {{ request('type') == 1 ? 'selected' : '' }}>Receivable
                                        </option>
                                        <option value="2" {{ request('type') == 2 ? 'selected' : '' }}>Payable
                                        </option>
                                        <option value="3" {{ request('type') == 3 ? 'selected' : '' }}>Both</option>
                                    </select>
                                </div> --}}
                                <div class="col-md-3 mt-2">
                                    <label>Party Type</label>
                                    <select id="party_type_id" name="party_type_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        <option value="1" {{ request('party_type_id') == 1 ? 'selected' : '' }}>
                                            Shipper</option>
                                        <option value="2" {{ request('party_type_id') == 2 ? 'selected' : '' }}>
                                            Consignee</option>
                                        {{-- @foreach ($party_types as $item)
                                        <option
                                            {{  request('party_types') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach --}}
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Company</label>
                                    <select data-placeholder="Select Company" id="company" name="company"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        <option value="1" {{ request('company') == 1 ? 'selected' : '' }}>YARAN
                                            SHIPPING LINE</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Client</label>
                                    <select id="client_id" name="client_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($clients as $item)
                                            <option {{ request('client_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Vendor</label>
                                    <select id="vendor_id" name="vendor_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($vendors as $item)
                                            <option {{ request('vendor_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Job #</label>
                                    <select id="job_id" name="job_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($jobs as $item)
                                            <option {{ request('job_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->job_no }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">File #</label>
                                    <input id="file_no" type="text" class="form-control" placeholder="Enter File #"
                                        name="file_no" value="{{ request('file_no') }}">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Cost Center</label>
                                    <select data-placeholder="Select Cost Center" id="cost_center" name="cost_center"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        <option {{ request('cost_center') == 'Head Office' ? 'selected' : '' }}
                                            value="Head Office">Head Office</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Sales Rep</label>
                                    <select id="sales_rep_id" name="sales_rep_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($sales_rep as $item)
                                            <option {{ request('sales_rep_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Final Dest</label>
                                    <select id="final_dest_id" name="final_dest_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($un_locations as $item)
                                            <option {{ request('final_dest_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Overseas Agent</label>
                                    <select id="overseas_agent_id" name="overseas_agent_id"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($overseas_agent as $item)
                                            <option {{ request('overseas_agent_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Container</label>
                                    <input id="container" type="text" class="form-control"
                                        placeholder="Enter Container" name="container"
                                        value="{{ request('container') }}">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Vessel</label>
                                    <select id="vessel_id" name="vessel_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($vessels as $item)
                                            <option {{ request('vessel_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Shipping / Air Line</label>
                                    <select id="shipping_line_id" name="shipping_line_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($shipping_line as $item)
                                            <option {{ request('shipping_line_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="principal" class="form-label">Principal</label>
                                    <input id="principal" type="text" class="form-control"
                                        placeholder="Enter Principal" name="principal"
                                        value="{{ request('principal') }}">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Consignee</label>
                                    <select id="consignee_id" name="consignee_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($consignees as $item)
                                            <option {{ request('consignee_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Forwarder/Coloader</label>
                                    <select id="forwarded_coloader_id" name="forwarded_coloader_id"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($forwarded_coloader as $item)
                                            <option {{ request('forwarded_coloader_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Clearing Agent</label>
                                    <select id="clearing_agent_id" name="clearing_agent_id"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($custom_clearance as $item)
                                            <option {{ request('clearing_agent_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Shipper</label>
                                    <select id="shipper_id" name="shipper_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($shippers as $item)
                                            <option {{ request('shipper_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Commodity</label>
                                    <select id="commodity_id" name="commodity_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($commodities as $item)
                                            <option {{ request('commodity_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Carrier Booking #</label>
                                    <input id="carrier_booking_no" type="text" class="form-control"
                                        placeholder="Enter Carrier Booking #" name="carrier_booking_no"
                                        value="{{ request('carrier_booking_no') }}">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Port of Loading</label>
                                    <select id="port_of_loading_id" name="port_of_loading_id"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($un_locations as $item)
                                            <option {{ request('port_of_loading_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Terminal Name</label>
                                    <select class="tom-select" name="terminal_id" id="terminal_id">
                                        <option value="">Please Select</option>
                                        @foreach ($party_locations as $item)
                                            <option value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Air POL</label>
                                    <select id="air_pol_id" name="air_pol_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($un_locations as $item)
                                            <option {{ request('air_pol_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Air POD</label>
                                    <select id="air_pod_id" name="air_pod_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($un_locations as $item)
                                            <option {{ request('air_pod_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>POD</label>
                                    <select id="pod_id" name="pod_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($un_locations as $item)
                                            <option {{ request('pod_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Flight #</label>
                                    <input id="flight_no" type="text" class="form-control"
                                        placeholder="Enter Flight #" name="flight_no"
                                        value="{{ request('flight_no') }}">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Manifest #</label>
                                    <input id="manifest_no" type="text" class="form-control"
                                        placeholder="Enter Manifest #" name="manifest_no"
                                        value="{{ request('manifest_no') }}">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Voyage</label>
                                    <select id="voyage_id" name="voyage_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($voyages as $item)
                                            <option {{ request('voyage_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Lg J/Typ</label>
                                    <select data-placeholder="Select Lg J/Typ" id="lgj_typ" name="lgj_typ"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        <option value="1" {{ request('lgj_typ') == 1 ? 'selected' : '' }}>Transport
                                        </option>
                                        <option value="2" {{ request('lgj_typ') == 2 ? 'selected' : '' }}>Passport
                                        </option>
                                        <option value="3" {{ request('lgj_typ') == 3 ? 'selected' : '' }}>Clearing &
                                            Transport</option>
                                        <option value="4" {{ request('lgj_typ') == 4 ? 'selected' : '' }}>Clearing
                                        </option>
                                        <option value="5" {{ request('lgj_typ') == 5 ? 'selected' : '' }}>All
                                        </option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Shippment Status</label>
                                    <select id="ship_status_id" name="ship_status_id" class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        @foreach ($ship_status as $item)
                                            <option {{ request('ship_status_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Terminal Invoice #</label>
                                    <input id="terminal_invoice_no" type="text" class="form-control"
                                        placeholder="Enter Terminal Invoice #" name="terminal_invoice_no"
                                        value="{{ request('terminal_invoice_no') }}">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Nomination</label>
                                    <select data-placeholder="Select Nomination" id="nomination" name="nomination"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        <option {{ request('nomination') == 'Free Hand' ? 'selected' : '' }}
                                            value="Free Hand">
                                            Free Hand</option>
                                        <option {{ request('nomination') == 'Nominated' ? 'selected' : '' }}
                                            value="Nominated">
                                            Nominated</option>
                                        <option {{ request('nomination') == 'B2B' ? 'selected' : '' }} value="B2B">B2B
                                        </option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Customer Grp</label>
                                    <select data-placeholder="Select Lg J/Typ" id="customer_grp" name="customer_grp"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Ref #</label>
                                    <input id="ref_no" type="text" class="form-control" placeholder="Enter Ref #"
                                        name="ref_no" value="{{ request('ref_no') }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const allOperationTypesCheckbox = document.getElementById('all_operation_types');
        const operationSelect = document.getElementById('operation_id');

        allOperationTypesCheckbox.addEventListener('change', function() {
            if (this.checked) {
                operationSelect.disabled = true;
                operationSelect.value = '';
            } else {
                operationSelect.disabled = false;
            }
        });
    });
</script>
