<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking Status Print</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap"
        rel="stylesheet">
    <style>
        @media print {
            table {
                page-break-inside: auto;
            }

            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }

            .no-print {
                display: none;
            }
        }

        @media print {
            @page {
                size: A4;
            }

            .container {
                width: 100%;
                margin: 0;
                padding: 0;
            }

            table {
                width: 100%;
                border-collapse: collapse;
            }

            th,
            td {
                padding: 4px;
            }
        }

        @media print {
            table {
                page-break-inside: auto;
            }

            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }

            .no-print {
                display: none;
            }

            @page {
                size: landscape;
                /* Set the page to landscape mode */
            }

            .container {
                width: 95%;
                margin: 0;
                padding: 0;
            }

            table {
                width: 100%;
                border-collapse: collapse;
            }

            th,
            td {
                padding: 4px;
            }



        }


        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: "Poppins", sans-serif;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid black;
            padding: 5px 3px;
            text-align: center;
            width: fit-content;
            height: fit-content;
            font-size: 12px;
            /* Adjust width for columns */
        }

        th {
            background-color: #f2f2f2;
            text-align: center;
        }

        .total-cell {
            border-left: none;
            text-align: center;
            font-weight: bold;
        }

        .no-border {
            border: none;
        }

        .with-border-right {
            border-right: 1px solid black;
        }

        /* Center company logo and information */
        .logo-container {
            display: flex;
            justify-content: center;
            align-items: center;
            text-align: center;
            flex-direction: column;
            margin-bottom: 20px;
        }

        .logo-container img {
            width: 200px;
            border: 1px solid rgb(148, 144, 144);
            border-left: none;
            border-right: none;
            padding-bottom: 8px;
            border-top: none;
            margin-bottom: 10px;
        }

        .logo-container h2,
        .logo-container h3,
        .logo-container p {
            margin: 5px 0;
        }

        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            display: flex;
            justify-content: space-between;
            font-size: 10px;
            text-align: center;
            background: #fff;
            /* optional */
            padding: 5px 10px;
            border-top: 1px solid #ccc;
            /* optional */
        }


        .footer-left,
        .footer-center,
        .footer-right {
            flex: 1;
            display: flex;
            justify-content: space-between;
        }

        .footer-left {
            text-align: left;
        }

        .footer-center {
            text-align: center;
        }

        .footer-right {
            text-align: right;
        }

        .footer-right::after {
            content: "Page " counter(page);
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="logo-container">
            <img src="{{ url('logo-invoice.png') }}" alt="Company Logo">
            <div>
                <h2 class="font-bold" style="font-size: 20px;">YARAN SHIPPING LINE</h2>
                <h3 class="font-medium pb-10">Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p>Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <!-- Date Range -->
        <div style="display: flex; justify-content: flex-end; align-items: center; margin-bottom: 5px;">
            <h2 style="font-weight: bold; margin: 0 5px 0 0; font-size: 10px;">
                From = {{ $dateFrom ? \Carbon\Carbon::parse($dateFrom)->format('d-M-Y') : '---' }}
            </h2>
            <h2 style="font-weight: bold; margin: 0; font-size: 10px;">
                Till = {{ $dateTill ? \Carbon\Carbon::parse($dateTill)->format('d-M-Y') : '---' }}
            </h2>
        </div>

        <!-- Header Line and Title (Right Aligned) -->
        <div style="display: flex; align-items: center; justify-content: flex-end; margin: 5px 0 10px 0;">
            <!-- Left line (longer) -->
            <div style="flex: 1; border-top: 3px double #000; margin-right: 10px; height: 0;"></div>

            <!-- Title -->
            <h2
                style="
        margin: 0;
        font-weight: bold;
        font-size: 14px;
        white-space: nowrap;
        text-align: right;
    ">
                Job Balancing Reports
            </h2>

            <!-- Right line (shorter) -->
            <div style="width: 60px; border-top: 3px double #000; margin-left: 10px; height: 0;"></div>
        </div>




        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2 display nowrap" id="jobBalancingReport" style="width:100%">
                <thead>
                    <tr>
                        <th>S#</th>
                        @if ($type == 1 || $type == 2)
                            <th>Inv No</th>
                            <th>Job No</th>
                            <th>Job Date</th>
                        @else
                            <th>Inv / Bill #</th>
                        @endif
                        <th>HBL/HAWB</th>
                        @if ($type == 3)
                            <th>MBL/MAWB</th>
                        @endif
                        @if ($type == 1)
                            <th>Client</th>
                            <th>Final Destination</th>
                            <th>J/Tp</th>
                            <th>F/Tp</th>
                        @elseif($type == 2)
                            <th>Vendor</th>
                            <th>Final Destination</th>
                            <th>J/Tp</th>
                            <th>F/Tp</th>
                        @endif
                        @if ($type == 3)
                            <th>Arrival Date</th>
                        @endif
                        <th>Cntrs</th>
                        @if ($type == 1 || $type == 2)
                            <th>WT</th>
                            <th>Vol</th>
                        @endif
                        <th>Curr</th>
                        @if ($type == 1 || $type == 3)
                            <th>Receivable</th>
                        @endif
                        @if ($type == 2 || $type == 3)
                            <th>Payable</th>
                        @endif
                        <th>Adjust</th>
                        @if ($type == 1 || $type == 3)
                            <th>Received</th>
                        @endif
                        @if ($type == 2 || $type == 3)
                            <th>Paid</th>
                        @endif
                        <th>Balance</th>
                        <th>Age</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $totalReceivable = 0;
                        $totalPayable = 0;
                        $totalReceived = 0;
                        $totalPaid = 0;
                        $totalBalanceRec = 0;
                        $totalBalancePay = 0;
                        $totalBalanceBoth = 0;
                        $total_receivables = 0;
                        $total_payables = 0;
                        $totalCount20 = 0;
                        $totalCount40 = 0;
                        $totalCount45 = 0;

                    @endphp
                    @foreach ($mergedData as $index => $item)
                        @if ($item['type'] == 'job')
                            @php
                                $job = $item['data'];
                                if ($client) {
                                    // Sum ONLY receivables that belong to the selected client
                                    $total_receivables = ($job->job_charges_receivable ?? collect())
                                        ->where('customer_id', $client)
                                        ->whereNotNull('bill_invoice')
                                        ->sum('local_amount'); // change field if needed
                                } else {
                                    $total_receivables = $job->total_receivable ?? 0;
                                }
                                if ($vendor) {
                                    $total_payables = ($job->job_charges_payable ?? collect())
                                        ->where('vendor_id', $vendor)
                                        ->whereNotNull('bill_invoice')
                                        ->sum('local_amount'); // change field if needed
                                } else {
                                    $total_payables = $job->total_payable ?? 0;
                                }
                                $count20 = $count40 = $count45 = 0;

                                // Normalize to a collection of arrays
                                $containersRaw = optional($job->bl_master)->bl_container_info;

                                $containerss = collect(
                                    is_array($containersRaw)
                                        ? $containersRaw
                                        : (is_iterable($containersRaw)
                                            ? $containersRaw
                                            : []),
                                );

                                foreach ($containerss as $cc) {
                                    // Handle both array or object style
                                    $cont_type = is_array($cc)
                                        ? $cc['container_size_type'] ?? ''
                                        : $cc->container_size_type ?? '';

                                    if (!$cont_type) {
                                        continue;
                                    }
                                    if (str_starts_with(strtolower($cont_type), 'm3')) {
                                        continue;
                                    }

                                    $cont_prefix = substr($cont_type, 0, 2);

                                    if ($cont_prefix === '20') {
                                        $count20++;
                                    } elseif ($cont_prefix === '40') {
                                        $count40++;
                                    } elseif ($cont_prefix === '45') {
                                        $count45++;
                                    }
                                }

                                // accumulate totals
                                $totalCount20 = ($totalCount20 ?? 0) + $count20;
                                $totalCount40 = ($totalCount40 ?? 0) + $count40;
                                $totalCount45 = ($totalCount45 ?? 0) + $count45;
                            @endphp
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>
                                    @php

                                        // === Receivables ===
                                        $receivableData = collect($job->job_charges_receivable);
                                        if ($client) {
                                            $receivableData = $receivableData->where('customer_id', $client);
                                        }

                                        // === Payables ===
                                        $payableData = collect($job->job_charges_payable);
                                        if ($vendor) {
                                            $payableData = $payableData->where('vendor_id', $vendor);
                                        }

                                        // === Calculate age BEFORE plucking ===
                                        $receivableDays = $receivableData->isNotEmpty()
                                            ? \Carbon\Carbon::parse($receivableData->min('created_at'))->diffInDays(
                                                \Carbon\Carbon::now(),
                                            )
                                            : null;
                                        // dd($receivableDays);
                                        $payableDays = $payableData->isNotEmpty()
                                            ? \Carbon\Carbon::parse($payableData->min('created_at'))->diffInDays(
                                                \Carbon\Carbon::now(),
                                            )
                                            : null;

                                        // === Then pluck only for display ===
                                        $receivableInvoices = $receivableData->pluck('bill_invoice')->unique();
                                        $payableInvoices = $payableData->pluck('bill_invoice')->unique();
                                    @endphp
                                    @if ($type == 1 || $type == 3)
                                        @foreach ($receivableInvoices as $invoice)
                                            {{ $invoice }}
                                            @if (!$loop->last)
                                                ,
                                            @endif
                                        @endforeach
                                    @endif

                                    @if ($type == 2 || $type == 3)
                                        @foreach ($payableInvoices as $invoice)
                                            {{ $invoice }}
                                            @if (!$loop->last)
                                                ,
                                            @endif
                                        @endforeach
                                    @endif
                                </td>
                                @if ($type == 1 || $type == 2)
                                    <td>{{ @$job->job_no }}</td>
                                    <td>{{ @$job->job_date }}</td>
                                @endif
                                <td>{{ @$job->bl_master->hbl_no }}</td>
                                @if ($type == 3)
                                    <td>{{ @$job->bl_master->mbl_no }}</td>
                                @endif
                                @if ($type == 1)
                                    <td>{{ @$job->job_detail->client->name }}</td>
                                    <td>{{ @$job->job_routing->final_destination->name }}</td>
                                    <td>{{ @$job->job_type }}</td>
                                    <td>{{ @$job->freight_type }}</td>
                                @elseif($type == 2)
                                    <td>{{ @$job->job_detail->local_vendor->name }}</td>
                                    <td>{{ @$job->job_routing->final_destination->name }}</td>
                                    <td>{{ @$job->job_type }}</td>
                                    <td>{{ @$job->freight_type }}</td>
                                @endif
                                @if ($type == 3)
                                    <td>{{ @$job->bl_master->sailing_date }}</td>
                                @endif
                                <td>
                                    {{ collect($job->bl_master->bl_container_info)->pluck('container_no')->implode(', ') ?: '---' }}
                                </td>
                                @if ($type == 1 || $type == 2)
                                    <td>{{ @$job->job_weight->weight }}</td>
                                    <td>{{ @$job->job_weight->vol }}</td>
                                @endif
                                <td>PKR</td>

                                {{-- @if (@$job->ex_rate == 1)
                                <td>PKR</td>
                                @elseif(@$job->ex_rate == 2)
                                <td>USD</td>
                                @elseif(@$job->ex_rate == 3)
                                <td>AED</td>
                                @elseif(@$job->ex_rate == 4)
                                <td>BDT</td>
                                @elseif(@$job->ex_rate == 5)
                                <td>OMR</td>
                                @elseif(@$job->ex_rate == 6)
                                <td>EUR</td>
                                @elseif(@$job->ex_rate == 7)
                                <td>GBP</td>
                                @endif
                                <td>{{ @$job->ex_rate }}</td> --}}
                                @if ($type == 1 || $type == 3)
                                    <td>{{ number_format($total_receivables, 2) }}</td>
                                @endif
                                @if ($type == 2 || $type == 3)
                                    <td>{{ number_format($total_payables, 2) }}</td>
                                @endif
                                <td>0.00</td>
                                @php
                                    $receivedAmount = 0;
                                    $paidAmount = 0;
                                    foreach ($receipt_payment_rec as $receipt) {
                                        foreach (@$receipt->receipt_detail as $detail) {
                                            if ($detail->job_no == $job->id) {
                                                $receivedAmount += (int) $detail->rcvd_converted_amount;
                                            }
                                        }
                                    }
                                    foreach ($receipt_payment_pay as $receipt) {
                                        foreach (@$receipt->receipt_detail as $detail) {
                                            if ($detail->job_no == $job->id) {
                                                $paidAmount += (int) $detail->rcvd_converted_amount;
                                            }
                                        }
                                    }
                                    $bothamount = $total_receivables + $total_payables;
                                    $bothPaidRec = $receivedAmount + $paidAmount;
                                    $bothbalance = $bothamount - $bothPaidRec;
                                    $balanceRec = $total_receivables - $receivedAmount;
                                    $balancePay = $total_payables - $paidAmount;
                                    $totalReceivable += $total_receivables;
                                    $totalPayable += $total_payables;
                                    $totalReceived += $receivedAmount;
                                    $totalPaid += $paidAmount;
                                    $totalBalanceRec += $balanceRec;
                                    $totalBalancePay += $balancePay;
                                    $totalBalanceBoth += $bothbalance;

                                @endphp
                                @if ($type == 1)
                                    <td>{{ number_format($receivedAmount, 2) }}</td>
                                    <td>{{ number_format($balanceRec, 2) }}</td>
                                @elseif($type == 2)
                                    <td>{{ number_format($paidAmount, 2) }}</td>
                                    <td>{{ number_format($balancePay, 2) }}</td>
                                @else
                                    <td>{{ number_format($receivedAmount, 2) }}</td>
                                    <td>{{ number_format($paidAmount, 2) }}</td>
                                    <td>{{ number_format($bothbalance, 2) }}</td>
                                @endif
                                @php
                                    $total_receivables = 0;
                                    $total_payables = 0;
                                @endphp
                                {{-- Show Age column --}}
                                @if ($type == 1)
                                    <td>{{ $receivableDays !== null ? $receivableDays . ' days' : '---' }}</td>
                                @elseif ($type == 2)
                                    <td>{{ $payableDays !== null ? $payableDays . ' days' : '---' }}</td>
                                @elseif ($type == 3)
                                    @php
                                        // Prefer receivable days if it exists, otherwise payable
                                        $ageDays = $receivableDays ?? $payableDays;
                                        $label =
                                            $receivableDays !== null
                                                ? 'Receivable'
                                                : ($payableDays !== null
                                                    ? 'Payable'
                                                    : null);
                                    @endphp
                                    <td>
                                        {{ $ageDays !== null ? $label . ': ' . $ageDays . ' days' : '---' }}
                                    </td>
                                @endif
                            </tr>
                        @elseif ($item['type'] == 'receipt')
                            @php
                                $receipt = $item['data'];
                                if ($client && $receipt->type == 'receipt') {
                                    // Sum ONLY receivables that belong to the selected client
                                    $total_receivables = 0 - (int) $receipt->advance; // change field if needed
                                } else {
                                    $total_receivables = 0;
                                }
                                if ($vendor && $receipt->type == 'payment') {
                                    $total_payables = (int) $receipt->advance; // change field if needed
                                } else {
                                    $total_payables = 0;
                                }
                            @endphp
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>
                                    {{ $receipt->trans_no }}
                                </td>
                                @if ($type == 1 || $type == 2)
                                    <td>ADVANCE</td>
                                    <td></td>
                                @endif
                                <td></td>
                                @if ($type == 3)
                                    <td></td>
                                @endif
                                @if ($type == 1 || $type == 2)
                                    <td>{{ $receipt->client?->name }}</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                @endif
                                @if ($type == 3)
                                    <td></td>
                                @endif
                                <td></td>
                                @if ($type == 1 || $type == 2)
                                    <td></td>
                                    <td></td>
                                @endif
                                <td>PKR</td>

                                {{-- @if (@$job->ex_rate == 1)
                                <td>PKR</td>
                                @elseif(@$job->ex_rate == 2)
                                <td>USD</td>
                                @elseif(@$job->ex_rate == 3)
                                <td>AED</td>
                                @elseif(@$job->ex_rate == 4)
                                <td>BDT</td>
                                @elseif(@$job->ex_rate == 5)
                                <td>OMR</td>
                                @elseif(@$job->ex_rate == 6)
                                <td>EUR</td>
                                @elseif(@$job->ex_rate == 7)
                                <td>GBP</td>
                                @endif
                                <td>{{ @$job->ex_rate }}</td> --}}
                                @if ($type == 1 || $type == 3)
                                    <td>{{ number_format($total_receivables, 2) }}</td>
                                @endif
                                @if ($type == 2 || $type == 3)
                                    <td>{{ number_format($total_payables, 2) }}</td>
                                @endif
                                <td>0.00</td>
                                @php
                                    $receivedAmount = 0;
                                    $paidAmount = 0;
                                    $bothamount = $total_receivables + $total_payables;
                                    $bothPaidRec = $receivedAmount + $paidAmount;
                                    $bothbalance = $bothamount - $bothPaidRec;
                                    $balanceRec = $total_receivables - $receivedAmount;
                                    $balancePay = $total_payables - $paidAmount;
                                    $totalReceivable += $total_receivables;
                                    $totalPayable += $total_payables;
                                    $totalReceived += $receivedAmount;
                                    $totalPaid += $paidAmount;
                                    $totalBalanceRec += $balanceRec;
                                    $totalBalancePay += $balancePay;
                                    $totalBalanceBoth += $bothbalance;
                                @endphp
                                @if ($type == 1)
                                    <td>{{ number_format($receivedAmount, 2) }}</td>
                                    <td>{{ number_format($balanceRec, 2) }}</td>
                                @elseif($type == 2)
                                    <td>{{ number_format($paidAmount, 2) }}</td>
                                    <td>{{ number_format($balancePay, 2) }}</td>
                                @else
                                    <td>{{ number_format($receivedAmount, 2) }}</td>
                                    <td>{{ number_format($paidAmount, 2) }}</td>
                                    <td>{{ number_format($bothbalance, 2) }}</td>
                                @endif
                                @php
                                    $total_receivables = 0;
                                    $total_payables = 0;
                                @endphp

                                {{-- Show Receivable days (for type 1 or 3) --}}
                                @if ($type == 1)
                                    <td>{{ $receivableDays !== null ? $receivableDays . ' days' : '---' }}</td>
                                @elseif ($type == 2)
                                    <td>{{ $payableDays !== null ? $payableDays . ' days' : '---' }}</td>
                                @elseif ($type == 3)
                                    @php
                                        // Prefer receivable days if it exists, otherwise payable
                                        $ageDays = $receivableDays ?? $payableDays;
                                        $label =
                                            $receivableDays !== null
                                                ? 'Receivable'
                                                : ($payableDays !== null
                                                    ? 'Payable'
                                                    : null);
                                    @endphp
                                    <td>
                                        {{ $ageDays !== null ? $label . ': ' . $ageDays . ' days' : '---' }}
                                    </td>
                                @endif
                            </tr>
                        @endif
                    @endforeach
                    <tr>
                        @if ($type == 1)
                            <th colspan="7"> Total Containers:{{ $totalCount20 }} x 20, {{ $totalCount40 }} x 40,
                                {{ $totalCount45 }} x 45 </th>
                            <th colspan="7">Total </th>
                            <th>{{ number_format($totalReceivable, 2) }}</th>
                            <th>0.0</th>
                            <th>{{ number_format($totalReceived, 2) }}</th>
                            <th>{{ number_format($totalBalanceRec, 2) }}</th>
                        @elseif($type == 2)
                            <th colspan="7"> Total Containers:{{ $totalCount20 }} x 20, {{ $totalCount40 }} x 40,
                                {{ $totalCount45 }} x 45 </th>
                            <th colspan="7">Total </th>
                            <th>{{ number_format($totalPayable, 2) }}</th>
                            <th>0.0</th>
                            <th>{{ number_format($totalPaid, 2) }}</th>
                            <th>{{ number_format($totalBalancePay, 2) }}</th>
                        @else
                            <th colspan="4"> Total Containers:{{ $totalCount20 }} x 20, {{ $totalCount40 }} x 40,
                                {{ $totalCount45 }} x 45 </th>
                            <th colspan="4">Total </th>
                            <th>{{ number_format($totalReceivable, 2) }}</th>
                            <th>{{ number_format($totalPayable, 2) }}</th>
                            <th>0.0</th>
                            <th>{{ number_format($totalReceived, 2) }}</th>
                            <th>{{ number_format($totalPaid, 2) }}</th>
                            <th>{{ number_format($totalBalanceBoth, 2) }}</th>
                        @endif
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="footer">
        <div class="footer-left">
            <p>Printed On: {{ now()->setTimezone('Asia/Karachi')->format('Y-m-d H:i:s') }}</p>
        </div>
        <div class="footer-center">
            <p>Printed By: {{ auth()->user()->name }}</p>
        </div>

    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            window.print(); // Trigger the print dialog once the page loads
        });
    </script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Get today's date
            const today = new Date();

            // Format the date as DD-MM-YYYY
            const day = String(today.getDate()).padStart(2, '0'); // Ensure two digits (e.g., 01, 02)
            const month = String(today.getMonth() + 1).padStart(2, '0'); // Get month (0-11), so add 1
            const year = today.getFullYear(); // Get the full year (e.g., 2025)

            // Format the date as DD-MM-YYYY
            const formattedDate = `${day}-${month}-${year}`;

            // Set the page title dynamically
            document.title = `Job Balancing Report (${formattedDate})`;
        });
    </script>



</body>

</html>
