@extends('layout.master')

@section('title')
    JOB-BALANCING-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Job Balancing Report</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none;border-right: none; padding-bottom: 8px;border-top: none; margin-right: 70px; margin-bottom: 10px;">
            <!-- Added margin-bottom for gap -->
            <div class="text-center">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight:bold">YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10">Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p>Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">

            <a href="{{ route('job-balancing-report', [
                'is_print' => 1,
                'date_type' => request('date_type'),
                'date_from' => request('date_from'),
                'date_till' => request('date_till'),
                'all_operation_types' => request('all_operation_types'),
                'operation_id' => request('operation_id'),
                'exclude_zero' => request('exclude_zero'),
                'sub_type' => request('sub_type'),
                'job_status_id' => request('job_status_id'),
                'group_by' => request('group_by'),
                'currency_id' => request('currency_id'),
                'job_type' => request('job_type'),
                'type' => request('type'),
                'party_type_id' => request('party_type_id'),
                'client_id' => request('client_id'),
                'vendor_id' => request('vendor_id'),
                'job_id' => request('job_id'),
                'file_no' => request('file_no'),
                'cost_center' => request('cost_center'),
                'sales_rep_id' => request('sales_rep_id'),
                'final_dest_id' => request('final_dest_id'),
                'overseas_agent_id' => request('overseas_agent_id'),
                'container' => request('container'),
                'vessel_id' => request('vessel_id'),
                'shipping_line_id' => request('shipping_line_id'),
                'consignee_id' => request('consignee_id'),
                'forwarded_coloader_id' => request('forwarded_coloader_id'),
                'clearing_agent_id' => request('clearing_agent_id'),
                'shipper_id' => request('shipper_id'),
                'commodity_id' => request('commodity_id'),
                'port_of_loading_id' => request('port_of_loading_id'),
                'terminal_id' => request('terminal_id'),
                'air_pol_id' => request('air_pol_id'),
                'air_pod_id' => request('air_pod_id'),
                'pod_id' => request('pod_id'),
                'voyage_id' => request('voyage_id'),
                'lgj_typ' => request('lgj_typ'),
                'manifest_no' => request('manifest_no'),
                'flight_no' => request('flight_no'),
                'carrier_booking_no' => request('carrier_booking_no'),
                'principal' => request('principal'),
                'ship_status_id' => request('ship_status_id'),
                'nomination' => request('nomination'),
                'ref_no' => request('ref_no'),
            ]) }}"
                class="btn btn-primary mt-2" target="_blank">Print</a>
            <table class="table table-bordered mt-n2 display nowrap" id="jobBalancingReport"
                style="display: none; width:100%">
                <thead>
                    <tr>
                        <th>S#</th>
                        @if ($type == 1 || $type == 2)
                            <th>Inv No</th>
                            <th>Job No</th>
                            <th>Job Date</th>
                        @else
                            <th>Inv / Bill #</th>
                            <th>Job No</th>
                        @endif
                        <th>HBL/HAWB</th>
                        @if ($type == 3)
                            <th>MBL/MAWB</th>
                        @endif
                        @if ($type == 1)
                            <th>Client</th>
                            <th>Final Destination</th>
                            <th>J/Tp</th>
                            <th>F/Tp</th>
                        @elseif($type == 2)
                            <th>Vendor</th>
                            <th>Final Destination</th>
                            <th>J/Tp</th>
                            <th>F/Tp</th>
                        @endif
                        @if ($type == 3)
                            <th>Arrival Date</th>
                        @endif
                        <th>Cntrs</th>
                        @if ($type == 1 || $type == 2)
                            <th>WT</th>
                            <th>Vol</th>
                        @endif
                        <th>Curr</th>
                        @if ($type == 1 || $type == 3)
                            <th>Receivable</th>
                        @endif
                        @if ($type == 2 || $type == 3)
                            <th>Payable</th>
                        @endif
                        <th>Adjust</th>
                        @if ($type == 1 || $type == 3)
                            <th>Received</th>
                        @endif
                        @if ($type == 2 || $type == 3)
                            <th>Paid</th>
                        @endif
                        <th>Balance</th>
                        {{-- <th>Sales Rep</th> --}}
                        @if ($type == 1 || $type == 2)
                            <th>Age</th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                    @php
                        $totalReceivable = 0;
                        $totalPayable = 0;
                        $totalReceived = 0;
                        $totalPaid = 0;
                        $totalBalanceRec = 0;
                        $totalBalancePay = 0;
                        $totalBalanceBoth = 0;
                        $total_receivables = 0;
                        $total_payables = 0;
                    @endphp
                    @foreach ($mergedData as $index => $item)
                        @if ($item['type'] == 'job')
                            @php
                                $job = $item['data'];
                                if ($client) {
                                    // Sum ONLY receivables that belong to the selected client
                                    $total_receivables = ($job->job_charges_receivable ?? collect())
                                        ->where('customer_id', $client)
                                        ->whereNotNull('bill_invoice')
                                        ->sum('local_amount'); // change field if needed
                                } else {
                                    $total_receivables = $job->total_receivable ?? 0;
                                }
                                if ($vendor) {
                                    $total_payables = ($job->job_charges_payable ?? collect())
                                        ->where('vendor_id', $vendor)
                                        ->whereNotNull('bill_invoice')
                                        ->sum('local_amount'); // change field if needed
                                } else {
                                    $total_payables = $job->total_payable ?? 0;
                                }
                                $count20 = $count40 = $count45 = 0;

                                // Normalize to a collection of arrays
                                $containersRaw = optional($job->bl_master)->bl_container_info;

                                $containerss = collect(
                                    is_array($containersRaw)
                                        ? $containersRaw
                                        : (is_iterable($containersRaw)
                                            ? $containersRaw
                                            : []),
                                );

                                foreach ($containerss as $cc) {
                                    // Handle both array or object style
                                    $cont_type = is_array($cc)
                                        ? $cc['container_size_type'] ?? ''
                                        : $cc->container_size_type ?? '';

                                    if (!$cont_type) {
                                        continue;
                                    }
                                    if (str_starts_with(strtolower($cont_type), 'm3')) {
                                        continue;
                                    }

                                    $cont_prefix = substr($cont_type, 0, 2);

                                    if ($cont_prefix === '20') {
                                        $count20++;
                                    } elseif ($cont_prefix === '40') {
                                        $count40++;
                                    } elseif ($cont_prefix === '45') {
                                        $count45++;
                                    }
                                }

                                // accumulate totals
                                $totalCount20 = ($totalCount20 ?? 0) + $count20;
                                $totalCount40 = ($totalCount40 ?? 0) + $count40;
                                $totalCount45 = ($totalCount45 ?? 0) + $count45;
                            @endphp
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>
                                    @php

                                        // === Receivables ===
                                        $receivableData = collect($job->job_charges_receivable);
                                        if ($client) {
                                            $receivableData = $receivableData->where('customer_id', $client);
                                        }

                                        // === Payables ===
                                        $payableData = collect($job->job_charges_payable);
                                        if ($vendor) {
                                            $payableData = $payableData->where('vendor_id', $vendor);
                                        }

                                        // === Calculate age BEFORE plucking ===
                                        $receivableDays = $receivableData->isNotEmpty()
                                            ? \Carbon\Carbon::parse($receivableData->min('created_at'))->diffInDays(
                                                \Carbon\Carbon::now(),
                                            )
                                            : null;
                                        // dd($receivableDays);
                                        $payableDays = $payableData->isNotEmpty()
                                            ? \Carbon\Carbon::parse($payableData->min('created_at'))->diffInDays(
                                                \Carbon\Carbon::now(),
                                            )
                                            : null;

                                        // === Then pluck only for display ===
                                        $receivableInvoices = $receivableData->pluck('bill_invoice')->unique();
                                        $payableInvoices = $payableData->pluck('bill_invoice')->unique();
                                    @endphp
                                    @if ($type == 1 || $type == 3)
                                        @foreach ($receivableInvoices as $invoice)
                                            {{ $invoice }}
                                            @if (!$loop->last)
                                                ,
                                            @endif
                                        @endforeach
                                    @endif

                                    @if ($type == 2 || $type == 3)
                                        @foreach ($payableInvoices as $invoice)
                                            {{ $invoice }}
                                            @if (!$loop->last)
                                                ,
                                            @endif
                                        @endforeach
                                    @endif
                                </td>
                                <td>{{ @$job->job_no }}</td>
                                @if ($type == 1 || $type == 2)
                                    <td>{{ @$job->job_date }}</td>
                                @endif
                                <td>{{ @$job->bl_master->hbl_no }}</td>
                                @if ($type == 3)
                                    <td>{{ @$job->bl_master->mbl_no }}</td>
                                @endif
                                @if ($type == 1)
                                    <td>{{ @$job->job_detail->client->name }}</td>
                                    <td>{{ @$job->job_routing->final_destination->name }}</td>
                                    <td>{{ @$job->job_type }}</td>
                                    <td>{{ @$job->freight_type }}</td>
                                @elseif($type == 2)
                                    <td>{{ @$job->job_detail->local_vendor->name }}</td>
                                    <td>{{ @$job->job_routing->final_destination->name }}</td>
                                    <td>{{ @$job->job_type }}</td>
                                    <td>{{ @$job->freight_type }}</td>
                                @endif
                                @if ($type == 3)
                                    <td>{{ @$job->bl_master->sailing_date }}</td>
                                @endif
                                <td>{{ @$job->job_weight->container }}</td>
                                @if ($type == 1 || $type == 2)
                                    <td>{{ @$job->job_weight->weight }}</td>
                                    <td>{{ @$job->job_weight->vol }}</td>
                                @endif
                                <td>PKR</td>

                                {{-- @if (@$job->ex_rate == 1)
                                    <td>PKR</td>
                                    @elseif(@$job->ex_rate == 2)
                                    <td>USD</td>
                                    @elseif(@$job->ex_rate == 3)
                                    <td>AED</td>
                                    @elseif(@$job->ex_rate == 4)
                                    <td>BDT</td>
                                    @elseif(@$job->ex_rate == 5)
                                    <td>OMR</td>
                                    @elseif(@$job->ex_rate == 6)
                                    <td>EUR</td>
                                    @elseif(@$job->ex_rate == 7)
                                    <td>GBP</td>
                                    @endif
                                    <td>{{ @$job->ex_rate }}</td> --}}
                                @if ($type == 1 || $type == 3)
                                    <td>{{ number_format($total_receivables, 2) }}</td>
                                @endif
                                @if ($type == 2 || $type == 3)
                                    <td>{{ number_format($total_payables, 2) }}</td>
                                @endif
                                <td>0.00</td>
                                @php
                                    $receivedAmount = 0;
                                    $paidAmount = 0;
                                    foreach ($receipt_payment_rec as $receipt) {
                                        foreach (@$receipt->receipt_detail as $detail) {
                                            if ($detail->job_no == $job->id) {
                                                $receivedAmount += (int) $detail->rcvd_converted_amount;
                                            }
                                        }
                                    }
                                    foreach ($receipt_payment_pay as $receipt) {
                                        foreach (@$receipt->receipt_detail as $detail) {
                                            if ($detail->job_no == $job->id) {
                                                $paidAmount += (int) $detail->rcvd_converted_amount;
                                            }
                                        }
                                    }
                                    $bothamount = $total_receivables + $total_payables;
                                    $bothPaidRec = $receivedAmount + $paidAmount;
                                    $bothbalance = $bothamount - $bothPaidRec;
                                    $balanceRec = $total_receivables - $receivedAmount;
                                    $balancePay = $total_payables - $paidAmount;
                                    $totalReceivable += $total_receivables;
                                    $totalPayable += $total_payables;
                                    $totalReceived += $receivedAmount;
                                    $totalPaid += $paidAmount;
                                    $totalBalanceRec += $balanceRec;
                                    $totalBalancePay += $balancePay;
                                    $totalBalanceBoth += $bothbalance;
                                @endphp
                                @if ($type == 1)
                                    <td>{{ number_format($receivedAmount, 2) }}</td>
                                    <td>{{ number_format($balanceRec, 2) }}</td>
                                @elseif($type == 2)
                                    <td>{{ number_format($paidAmount, 2) }}</td>
                                    <td>{{ number_format($balancePay, 2) }}</td>
                                @else
                                    <td>{{ number_format($receivedAmount, 2) }}</td>
                                    <td>{{ number_format($paidAmount, 2) }}</td>
                                    <td>{{ number_format($bothbalance, 2) }}</td>
                                @endif
                                @php
                                    $total_receivables = 0;
                                    $total_payables = 0;
                                @endphp
                                @if ($type == 1)
                                    <td>{{ $receivableDays !== null ? $receivableDays . ' days' : '---' }}</td>
                                @elseif ($type == 2)
                                    <td>{{ $payableDays !== null ? $payableDays . ' days' : '---' }}</td>
                                @endif
                            </tr>
                        @elseif ($item['type'] == 'receipt')
                            @php
                                $receipt = $item['data'];
                                if ($client && $receipt->type == 'receipt') {
                                    // Sum ONLY receivables that belong to the selected client
                                    $total_receivables = 0 - (int) $receipt->advance; // change field if needed
                                } else {
                                    $total_receivables = 0;
                                }
                                if ($vendor && $receipt->type == 'payment') {
                                    $total_payables = (int) $receipt->advance; // change field if needed
                                } else {
                                    $total_payables = 0;
                                }
                            @endphp
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>
                                    {{ $receipt->trans_no }}
                                </td>
                                <td>ADVANCE</td>
                                @if ($type == 1 || $type == 2)
                                    <td></td>
                                @endif
                                <td></td>
                                @if ($type == 3)
                                    <td></td>
                                @endif
                                @if ($type == 1 || $type == 2)
                                    <td>{{ $receipt->client?->name }}</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                @endif
                                @if ($type == 3)
                                    <td></td>
                                @endif
                                <td></td>
                                @if ($type == 1 || $type == 2)
                                    <td></td>
                                    <td></td>
                                @endif
                                <td>PKR</td>

                                {{-- @if (@$job->ex_rate == 1)
                                    <td>PKR</td>
                                    @elseif(@$job->ex_rate == 2)
                                    <td>USD</td>
                                    @elseif(@$job->ex_rate == 3)
                                    <td>AED</td>
                                    @elseif(@$job->ex_rate == 4)
                                    <td>BDT</td>
                                    @elseif(@$job->ex_rate == 5)
                                    <td>OMR</td>
                                    @elseif(@$job->ex_rate == 6)
                                    <td>EUR</td>
                                    @elseif(@$job->ex_rate == 7)
                                    <td>GBP</td>
                                    @endif
                                    <td>{{ @$job->ex_rate }}</td> --}}
                                @if ($type == 1 || $type == 3)
                                    <td>{{ number_format($total_receivables, 2) }}</td>
                                @endif
                                @if ($type == 2 || $type == 3)
                                    <td>{{ number_format($total_payables, 2) }}</td>
                                @endif
                                <td>0.00</td>
                                @php
                                    $receivedAmount = 0;
                                    $paidAmount = 0;
                                    $bothamount = $total_receivables + $total_payables;
                                    $bothPaidRec = $receivedAmount + $paidAmount;
                                    $bothbalance = $bothamount - $bothPaidRec;
                                    $balanceRec = $total_receivables - $receivedAmount;
                                    $balancePay = $total_payables - $paidAmount;
                                    $totalReceivable += $total_receivables;
                                    $totalPayable += $total_payables;
                                    $totalReceived += $receivedAmount;
                                    $totalPaid += $paidAmount;
                                    $totalBalanceRec += $balanceRec;
                                    $totalBalancePay += $balancePay;
                                    $totalBalanceBoth += $bothbalance;
                                @endphp
                                @if ($type == 1)
                                    <td>{{ number_format($receivedAmount, 2) }}</td>
                                    <td>{{ number_format($balanceRec, 2) }}</td>
                                @elseif($type == 2)
                                    <td>{{ number_format($paidAmount, 2) }}</td>
                                    <td>{{ number_format($balancePay, 2) }}</td>
                                @else
                                    <td>{{ number_format($receivedAmount, 2) }}</td>
                                    <td>{{ number_format($paidAmount, 2) }}</td>
                                    <td>{{ number_format($bothbalance, 2) }}</td>
                                @endif
                                @php
                                    $total_receivables = 0;
                                    $total_payables = 0;
                                @endphp
                                @if ($type == 1)
                                    <td>{{ $receivableDays !== null ? $receivableDays . ' days' : '---' }}</td>
                                @elseif ($type == 2)
                                    <td>{{ $payableDays !== null ? $payableDays . ' days' : '---' }}</td>
                                @endif
                            </tr>
                        @endif
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        @if ($type == 1)
                            <th colspan="7"> Total Containers:{{ $totalCount20 ?? 0 }} x 20, {{ $totalCount40 ?? 0 }} x
                                40,
                                {{ $totalCount45 ?? 0 }} x 45 </th>
                            <th colspan="7">Total </th>
                            <th>{{ number_format($totalReceivable, 2) }}</th>
                            <th>0.0</th>
                            <th>{{ number_format($totalReceived, 2) }}</th>
                            <th>{{ number_format($totalBalanceRec, 2) }}</th>
                        @elseif($type == 2)
                            <th colspan="7"> Total Containers:{{ $totalCount20 ?? 0 }} x 20, {{ $totalCount40 ?? 0 }} x
                                40,
                                {{ $totalCount45 ?? 0 }} x 45 </th>
                            <th colspan="7">Total </th>
                            <th>{{ number_format($totalPayable, 2) }}</th>
                            <th>0.0</th>
                            <th>{{ number_format($totalPaid, 2) }}</th>
                            <th>{{ number_format($totalBalancePay, 2) }}</th>
                        @else
                            <th colspan="4"> Total Containers:{{ $totalCount20 ?? 0 }} x 20, {{ $totalCount40 ?? 0 }} x
                                40,
                                {{ $totalCount45 ?? 0 }} x 45 </th>
                            <th colspan="4">Total </th>
                            <th>{{ number_format($totalReceivable, 2) }}</th>
                            <th>{{ number_format($totalPayable, 2) }}</th>
                            <th>0.0</th>
                            <th>{{ number_format($totalReceived, 2) }}</th>
                            <th>{{ number_format($totalPaid, 2) }}</th>
                            <th>{{ number_format($totalBalanceBoth, 2) }}</th>
                        @endif
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
    {{--
    </div> --}}
    <!-- jQuery (Required for DataTables) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>

    <script>
        $(document).ready(function() {
            // Initialize DataTable
            $('#jobBalancingReport').DataTable({
                dom: 'Bfrtip', // Include export buttons in the DOM
                buttons: [{
                    extend: 'excelHtml5',
                    text: 'Export to Excel',
                    title: 'Job Balancing Report',
                    exportOptions: {
                        columns: ':visible', // Export only visible columns
                        footer: true
                    }
                }],
                initComplete: function() {
                    // Show the table after DataTables initialization is complete
                    $('#jobBalancingReport').show();
                }
            });
        });
    </script>

@endsection
