@extends('layout.master')

@section('title')
    JOB-LIST-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Job List with Summary Report</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none;border-right: none; padding-bottom: 8px;border-top: none; margin-right: 70px; margin-bottom: 10px;">
            <!-- Added margin-bottom for gap -->
            <div class="text-center">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight:bold">YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10">Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.</h3>
                <p>Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <div class="table-responsive">
                <table class="table table-bordered mt-n2 display nowrap" id="jobBalancingReport">
                    <thead>
                        <tr>
                            <th>S#</th>
                            <th>Job #</th>
                            <th>HBL/HAWB</th>
                            <th>MBL/MAWB</th>
                            <th>Sales Rep</th>
                            <th>Client</th>
                            <th>Sailing/Arrival Date</th>
                            <th>Shipper / Consignee</th>
                            <th>Air / Shipping Line</th>
                            <th>Local Agent</th>
                            <th>Final Dest</th>
                            <th>Commodity</th>
                            <th>Cntrs</th>
                            <th>WT</th>
                            <th>Carrier Booking No</th>
                            <th>Vol</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($query as $index => $job)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ @$job->job_no }}</td>
                                <td>{{ @$job->bl_master->hbl_no }}</td>
                                <td>{{ @$job->bl_master->mbl_no }}</td>
                                <td>{{ @$job->job_detail->sales_rep->employee_name }}</td>
                                <td>{{ @$job->job_detail->client->name }}</td>
                                <td>{{ @$job->bl_master->sailing_date }}</td>
                                <td>{{ @$job->job_detail->shipper->name }} / {{ @$job->job_detail->consignee->name }}</td>
                                <td>{{ @$job->job_detail->shipping_line->name }}</td>
                                <td>{{ @$job->job_detail->local_vendor->name }}</td>
                                <td>{{ @$job->job_routing->final_destination->name }}</td>
                                <td>{{ @$job->job_detail->commodity->name }}</td>
                                <td>{{ @$job->job_weight->container }}</td>
                                <td>{{ @$job->job_weight->weight }}</td>
                                <td></td>
                                <td>{{ @$job->job_weight->vol }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    {{-- </div> --}}
    <!-- jQuery (Required for DataTables) -->
   

    <script>
        $(document).ready(function() {
            // Check if DataTable library is loaded
            if ($.fn.dataTable) {
                // Initialize the DataTable
                $('#jobBalancingReport').DataTable({
                    dom: 'Bfrtip', // Include export buttons in the DOM
                    buttons: [{
                            extend: 'excelHtml5',
                            text: 'Export to Excel',
                            title: 'Job List with Summary Report',
                            exportOptions: {
                                columns: ':visible' // Export only visible columns
                            }
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'Export to PDF',
                            title: 'Job List with Summary Report',
                            exportOptions: {
                                columns: ':visible' // Export only visible columns
                            },
                            orientation: 'landscape',
                            pageSize: 'A3',
                            // customize: function(doc) {
                            //     // Customize PDF output if needed
                            //     doc.content[1].margin = [0, 0, 0, 0]; // Adjust margins
                            //     doc.content[1].table.widths = '*'.repeat(doc.content[1].table.body[
                            //         0].length).split('');
                            // }
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            exportOptions: {
                                columns: ':visible',
                                stripHtml: false,
                                orthogonal: "myExport"
                            },
                            orientation: 'landscape',
                            paperSize: 'A2',
                        }
                    ],
                    initComplete: function() {
                        // Show the table after DataTables initialization is complete
                        $('#jobBalancingReport').show();
                    }
                });
            }
        });
    </script>
@endsection
