@extends('layout.master')

@section('title')
    JOB-PnL-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">
        Job PnL Report</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none;border-right: none; padding-bottom: 8px;border-top: none; margin-right: 70px; margin-bottom: 10px;">
            <!-- Added margin-bottom for gap -->
            <div class="text-center">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight:bold">YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10">Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.</h3>
                <p>Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            @if ($reportType == 1 || $reportType == 2)
                <table class="table table-bordered mt-n2 display nowrap" id="jobBalancingReport"
                    style="display: none; width:100%">
                @else
                    <table class="table table-bordered mt-n2 display nowrap">
            @endif
            <thead>
                @if ($reportType == 1)
                    <tr>
                        <th style="text-align: center;">S#</th>
                        <th style="text-align: center;">Job No</th>
                        <th style="text-align: center;">Job Date</th>
                        <th style="text-align: center;">HBL/HAWB</th>
                        <th style="text-align: center;">File #</th>
                        <th style="text-align: center;">Client</th>
                        <th style="text-align: center;">Shipper</th>
                        <th style="text-align: center;">Local Agent</th>
                        <th style="text-align: center;">Final Destination</th>
                        <th style="text-align: center;">Type</th>
                        <th style="text-align: center;">Cntrs</th>
                        <th style="text-align: center;">WT</th>
                        <th style="text-align: center;">Vol</th>
                        <th style="text-align: center;">Revenue</th>
                        <th style="text-align: center;">Cost</th>
                        <th style="text-align: center;">Profit / Loss</th>
                    </tr>
                @elseif($reportType == 2)
                    <tr>
                        <th rowspan="2" style="text-align: center;">S#</th>
                        <th rowspan="2" style="text-align: center;">Job No</th>
                        <th rowspan="2" style="text-align: center;">Job Date</th>
                        <th rowspan="2" style="text-align: center;">HBL/HAWB</th>
                        <th rowspan="2" style="text-align: center;">File #</th>
                        <th rowspan="2" style="text-align: center;">Client</th>
                        <th rowspan="2" style="text-align: center;">Shipper</th>
                        <th rowspan="2" style="text-align: center;">Local Agent</th>
                        <th rowspan="2" style="text-align: center;">Final Destination</th>
                        <th rowspan="2" style="text-align: center;">Type</th>
                        <th rowspan="2" style="text-align: center;">Cntrs</th>
                        <th rowspan="2" style="text-align: center;">WT</th>
                        <th rowspan="2" style="text-align: center;">Vol</th>
                        <th colspan="2" style="text-align: center;">Revenue</th>
                        <th colspan="2" style="text-align: center;">Cost</th>
                        <th rowspan="2" style="text-align: center;">Profit / Loss</th>
                    </tr>
                    <tr>
                        <th style="text-align: center;">Realized</th>
                        <th style="text-align: center;">Unrealized</th>
                        <th style="text-align: center;">Realized</th>
                        <th style="text-align: center;">Unrealized</th>
                    </tr>
                @elseif($reportType == 3 || $reportType == 4)
                    <tr>
                        <th rowspan="{{ $reportType == 4 ? 3 : 2 }}" style="text-align: center;">S#</th>
                        <th rowspan="{{ $reportType == 4 ? 3 : 2 }}" style="text-align: center;">Charges</th>
                        <th rowspan="{{ $reportType == 4 ? 3 : 2 }}" style="text-align: center;">Invoice Of</th>
                        <th rowspan="{{ $reportType == 4 ? 3 : 2 }}" style="text-align: center;">Source</th>
                        <th rowspan="{{ $reportType == 4 ? 3 : 2 }}" style="text-align: center;">Source/Doc No</th>
                        <th rowspan="{{ $reportType == 4 ? 3 : 2 }}" style="text-align: center;">Curr</th>
                        <th rowspan="{{ $reportType == 4 ? 3 : 2 }}" style="text-align: center;">Amount</th>
                        <th rowspan="{{ $reportType == 4 ? 3 : 2 }}" style="text-align: center;">Ex. Rate</th>
                        <th colspan="{{ $reportType == 4 ? 5 : 3 }}" style="text-align: center;">Local Amount</th>
                    </tr>
                    <tr>
                        <th colspan="{{ $reportType == 4 ? 2 : 1 }}" style="text-align: center;">Revenue</th>
                        <th colspan="{{ $reportType == 4 ? 2 : 1 }}" style="text-align: center;">Cost</th>
                        <th rowspan="{{ $reportType == 4 ? 2 : 1 }}" style="text-align: center;">Profit/Loss</th>
                    </tr>
                    @if ($reportType == 4)
                        <tr>
                            <th style="text-align: center;">Realized</th>
                            <th style="text-align: center;">Unrealized</th>
                            <th style="text-align: center;">Realized</th>
                            <th style="text-align: center;">Unrealized</th>
                        </tr>
                    @endif
                @endif
            </thead>
            <tbody>
                @if ($reportType == 1 || $reportType == 2)
                    @php
                        $totalWT = 0;
                        $totalVol = 0;
                        $totalRev = 0;
                        $totalCost = 0;
                        $totalProfit = 0;
                        $RealizedRevenue = 0;
                        $UnrealizedRevenue = 0;
                        $RealizedCost = 0;
                        $UnrealizedCost = 0;
                    @endphp
                    @foreach ($query as $index => $job)
                        @php
                            $totalRec = $job->principal_receivable ?? 0;
                            $totalPay = $job->principal_payable ?? 0;
                            $profitLoss = $totalRec - $totalPay;

                            // Convert to absolute value to avoid negative signs
                            $formattedProfitLoss = number_format($profitLoss, 2);
                            $totalRealizedRevenue = 0;
                            $totalUnrealizedRevenue = 0;
                            $totalRealizedCost = 0;
                            $totalUnrealizedCost = 0;
                        @endphp

                        @foreach ($job->job_charges_receivable->concat($job->job_charges_payable) as $index => $item)
                            @php
                                $isReceivable = $job->job_charges_receivable->contains($item);
                                $net_amount = $isReceivable ? (int) $item->net_amount : '-' . (int) $item->net_amount;
                                $totalRealizedRevenue += $isReceivable ? (int) $item->net_amount : 0;
                                $totalUnrealizedRevenue += $isReceivable ? 0 : (int) $item->net_amount;
                                $totalRealizedCost += $isReceivable ? 0 : (int) $item->net_amount;
                                $totalUnrealizedCost += $isReceivable ? (int) $item->net_amount : 0;
                            @endphp
                        @endforeach

                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ @$job->job_no }}</td>
                            <td>{{ @$job->job_date }}</td>
                            <td>{{ @$job->bl_master->hbl_no }}</td>
                            <td>{{ @$job->file_no }}</td>
                            <td>{{ @$job->job_detail->client->name }}</td>
                            <td>{{ @$job->job_detail->shipper->name }}</td>
                            <td>{{ @$job->job_detail->local_vendor->name }}</td>
                            <td>{{ @$job->job_routing->final_destination->name }}</td>
                            <td>{{ @$job->job_type }}</td>
                            <td>{{ @$job->job_weight->container }}</td>
                            <td>{{ @$job->job_weight->weight }}</td>
                            <td>{{ @$job->job_weight->vol }}</td>
                            @if ($reportType == 1)
                                <td>{{ number_format(@$job->principal_receivable, 2) }}</td>
                                <td>{{number_format(@$job->principal_payable, 2) }}</td>
                            @elseif($reportType == 2)
                                <td> {{ $totalRealizedRevenue }} </td>
                                <td> {{ $totalUnrealizedRevenue }} </td>
                                <td> {{ $totalRealizedCost }} </td>
                                <td> {{ $totalUnrealizedCost }} </td>
                            @endif
                            <td>{{ $formattedProfitLoss }}</td>
                            @php
                                // Ensure values are numeric by using floatval() or setting default values
                                $totalWT += floatval(@$job->job_weight->weight ?? 0);
                                $totalVol += floatval(@$job->job_weight->vol ?? 0);
                                $totalRev += floatval(@$job->principal_receivable ?? 0);
                                $totalCost += floatval(@$job->principal_payable ?? 0);
                                $totalProfit += floatval($formattedProfitLoss ?? 0); // Use $profitLoss here as $formattedProfitLoss is a string with 'DR'/'CR'
                                $RealizedRevenue += floatval($totalRealizedRevenue ?? 0);
                                $UnrealizedRevenue += floatval($totalUnrealizedRevenue ?? 0);
                                $RealizedCost += floatval($totalRealizedCost ?? 0);
                                $UnrealizedCost += floatval($totalUnrealizedCost ?? 0);
                            @endphp

                        </tr>
                    @endforeach
                @elseif($reportType == 3 || $reportType == 4)
                    @php
                        $totalRevTypeThree = 0;
                        $totalCostTypeThree = 0;
                        $totalProfitTypeThree = 0;
                    @endphp
                    @foreach ($query as $index => $job)
                        @if ($job->job_charges_receivable->isNotEmpty() || $job->job_charges_payable->isNotEmpty())
                            <tr>
                                <th> Job #:{{ @$job->job_no }} </th>
                                <th> Job Date: {{ @$job->job_date }} </th>
                                <th> Operation Type: {{ @$job->operation->name }} </th>
                                <th colspan="3">HBL/MBL: {{ @$job->bl_master->hbl_no }} /
                                    {{ @$job->bl_master->mbl_no }} </th>
                                <th colspan="2">Client: {{ @$job->job_detail->client->name }}</th>
                                <th colspan="{{ $reportType == 4 ? 4 : 2 }}">Dest/Load Port
                                    :{{ @$job->job_routing->final_destination->name }}
                                </th>
                                <th>Type: {{ @$job->job_type }}</th>
                            </tr>
                        @endif
                        @foreach ($job->job_charges_receivable as $j => $job_receivable)
                            <tr>
                                <td>{{ $j + 1 }}</td>
                                <td>{{ @$job_receivable->charge->name }}</td>
                                <td>{{ @$job_receivable->customer->name }}</td>
                                <td>REG</td>
                                <td>Job Invoice</td>
                                @if (@$job_receivable->currency == 1)
                                    <td>PKR</td>
                                @elseif(@$job_receivable->currency == 2)
                                    <td>USD</td>
                                @elseif(@$job_receivable->currency == 3)
                                    <td>AED</td>
                                @elseif(@$job_receivable->currency == 4)
                                    <td>BDT</td>
                                @elseif(@$job_receivable->currency == 5)
                                    <td>OMR</td>
                                @elseif(@$job_receivable->currency == 6)
                                    <td>EUR</td>
                                @elseif(@$job_receivable->currency == 7)
                                    <td>GBP</td>
                                @endif
                                <td>{{ number_format(@$job_receivable->net_amount, 2) }}</td>
                                <td>{{ number_format(@$job_receivable->ex_rate, 2) }}</td>
                                <td>{{ number_format(@$job_receivable->local_amount, 2) }}</td>
                                @if ($reportType == 4)
                                    <td> 0.00 </td>
                                    <td> 0.00 </td>
                                @endif
                                <td> 0.00 </td>
                                <td> {{ number_format(@$job_receivable->local_amount, 2) }} </td>
                                @php
                                    // Ensure values are numeric by using floatval() or setting default values
                                    $totalRevTypeThree += floatval($job_receivable->local_amount ?? 0);
                                @endphp
                            </tr>
                        @endforeach
                        @foreach ($job->job_charges_payable as $j => $job_payable)
                            <tr>
                                <td>{{ $j + 1 }}</td>
                                <td>{{ @$job_payable->charge->name }}</td>
                                <td>{{ @$job_payable->vendor->name }}</td>
                                <td>JB</td>
                                <td>Job Bill</td>
                                @if (@$job_payable->currency == 1)
                                    <td>PKR</td>
                                @elseif(@$job_payable->currency == 2)
                                    <td>USD</td>
                                @elseif(@$job_payable->currency == 3)
                                    <td>AED</td>
                                @elseif(@$job_payable->currency == 4)
                                    <td>BDT</td>
                                @elseif(@$job_payable->currency == 5)
                                    <td>OMR</td>
                                @elseif(@$job_payable->currency == 6)
                                    <td>EUR</td>
                                @elseif(@$job_payable->currency == 7)
                                    <td>GBP</td>
                                @endif
                                <td> {{ number_format(@$job_payable->net_amount, 2) }} </td>
                                <td> {{ number_format(@$job_payable->ex_rate, 2) }} </td>
                                <td> 0.00 </td>
                                @if ($reportType == 4)
                                    <td> 0.00 </td>
                                @endif
                                <td> {{ number_format(@$job_payable->local_amount, 2) }} </td>
                                @if ($reportType == 4)
                                    <td> 0.00 </td>
                                @endif
                                <td> {{ number_format(@$job_payable->local_amount, 2) }} </td>
                                @php
                                    // Ensure values are numeric by using floatval() or setting default values
                                    $totalCostTypeThree += floatval($job_payable->local_amount ?? 0);
                                @endphp
                            </tr>
                        @endforeach
                    @endforeach
                @endif
            </tbody>
            <tfoot>
                <tr>
                    @if ($reportType == 1 || $reportType == 2)
                        <th colspan="11">TOTAL</th>
                        <th> {{ $totalWT }} </th>
                        <th> {{ $totalVol }} </th>
                    @endif
                    @if ($reportType == 1)
                        <th> {{ $totalRev }} </th>
                        <th> {{ $totalCost }} </th>
                        @php
                            $totalProfit = $totalRev - $totalCost;
                            $formattedTotalProfitLoss = number_format($totalProfit, 2);
                        @endphp
                        <th> {{ $formattedTotalProfitLoss }} </th>
                    @elseif($reportType == 2)
                        <th> {{ $RealizedRevenue }} </th>
                        <th> {{ $UnrealizedRevenue }} </th>
                        <th> {{ $RealizedCost }} </th>
                        <th> {{ $UnrealizedCost }} </th>
                        @php
                            $totalRev = $RealizedRevenue + $UnrealizedRevenue;
                            $totalCost = $RealizedCost + $UnrealizedCost;
                            $totalProfit = $totalRev - $totalCost;
                            $formattedTotalProfitLoss = number_format($totalProfit, 2);
                        @endphp
                        <th> {{ $formattedTotalProfitLoss }} </th>
                    @elseif($reportType == 3 || $reportType == 4)
                        <th colspan="8">TOTAL</th>
                        <th> {{ number_format($totalRevTypeThree, 2) }} </th>
                        @if ($reportType == 4)
                            <th>0.00</th>
                        @endif
                        <th> {{ number_format($totalCostTypeThree, 2) }} </th>
                        @if ($reportType == 4)
                            <th>0.00</th>
                        @endif
                        @php
                            $totalProfitTypeThree = $totalRevTypeThree - $totalCostTypeThree;
                            $formattedtotalProfitTypeThree = number_format($totalProfitTypeThree, 2);
                        @endphp
                        <th> {{ $formattedtotalProfitTypeThree }} </th>
                    @endif
                </tr>
            </tfoot>
            </table>
        </div>
    </div>
    {{-- </div> --}}
    <!-- jQuery (Required for DataTables) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>

    <script>
        $(document).ready(function() {
            // Check if DataTable library is loaded
            if ($.fn.dataTable) {
                // Initialize the DataTable
                $('#jobBalancingReport').DataTable({
                    dom: 'Bfrtip', // Include export buttons in the DOM
                    buttons: [{
                            extend: 'excelHtml5',
                            text: 'Export to Excel',
                            title: 'Job PnL Report',
                            exportOptions: {
                                columns: ':visible' // Export only visible columns
                            }
                        },
                        // {
                        //     extend: 'pdfHtml5',
                        //     text: 'Export to PDF',
                        //     title: 'Job Balancing Report',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     },
                        //     customize: function(doc) {
                        //         // Customize PDF output if needed
                        //         doc.content[1].margin = [0, 0, 0, 0]; // Adjust margins
                        //         doc.content[1].table.widths = '*'.repeat(doc.content[1].table.body[
                        //             0].length).split('');
                        //     }
                        // },
                        // {
                        //     extend: 'print',
                        //     text: 'Print Table',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     }
                        // }
                    ],
                    initComplete: function() {
                        // Show the table after DataTables initialization is complete
                        $('#jobBalancingReport').show();
                    }
                });
            }
        });
    </script>
@endsection
