@extends('layout.master')

@section('title')
    LOADING-LIST-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Loading List</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none;border-right: none; padding-bottom: 8px;border-top: none; margin-right: 70px; margin-bottom: 10px;">
            <!-- Added margin-bottom for gap -->
            <div class="text-center">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight:bold">YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10">Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.</h3>
                <p>Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2 display nowrap">
                {{-- id="jobBalancingReport" style="display: none; width:100%"> --}}
                <thead>
                    <tr>
                        <th>S.no</th>
                        @if (($report_type == 2 && $group_on == 1) || ($report_type == 2 && $group_on == 2))
                            <th>Job No</th>
                        @endif
                        @if (($report_type == 1 && $group_on == 1) || ($report_type == 2 && $group_on == 2))
                            <th>Vessel</th>
                        @elseif (($report_type == 1 && $group_on == 2) || ($report_type == 2 && $group_on == 1))
                            <th>Shipping Line</th>
                        @endif
                        <th>Agent</th>
                        @if (($report_type == 2 && $group_on == 1) || ($report_type == 2 && $group_on == 2))
                            <th>Final Destination</th>
                        @endif
                        <th>Container #</th>
                        <th>Seal</th>
                        <th>Size/Type</th>
                        @if (($report_type == 2 && $group_on == 1) || ($report_type == 2 && $group_on == 2))
                            <th>Gross Weight</th>
                            <th>Net Weight</th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                    @php
                        $grandTotal20 = 0;
                        $grandTotal40 = 0;
                        $grandTotalGross = 0;
                        $grandTotalNet = 0;
                    @endphp
                    @foreach ($query as $i => $groupItems)
                        @php
                            $total20 = 0;
                            $total40 = 0;
                            $totalNet = 0;
                            $totalGross = 0;
                        @endphp
                        @if (($report_type == 1 && $group_on == 1) || ($report_type == 2 && $group_on == 1))
                            <tr>
                                <td colspan="{{ $report_type == 1 ? 6 : 10 }}" class="text-center">Vessel:
                                    {{ optional($groupItems->first()->vessel)->name ?? 'N/A' }}</td>
                            </tr>
                        @elseif ($report_type == 1 && $group_on == 2)
                            || ($report_type == 2 && $group_on == 2)
                            <tr>
                                <td colspan="{{ $report_type == 1 ? 6 : 10 }}" class="text-center">Line :
                                    {{ optional(optional($groupItems->first())->bl_booking_info->shipping_line)->name ?? 'N/A' }}
                                </td>
                            </tr>
                        @endif
                        @foreach ($groupItems as $j => $bl_master)
                            @if ($bl_master->bl_container_info->isNotEmpty())
                                @foreach ($bl_master->bl_container_info as $k => $detail)
                                    <tr>
                                        <td>{{ (int) $k + 1 }}</td>
                                        @if (($report_type == 2 && $group_on == 1) || ($report_type == 2 && $group_on == 2))
                                            <td>{{ @$bl_master->job_master->job_no }}</td>
                                        @endif
                                        @if (($report_type == 1 && $group_on == 1) || ($report_type == 2 && $group_on == 2))
                                            <td>{{ @$bl_master->vessel->name }}</td>
                                        @elseif (($report_type == 1 && $group_on == 2) || ($report_type == 2 && $group_on == 1))
                                            <td>{{ @$bl_master->bl_booking_info->shipping_line->name }}</td>
                                        @endif
                                        <td>{{ @$bl_master->bl_booking_info->overseas_agent->name }}</td>
                                        @if (($report_type == 2 && $group_on == 1) || ($report_type == 2 && $group_on == 2))
                                            <td>{{ @$bl_master->bl_booking_info->final_destination->name }}</td>
                                        @endif
                                        <td>{{ @$detail->container_no }}</td>
                                        <td>{{ @$detail->container_seal_no }}</td>
                                        <td>{{ $detail->container_size_type && $detail->container_size_type !== 'Please Select' ? $detail->container_size_type : '' }}
                                        </td>
                                        @if (($report_type == 2 && $group_on == 1) || ($report_type == 2 && $group_on == 2))
                                            <td>{{ $bl_master->bl_detail->gross_wt }}</td>
                                            <td>{{ $bl_master->bl_detail->net_wt }}</td>
                                        @endif
                                    </tr>
                                    @php
                                        $totalGross += floatval(str_replace(',', '', $bl_master->bl_detail->gross_wt));
                                        $totalNet += floatval(str_replace(',', '', $bl_master->bl_detail->net_wt));
                                        if (
                                            $detail->container_size_type &&
                                            $detail->container_size_type !== 'Please Select' &&
                                            $detail->container_size_type !== 'M3'
                                        ) {
                                            // Check if the first two letters are '20'
                                            if (substr($detail->container_size_type, 0, 2) === '20') {
                                                $total20++; // Increment total20
                                            } else {
                                                $total40++; // Increment total40
                                            }
                                        }
                                    @endphp
                                @endforeach
                            @else
                                <tr>
                                    <td>{{ (int) $j + 1 }}</td>
                                    @if (($report_type == 2 && $group_on == 1) || ($report_type == 2 && $group_on == 2))
                                        <td>{{ @$bl_master->job_master->job_no }}</td>
                                    @endif
                                    @if (($report_type == 1 && $group_on == 1) || ($report_type == 2 && $group_on == 2))
                                        <td>{{ @$bl_master->vessel->name }}</td>
                                    @elseif (($report_type == 1 && $group_on == 2) || ($report_type == 2 && $group_on == 1))
                                        <td>{{ @$bl_master->bl_booking_info->shipping_line->name }}</td>
                                    @endif
                                    <td>{{ @$bl_master->bl_booking_info->overseas_agent->name }}</td>
                                    @if (($report_type == 2 && $group_on == 1) || ($report_type == 2 && $group_on == 2))
                                        <td>{{ @$bl_master->bl_booking_info->final_destination->name }}</td>
                                    @endif
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    @if (($report_type == 2 && $group_on == 1) || ($report_type == 2 && $group_on == 2))
                                        <td>{{ $bl_master->bl_detail->gross_wt }}</td>
                                        <td>{{ $bl_master->bl_detail->net_wt }}</td>
                                    @endif
                                </tr>
                                @php
                                    $totalGross += floatval($bl_master->bl_detail->gross_wt);
                                    $totalNet += floatval($bl_master->bl_detail->net_wt);
                                @endphp
                            @endif
                        @endforeach
                        @if (($report_type == 1 && $group_on == 1) || ($report_type == 1 && $group_on == 2))
                            <tr>
                                <th rowspan="2">Total</th>
                                <th>20</th>
                                <th colspan="4">40</th>
                            </tr>
                            <tr>
                                <th>{{ $total20 }}</th>
                                <th colspan="4">{{ $total40 }}</th>
                            </tr>
                            @php
                                $grandTotal20 += $total20;
                                $grandTotal40 += $total40;
                            @endphp
                        @elseif (($report_type == 2 && $group_on == 1) || ($report_type == 2 && $group_on == 2))
                            <tr>
                                <th colspan="8" class="text">Total</th>
                                <th>{{ $totalGross }}</th>
                                <th>{{ $totalNet }}</th>
                            </tr>
                            @php
                                $grandTotalGross += $totalGross;
                                $grandTotalNet += $totalNet;
                                $grandTotal20 += $total20;
                                $grandTotal40 += $total40;
                            @endphp
                        @endif
                    @endforeach
                    @if (($report_type == 1 && $group_on == 1) || ($report_type == 1 && $group_on == 2))
                        <tr>
                            <th colspan="6">{{ 'Grand Total ' . $grandTotal20 . ' x 20 ' . $grandTotal40 . ' x 40' }}
                            </th>
                        </tr>
                    @elseif (($report_type == 2 && $group_on == 1) || ($report_type == 2 && $group_on == 2))
                        <tr>
                            <th colspan="7">{{ 'Grand Total ' . $grandTotal20 . ' x 20 ' . $grandTotal40 . ' x 40' }}
                            </th>
                            <th>Grand Total</th>
                            <th>{{ $grandTotalGross }}</th>
                            <th>{{ $grandTotalNet }}</th>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
        {{-- end Pagination --}}
    </div>
    <!-- jQuery (Required for DataTables) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>

    <script>
        $(document).ready(function() {
            // Check if DataTable library is loaded
            if ($.fn.dataTable) {
                // Initialize the DataTable
                $('#jobBalancingReport').DataTable({
                    dom: 'Bfrtip', // Include export buttons in the DOM
                    buttons: [{
                            extend: 'excelHtml5',
                            text: 'Export to Excel',
                            title: 'Loading List',
                            exportOptions: {
                                columns: ':visible' // Export only visible columns
                            }
                        },
                        // {
                        //     extend: 'pdfHtml5',
                        //     text: 'Export to PDF',
                        //     title: 'Party Statement Of Account',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     },
                        //     customize: function(doc) {
                        //         // Customize PDF output if needed
                        //         doc.content[1].margin = [0, 0, 0, 0]; // Adjust margins
                        //         doc.content[1].table.widths = '*'.repeat(doc.content[1].table.body[
                        //             0].length).split('');
                        //     }
                        // },
                        // {
                        //     extend: 'print',
                        //     text: 'Print Table',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     }
                        // }
                    ],
                    initComplete: function() {
                        // Show the table after DataTables initialization is complete
                        $('#jobBalancingReport').show();
                    }
                });
            }
        });
    </script>
@endsection
