@extends('layout.master')

@section('title')
    PARTY-AUDIT-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Party Audit</a>
@endsection

@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="GET" id="myForm" action="{{ url('/report/show_party_audit') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Party Audit
                        </h2>

                        <button type="submit" class="btn btn-primary">Report</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>



                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                {{-- <div class="col-md-4 mt-2">
                                <label>Date Type</label>
                                <select data-placeholder="Select Date Type" id="date_type"
                                    name="date_type" class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    <option value="1" {{  request('date_type') == 1 ? 'selected' : '' }}>Job Date</option>
                                    <option value="2" {{  request('date_type') == 2 ? 'selected' : '' }}>Sailing/Arrival Date</option>
                                </select>
                            </div> --}}
                                <div class="col-md-4 mt-2">
                                    <label for="regular-form-1" class="form-label">Date From</label>
                                    <input id="date_from" type="date" class="form-control" placeholder="Enter Date From"
                                        name="date_from" value="{{ request('date_from', $date_from) }}">
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="regular-form-1" class="form-label">Date Till</label>
                                    <input id="date_till" type="date" class="form-control" name="date_till"
                                        value="{{ request('date_till', $date_to) }}">
                                </div>
                                <hr class="col-md-12 my-4">
                                <div class="col-md-3 mt-2">
                                    <label>Company</label>
                                    <select data-placeholder="Select Company" id="company" name="company"
                                        class="tom-select w-full mt-2">
                                        <option value="1" {{ request('company') == 1 ? 'selected' : '' }}>YARAN
                                            SHIPPING LINE</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Client</label>
                                    <select id="client_id" name="client_id" class="form-select w-full mt-2" disabled>
                                        <option value=""></option>
                                        @foreach ($clients as $item)
                                            <option {{ request('client_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Vendor</label>
                                    <select id="vendor_id" name="vendor_id" class="form-select w-full mt-2" disabled>
                                        <option value=""></option>
                                        @foreach ($vendors as $item)
                                            <option {{ request('vendor_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Overseas Agent</label>
                                    <select id="overseas_agent_id" name="overseas_agent_id" class="form-select w-full mt-2"
                                        disabled>
                                        <option value=""></option>
                                        @foreach ($overseas_agent as $item)
                                            <option {{ request('overseas_agent_id') == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                {{-- <div class="col-md-3 mt-2">
                                <label>Currency</label>
                                <select id="currency_id" name="currency_id"
                                    class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    @foreach ($currencies as $item)
                                        <option
                                            {{  request('currency_id') == $item->id ? 'selected' : '' }}
                                            value="{{ $item->id }}">{{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div> --}}
                                <div class="col-md-3 mt-2">
                                    <label>Cost Center</label>
                                    <select data-placeholder="Select Cost Center" id="cost_center" name="cost_center"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        <option {{ request('cost_center') == 'Head Office' ? 'selected' : '' }}
                                            value="Head Office">Head Office</option>
                                    </select>
                                </div>
                                <hr class="col-md-12 my-4">
                                <div class="col-md-6 mt-2">
                                    <label>Report For</label>
                                    <select data-placeholder="Select Report For" id="report_for" name="report_for"
                                        class="tom-select w-full mt-2">
                                        <option value="1" {{ request('report_for') == '1' ? 'selected' : '' }}>All
                                        </option>
                                        <option value="2" {{ request('report_for') == '2' ? 'selected' : '' }}>Client
                                        </option>
                                        <option value="3" {{ request('report_for') == '3' ? 'selected' : '' }}>Vendor
                                        </option>
                                        <option value="4" {{ request('report_for') == '4' ? 'selected' : '' }}>
                                            Overseas Agent</option>
                                    </select>
                                </div>
                                {{-- <div class="col-md-3 mt-2">
                                <label>Job Status</label>
                                <select data-placeholder="Select Job Status" id="job_status_id"
                                    name="job_status_id" class="tom-select w-full mt-2">
                                    <option value=""></option>
                                    @foreach ($job_status as $item)
                                    <option value="{{ $item->id }}" {{  request('job_status_id') == $item->id ? 'selected' : '' }}>{{ $item->name }}</option>
                                @endforeach
                                </select>
                            </div> --}}
                                <div class="col-md-6 mt-2">
                                    <label>Report Type</label>
                                    <select data-placeholder="Select Report Type" id="report_type" name="report_type"
                                        class="tom-select w-full mt-2">
                                        <option value="1" {{ request('report_type') == '1' ? 'selected' : '' }}>Detail
                                            Report</option>
                                        <option value="2" {{ request('report_type') == '2' ? 'selected' : '' }}
                                            selected>Summary Report</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const reportFor = document.getElementById("report_for");
            const clientId = document.getElementById("client_id");
            const vendorId = document.getElementById("vendor_id");
            const overseasAgentId = document.getElementById("overseas_agent_id");

            // Function to reset and disable all fields
            function resetFields() {
                clientId.value = '';
                vendorId.value = '';
                overseasAgentId.value = '';
                clientId.disabled = true;
                vendorId.disabled = true;
                overseasAgentId.disabled = true;
            }

            // Initialize fields based on initial selection
            resetFields();

            // Event listener for the report_for change
            reportFor.addEventListener("change", function() {
                resetFields(); // Disable all fields and clear values

                // Enable only the relevant field based on report_for selection
                if (this.value === "2") {
                    clientId.disabled = false; // Enable Client field
                } else if (this.value === "3") {
                    vendorId.disabled = false; // Enable Vendor field
                } else if (this.value === "4") {
                    overseasAgentId.disabled = false; // Enable Overseas Agent field
                }
            });
        });
    </script>
@endsection
