@extends('layout.master')

@section('title')
    PARTY-STATEMENT-OF-ACCOUNT-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Party Statement Of Account</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none;border-right: none; padding-bottom: 8px;border-top: none; margin-right: 70px; margin-bottom: 10px;">
            <!-- Added margin-bottom for gap -->
            <div class="text-center">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight:bold">YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10">Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.</h3>
                <p>Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            @if ($groupOn == 1)
            <table class="table table-bordered mt-n2 display nowrap" id="jobBalancingReport"
                style="display: none; width:100%">
            @else
                <table class="table table-bordered mt-n2 display nowrap">
            @endif
            <thead>
                <tr>
                    <th>S#</th>
                    <th>Trans Type</th>
                    @if ($groupOn == 1)
                        <th>Party</th>
                        {{-- <th>Party Type</th> --}}
                    @endif
                    {{-- <th>Doc # / Doc Date</th>
                    <th>Booking No</th> --}}
                    <th>HBL/HAWB / MBL #</th>
                    <th>ETA / ETD</th>
                    <th>Job # / Job Date</th>
                    <th>Voucher #</th>
                    <th>Debit</th>
                    <th>Credit</th>
                    <th>Balance</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $totaldebit = 0;
                    $totalcredit = 0;
                @endphp

                @if ($groupOn == 1)
                    @foreach ($query as $j => $transaction)
                        @php
                            $jobMasterId = '';
                            $jobDate = '';
                            $eta = '';
                            $etd = '';
                            $hbl_no = '';
                            $mbl_no = '';
                        @endphp
                        @foreach ($job_charges_receivables as $receivable)
                            {{-- @if ($receivable->bill_invoice == $transaction->voucher_no) --}}
                            @if (substr($receivable->bill_invoice, 3) == substr($transaction->voucher_no, 3))

                                @php
                                    $jobMasterId = $receivable->job_master_id;
                                    $jobDate = $receivable->job_master?->job_date ?? '';
                                    $eta = $receivable->job_master?->job_vessel?->eta ?? '';
                                    $etd = $receivable->job_master?->job_vessel?->etd ?? '';
                                    $hbl_no = $receivable->job_master?->bl_master?->hbl_no ?? '';
                                    $mbl_no = $receivable->job_master?->bl_master?->mbl_no ?? '';
                                    break;
                                @endphp
                            @endif
                        @endforeach

                        @if ($jobMasterId == '-')
                            @foreach ($job_charges_payables as $payable)
                                {{-- @if ($payable->bill_invoice == $transaction->voucher_no) --}}
                                @if (substr($payable->bill_invoice, 3) == substr($transaction->voucher_no, 3))

                                    @php
                                        $jobMasterId = $payable->job_master_id;
                                        $jobDate = $payable->job_master->job_date ?? '';
                                        $eta = $payable->job_master->job_vessel->eta ?? '';
                                        $etd = $payable->job_master->job_vessel->etd ?? '';
                                        $hbl_no = $payable->job_master->bl_master->hbl_no ?? '';
                                        $mbl_no = $payable->job_master->bl_master->mbl_no ?? '';
                                        break;
                                    @endphp
                                @endif
                            @endforeach
                        @endif

                        <tr>
                            <td>{{ (int) $j + 1 }}</td>
                            <td>{{ @$transaction->type->name }}</td>
                            {{-- <td>{{ @$transaction->party->name }}</td> --}}
                            <td>{{ @$transaction->chart_of_accounts->party->name }}</td>
                            {{-- <td></td> --}}
                            {{-- <td>{{ @$transaction->party->party_type->name }}</td> --}}
                            {{-- <td></td>
                            <td></td> --}}
                            <td>
                                {{ $hbl_no }} <br> {{ $mbl_no }}
                            </td>
                            <td>
                                {{ $eta }} <br> {{ $etd }}
                            </td>
                            <td>
                                {{ $jobMasterId }} <br> {{ $jobDate }}
                            </td>
                            <td>{{ @$transaction->voucher_no }}</td>
                            <td>{{ @$transaction->total_debit }}</td>
                            <td>{{ @$transaction->total_credit }}</td>
                            <td>{{ @$transaction->net_amount ?? 0 }}</td>
                            @php
                                $totaldebit += (float) str_replace(',', '', @$transaction->total_debit);
                                $totalcredit += (float) str_replace(',', '', @$transaction->total_credit);
                            @endphp
                        </tr>
                    @endforeach
                @else
                    @foreach ($query as $i => $groupItems)
                        <tr>
                            @if ($groupOn == 2)
                                <td colspan="18">Client: {{ $groupItems->first()->chart_of_accounts->party->name ?? 'N/A' }}</td>
                                {{-- @dd($groupItems) --}}
                                {{-- <td colspan="18">Overseas Agent: {{ @$groupItems->first()->overseas_agent->name }}</td> --}}
                                </td>
                            @elseif($groupOn == 3)
                                <td colspan="18">Vendor: {{ $groupItems->first()->chart_of_accounts->party->name ?? 'N/A' }}
                                @elseif($groupOn == 4)
                                <td colspan="18">Overseas Agent: {{ $groupItems->first()->chart_of_accounts->party->name ?? 'N/A' }}
                                </td>

                                {{-- <td colspan="18">Client: {{ $groupItems->first()->client->name }}</td> --}}
                            @endif
                        </tr>
                        @foreach ($groupItems as $j => $transaction)
                            @php
                                $jobMasterId = '';
                                $jobDate = '';
                                $eta = '';
                                $etd = '';
                                $hbl_no = '';
                                $mbl_no = '';
                            @endphp
                            @foreach ($job_charges_receivables as $receivable)
                                {{-- @if ($receivable->bill_invoice == $transaction->voucher_no) --}}
                                @if (substr($receivable->bill_invoice, 3) == substr($transaction->voucher_no, 3))

                                    @php
                                        $jobMasterId = $receivable->job_master_id;
                                        $jobDate = $receivable->job_master?->job_date ?? '';
                                        $eta = $receivable->job_master?->job_vessel?->eta ?? '';
                                        $etd = $receivable->job_master?->job_vessel?->etd ?? '';
                                        $hbl_no = $receivable->job_master?->bl_master?->hbl_no ?? '';
                                        $mbl_no = $receivable->job_master?->bl_master?->mbl_no ?? '';
                                        break;
                                    @endphp
                                @endif
                            @endforeach

                            @if ($jobMasterId == '-')
                                @foreach ($job_charges_payables as $payable)
                                    {{-- @if ($payable->bill_invoice == $transaction->voucher_no) --}}
                                    @if (substr($payable->bill_invoice, 3) == substr($transaction->voucher_no, 3))

                                        @php
                                            $jobMasterId = $payable->job_master_id;
                                            $jobDate = $payable->job_master->job_date ?? '';
                                            $eta = $payable->job_master->job_vessel->eta ?? '';
                                            $etd = $payable->job_master->job_vessel->etd ?? '';
                                            $hbl_no = $payable->job_master->bl_master->hbl_no ?? '';
                                            $mbl_no = $payable->job_master->bl_master->mbl_no ?? '';
                                            break;
                                        @endphp
                                    @endif
                                @endforeach
                            @endif
                            <tr>
                                <td>{{ (int) $j + 1 }}</td>
                                <td>{{ @$transaction->type->name }}</td>
                                {{-- <td></td>
                                <td></td> --}}
                                <td>
                                    {{ $hbl_no }} <br> {{ $mbl_no }}
                                </td>
                                <td>
                                    {{ $eta }} <br> {{ $etd }}
                                </td>
                                <td>
                                    {{ $jobMasterId }} <br> {{ $jobDate }}
                                </td>
                                <td>{{ @$transaction->voucher_no }}</td>
                                <td>{{ @$transaction->total_debit }}</td>
                                <td>{{ @$transaction->total_credit }}</td>
                                <td>{{ @$transaction->net_amount ?? 0 }}</td>
                                @php
                                    $totaldebit += (float) str_replace(',', '', @$transaction->total_debit);
                                    $totalcredit += (float) str_replace(',', '', @$transaction->total_credit);
                                @endphp
                            </tr>
                        @endforeach
                    @endforeach
                @endif
            </tbody>
            <tfoot>
                <tr>
                    @if ($groupOn == 1)
                        <th colspan="7">Total</th>
                    @else
                        <th colspan="6">Total</th>
                    @endif
                    <th>{{ $totaldebit }}</th>
                    <th colspan="2">{{ $totalcredit }}</th>
                </tr>
            </tfoot>
            </table>
        </div>
        {{-- end Pagination --}}
    </div>
    <!-- jQuery (Required for DataTables) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>

    <script>
        $(document).ready(function() {
            // Check if DataTable library is loaded
            if ($.fn.dataTable) {
                // Initialize the DataTable
                $('#jobBalancingReport').DataTable({
                    dom: 'Bfrtip', // Include export buttons in the DOM
                    buttons: [{
                            extend: 'excelHtml5',
                            text: 'Export to Excel',
                            title: 'Party Statement Of Account',
                            exportOptions: {
                                columns: ':visible' // Export only visible columns
                            }
                        },
                        // {
                        //     extend: 'pdfHtml5',
                        //     text: 'Export to PDF',
                        //     title: 'Party Statement Of Account',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     },
                        //     customize: function(doc) {
                        //         // Customize PDF output if needed
                        //         doc.content[1].margin = [0, 0, 0, 0]; // Adjust margins
                        //         doc.content[1].table.widths = '*'.repeat(doc.content[1].table.body[
                        //             0].length).split('');
                        //     }
                        // },
                        // {
                        //     extend: 'print',
                        //     text: 'Print Table',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     }
                        // }
                    ],
                    initComplete: function() {
                        // Show the table after DataTables initialization is complete
                        $('#jobBalancingReport').show();
                    }
                });
            }
        });
    </script>
@endsection
