@extends('layout.master')

@section('title')
    PARTY-STATEMENT-OF-ACCOUNT-SUMMARY-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Party Statement Of Account Summary</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none;border-right: none; padding-bottom: 8px;border-top: none; margin-right: 70px; margin-bottom: 10px;">
            <!-- Added margin-bottom for gap -->
            <div class="text-center">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight:bold">YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10">Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.</h3>
                <p>Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2 display nowrap" id="jobBalancingReport"
                style="display: none; width:100%">
                <thead>
                    <tr>
                        <th rowspan="2">S#</th>
                        <th rowspan="2">Party Code</th>
                        <th rowspan="2">Party</th>
                        <th rowspan="2">Party Type</th>
                        <th rowspan="2">Opening</th>
                        <th colspan="2">Debit</th>
                        <th colspan="2">Credit</th>
                        <th rowspan="2">Balance</th>
                    </tr>
                    <tr>
                        <th>Invoice</th>
                        <th>Payment</th>
                        <th>Bill</th>
                        <th>Receipt</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $totalDebit = 0;
                        $totalCredit = 0;
                        $totalInvoice = 0;
                        $totalPayment = 0;
                        $totalReceipt = 0;
                        $totalBill = 0;
                    @endphp
                    @if ($groupOn == 1)
                        @foreach ($query as $j => $transaction)
                            @php
                                // Calculate individual debit and credit components
                                $invoiceDebit = (float) str_replace(',', '', @$transaction->total_debit);
                                $paymentDebit =
                                    @$transaction->receipt_payment->type == 'payment'
                                        ? (float) str_replace(',', '', @$transaction->receipt_payment->net_received)
                                        : 0;

                                $billCredit =
                                    @$transaction->transaction_type_master_id == 10
                                        ? (float) str_replace(',', '', @$transaction->total_credit)
                                        : 0;
                                $receiptCredit =
                                    @$transaction->receipt_payment->type == 'receipt'
                                        ? (float) str_replace(',', '', @$transaction->receipt_payment->net_received)
                                        : 0;

                                // Calculate total debit and credit for the transaction
                                $totalTransactionDebit = $invoiceDebit + $paymentDebit;
                                $totalTransactionCredit = $billCredit + $receiptCredit;

                                // Calculate the balance as Debit - Credit
                                $balance = $totalTransactionDebit - $totalTransactionCredit;

                                // Determine DR/CR format for balance
                                $formattedBalance =
                                    $balance >= 0
                                        ? number_format(abs($balance), 2) . ' DR'
                                        : number_format(abs($balance), 2) . ' CR';

                                // Update totals
                                $totalDebit += $totalTransactionDebit;
                                $totalCredit += $totalTransactionCredit;
                                $totalInvoice += $invoiceDebit;
                                $totalPayment += $paymentDebit;
                                $totalBill += $billCredit;
                                $totalReceipt += $receiptCredit;
                            @endphp
                            <tr>
                                <td>{{ (int) $j + 1 }}</td>
                                <td>{{ @$transaction->chart_of_accounts->party->id }}</td>
                                <td>{{ @$transaction->chart_of_accounts->party->name }}</td>
                                <td></td>
                                <td></td>
                                <td>{{ number_format($invoiceDebit, 2) }}</td>
                                <td>{{ number_format($paymentDebit, 2) }}</td>
                                <td>{{ number_format($billCredit, 2) }}</td>
                                <td>{{ number_format($receiptCredit, 2) }}</td>
                                <td>{{ $formattedBalance }}</td>
                            </tr>
                        @endforeach
                    @else
                        @foreach ($query as $i => $groupItems)
                            @foreach ($groupItems as $j => $transaction)
                                @php
                                    // Calculate individual debit and credit components
                                    $invoiceDebit = (float) str_replace(',', '', @$transaction->total_debit);
                                    $paymentDebit =
                                        @$transaction->receipt_payment->type == 'payment'
                                            ? (float) str_replace(',', '', @$transaction->receipt_payment->net_received)
                                            : 0;

                                    $billCredit =
                                        @$transaction->transaction_type_master_id == 10
                                            ? (float) str_replace(',', '', @$transaction->total_credit)
                                            : 0;
                                    $receiptCredit =
                                        @$transaction->receipt_payment->type == 'receipt'
                                            ? (float) str_replace(',', '', @$transaction->receipt_payment->net_received)
                                            : 0;

                                    // Calculate total debit and credit for the transaction
                                    $totalTransactionDebit = $invoiceDebit + $paymentDebit;
                                    $totalTransactionCredit = $billCredit + $receiptCredit;

                                    // Calculate the balance as Debit - Credit
                                    $balance = $totalTransactionDebit - $totalTransactionCredit;

                                    // Determine DR/CR format for balance
                                    $formattedBalance =
                                        $balance >= 0
                                            ? number_format(abs($balance), 2) . ' DR'
                                            : number_format(abs($balance), 2) . ' CR';

                                    // Update totals
                                    $totalDebit += $totalTransactionDebit;
                                    $totalCredit += $totalTransactionCredit;
                                    $totalInvoice += $invoiceDebit;
                                    $totalPayment += $paymentDebit;
                                    $totalBill += $billCredit;
                                    $totalReceipt += $receiptCredit;
                                @endphp
                                <tr>
                                    <td>{{ (int) $j + 1 }}</td>
                                    <td>{{ @$transaction->chart_of_accounts->party->id }}</td>
                                    <td>{{ @$transaction->chart_of_accounts->party->name }}</td>
                                    <td></td>
                                    <td></td>
                                    <td>{{ number_format($invoiceDebit, 2) }}</td>
                                    <td>{{ number_format($paymentDebit, 2) }}</td>
                                    <td>{{ number_format($billCredit, 2) }}</td>
                                    <td>{{ number_format($receiptCredit, 2) }}</td>
                                    <td>{{ $formattedBalance }}</td>
                                </tr>
                            @endforeach
                        @endforeach
                    @endif
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="5">Total</th>
                        <th>{{ number_format($totalInvoice, 2) }}</th> <!-- Total Invoice Debit -->
                        <th>{{ number_format($totalPayment, 2) }}</th> <!-- Total Payment Debit -->
                        <th>{{ number_format($totalBill, 2) }}</th> <!-- Total Bill Credit -->
                        <th>{{ number_format($totalReceipt, 2) }}</th> <!-- Total Receipt Credit -->

                        @php
                            // Calculate the final total balance as Total Debit - Total Credit
                            $finalBalance = $totalDebit - $totalCredit;
                            $formattedFinalBalance =
                                $finalBalance >= 0
                                    ? number_format(abs($finalBalance), 2) . ' DR'
                                    : number_format(abs($finalBalance), 2) . ' CR';
                        @endphp

                        <th>{{ $formattedFinalBalance }}</th> <!-- Display the final balance with DR/CR -->
                    </tr>
                </tfoot>
            </table>
        </div>
        {{-- end Pagination --}}
    </div>
    <!-- jQuery (Required for DataTables) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>

    <script>
        $(document).ready(function() {
            // Check if DataTable library is loaded
            if ($.fn.dataTable) {
                // Initialize the DataTable
                $('#jobBalancingReport').DataTable({
                    dom: 'Bfrtip', // Include export buttons in the DOM
                    buttons: [{
                            extend: 'excelHtml5',
                            text: 'Export to Excel',
                            title: 'Party Statement Of Account Summary',
                            exportOptions: {
                                columns: ':visible' // Export only visible columns
                            }
                        },
                        // {
                        //     extend: 'pdfHtml5',
                        //     text: 'Export to PDF',
                        //     title: 'Party Statement Of Account',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     },
                        //     customize: function(doc) {
                        //         // Customize PDF output if needed
                        //         doc.content[1].margin = [0, 0, 0, 0]; // Adjust margins
                        //         doc.content[1].table.widths = '*'.repeat(doc.content[1].table.body[
                        //             0].length).split('');
                        //     }
                        // },
                        // {
                        //     extend: 'print',
                        //     text: 'Print Table',
                        //     exportOptions: {
                        //         columns: ':visible' // Export only visible columns
                        //     }
                        // }
                    ],
                    initComplete: function() {
                        // Show the table after DataTables initialization is complete
                        $('#jobBalancingReport').show();
                    }
                });
            }
        });
    </script>
@endsection
