@extends('layout.master')

@section('title')
Report Fixed Text-YARAN
@endsection

@section('topbar')
<a href="/reportfixedtexts" class="breadcrumb--active">Report Fixed Text</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Report Fixed Texts
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('reportfixedtexts.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $reportfixedtexts->firstItem() }} to
                {{ $reportfixedtexts->lastItem() }} of {{ $reportfixedtexts->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Doc #</th>
                        <th>Report</th>
                        <th>Description</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($reportfixedtexts as $reportfixedtext)
                        <tr>
                            <td>{{ $reportfixedtext->id }}</td>
                            <td>{{ $reportfixedtext->doc_no }}</td>
                            <td>{{ $reportfixedtext->report_no }}</td>
                            <td>{{ $reportfixedtext->description }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('reportfixedtexts.edit', [$reportfixedtext->id]) }}"
                                        class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['reportfixedtexts.destroy', $reportfixedtext->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
