{{-- @extends('layout.master')

@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-2"><a href="{{ url('/dashboard') }}" class="text-muted fw-light">Dashboard </a><a href="{{ url('/role') }}" class="text-muted fw-light">/ Role</a><span class="color"> /</span><span class="text-heading fw-bold text-color"> Edit</span>
        </h4>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <h5 class="card-header">Edit Role</h5>
                    <div class="card-body">
                        <form method="POST" id="myForm" action="{{ url('/role/edit/' . $role->id) }}"
                            enctype="multipart/form-data" id="formValidationExamples" class="row g-3">
                            @csrf
                            <div class="col-md-6">
                                <div class="col-md-6">
                                    <label for="regular-form-1" class="form-label">Role</label>
                                    <input id="regular-form-1" type="text" class="form-control "
                                    value="{{ $role->title }}"   placeholder="Enter Role" name="role">

                                </div>
                            </div>
                            @foreach ($permissions as $permission)
                                <div class="bg-light-primary rounded-2">
                                    <h6 class="my-2 ms-2">{{ $permission->pluck('group_by')->first() }}</h6>
                                </div>
                                <div class="row row-bordered g-0">
                                    @foreach ($permission as $detail)
                                        <div class="col-md-3 pt-0 p-3">
                                            <div class="form-check mt-3">
                                                <input class="form-check-input" type="checkbox" value="{{ $detail->id }}"
                                                    id="permission-{{ $detail->id }}" name="permissions[]"
                                                    @if (in_array($detail->id, $role_permissions)) checked @endif />
                                                <label class="form-check-label text-capitalize"
                                                    for="permission-{{ $detail->id }}">
                                                    {{ str_replace('_', ' ', explode('-', $detail->title)[0]) }}
                                                </label>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endforeach

                            <div class="col-12">
                                <a href="{{ url('/role') }}" type="back" class="btn btn-label-secondary waves-effect">
                                    Back
                                </a>
                                <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection --}}


    @extends('layout.master')

    @section('title')
    Edit-Role-YARAN
    @endsection

    @section('topbar')
    <a href="/role" class="breadcrumb-item">Role</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Edit</a>
    @endsection
    @section('content')
    <form method="POST" id="myForm" action="{{ url('/role/edit/' . $role->id) }}"
        enctype="multipart/form-data" id="formValidationExamples" class="row g-3">
        @csrf
    <div class="intro-y box mt-5">
        <div class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
            <h2 class="fw-medium fs-base me-auto">
                Edit Role
            </h2>
            
            <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Save</button>
            <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                Back
            </a>
        </div>
        <div id="small-table" class="p-5">
            <div class="preview">
                <div class="overflow-x-auto col-md-12">
                        <div class="col-md-6 mb-10 ">
                            <div class="col-md-6">
                                <label for="regular-form-1" class="form-label">Role</label>
                                <input id="regular-form-1" type="text" class="form-control "
                                value="{{ $role->title }}"   placeholder="Enter Role" name="title">

                            </div>
                        </div>
                        <div class="col-md-12">
                    <table class="table table-sm">
                        @foreach ($permissions as $permission)
                        <thead>
                            <tr>
                                <th class="text-nowrap">{{ $permission->pluck('group_by')->first() }}</th>

                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                            <div class="row  g-0">
                                @foreach ($permission as $detail)
                                    <div class="col-md-3 pt-0 p-3">
                                        <div class="form-check mt-3">
                                            <input class="form-check-input" type="checkbox" value="{{ $detail->id }}"
                                                id="permission-{{ $detail->id }}" name="permissions[]"
                                                @if (in_array($detail->id, $role_permissions)) checked @endif />
                                            <label class="form-check-label text-capitalize"
                                                for="permission-{{ $detail->id }}">
                                                {{ str_replace('_', ' ', explode('-', $detail->title)[0]) }}
                                            </label>
                                        </div>
                                    </div>
                                @endforeach

                            </div>
                        </td>
                    </tr>
                        </tbody>
                        @endforeach

                    </table>
                </form>
                </div>

                </div>
            </div>

        </div>
    </div>
    @endsection

