@extends('layout.master')

@section('title')
Role-YARAN
@endsection

@section('topbar')
<a href="/role" class="breadcrumb--active">Role</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Roles
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ url('/role/add') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $roles->firstItem() }} to
                {{ $roles->lastItem() }} of {{ $roles->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <form id="MyForm" method="post" action="{{ url('/role/index') }}">
                        @csrf
                        <tr>
                            <th>Id</th>
                            <th>Title</th>
                            <th>Actions</th>
                    </form>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($roles as $role)
                        <tr>
                            <td>{{ $role->id }}</td>
                            <td>{{ $role->title }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    @can('Role_Edit')
                                        <a class="btn btn-primary me-2 p-2" href="{{ url('/role/edit/' . $role->id) }}"><i
                                                data-feather="edit" class="w-4 h-4"></i> </a>
                                    @endcan
                                    @can('Role_Delete')
                                        <form method="post" action="{{ url('/role/delete/' . $role->id) }}">
                                            @csrf
                                            <button type="submit" class="btn btn-danger p-2">
                                                <i data-feather="trash-2" class="w-4 h-4"></i>
                                            </button>
                                        </form>
                                        {{-- <div class="g-col-6 g-col-sm-3 g-col-lg-2 g-col-xl-1">
                                    <i data-feather="trash-2" class="d-block mx-auto"></i>
                                    <div class="text-center fs-xs mt-2">trash-2</div>
                                </div> --}}
                                    @endcan
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
