@extends('layout.master')

@section('title')
Sales Rep-YARAN
@endsection

@section('topbar')
<a href="/salesrepstatuses" class="breadcrumb--active">Sales Rep</a>
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        Sales Rep Status
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ route('salesrepstatuses.create') }}">Add New</a>
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $salesrepstatuses->firstItem() }} to
                {{ $salesrepstatuses->lastItem() }} of {{ $salesrepstatuses->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Sales Rep</th>
                        <th>Status</th>
                        <th>Remarks</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($salesrepstatuses as $salesrepstatus)
                        <tr>
                            <td>{{ $salesrepstatus->id }}</td>
                            <td>{{ $salesrepstatus->sales_rep }}</td>
                            <td>{{ $salesrepstatus->status == 1 ? 'Block' : 'UnBlock' }}</td>
                            <td>{{ $salesrepstatus->remarks }}</td>

                            <td>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('salesrepstatuses.edit', [$salesrepstatus->id]) }}"
                                        class="btn btn-primary">Edit</a>
                                    {!! Form::open(['method' => 'DELETE', 'route' => ['salesrepstatuses.destroy', $salesrepstatus->id]]) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                    {!! Form::close() !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
