@extends('layout.master')

@section('title')
Edit-CRO-YARAN
@endsection

@section('topbar')
<a href="/cro" class="breadcrumb-item">CRO</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Edit</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/cro/edit/' . $cro_master->job_master_id) }}"
                enctype="multipart/form-data" class="row g-3">
                @csrf
            <div class="intro-y box">
                <div
                    class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                    <h2 class="fw-medium fs-base me-auto">
                        Add CRO
                    </h2>
                    <button type="submit" class="btn btn-primary submitBtn"
                        id="submitBtn">Save</button>
                    <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                        Back
                    </a>
                </div>

                <div id="input" class="p-5">
                    <div class=" col-md-12">
                            <div class="row mb-5">
                                {{-- <div class="col-md-4 mt-1">
                                    <label for="regular-form-1" class="form-label">CRO No</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter CRO No" name="cro_no">
                                </div> --}}
                                <div class="col-md-4 mt-1">
                                    <label>CRO Type</label>
                                    <div class="mt-1">
                                        <select data-placeholder="Select CRO Type" id="regular-form-1" name="cro_type"
                                            class="tom-select w-full">
                                            <option {{ $cro_master->cro_type == 'Against Job/Booking' ? 'selected' : '' }}
                                                value="Against Job/Booking">Against Job/Booking</option>
                                            <option {{ $cro_master->cro_type == 'For Empty Movement' ? 'selected' : '' }}
                                                value="For Empty Movement">For Empty Movement</option>
                                            <option {{ $cro_master->cro_type == 'For Sale/Off-Hire' ? 'selected' : '' }}
                                                value="For Sale/Off-Hire">For Sale/Off-Hire</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 mt-1">
                                    <label for="regular-form-1" class="form-label">Job #</label>
                                    <input type="hidden" value="{{ @$cro_master->job_master_id }}" name="job_no">

                                    <input id="regular-form-1" type="text" class="form-control" readonly
                                        placeholder="Enter Job #" value="{{ @$cro_master->job_master->job_no }}" name="sej_job_no">
                                </div>
                                <div class="col-md-4 mt-1">
                                    <label for="regular-form-1" class="form-label">Client</label>
                                    <select class="tom-select" name="client_id" id="client_id">
                                        <option value="">Please Select</option>
                                        @foreach ($clients as $item)
                                            <option {{ $cro_master->client_id == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="regular-form-1" class="form-label">Issue Date</label>
                                    <input id="regular-form-1" value="{{ @$cro_master->issue_date }}" type="date"
                                        class="form-control" name="issue_date">
                                </div>
                                <div class="col-md-4 mt-1">
                                    <label for="regular-form-1" class="form-label">CRO Valid For</label>
                                    <input id="regular-form-1" value="{{ @$cro_master->cro_valid_for }}" type="text"
                                        class="form-control" placeholder="Enter Days" name="cro_valid_for">
                                </div>
                                <div class="col-md-4 mt-1">
                                    <label for="regular-form-1" class="form-label">Equip Qty</label>
                                    <input id="regular-form-1" value="{{ @$cro_master->equip_qty }}" type="text"
                                        class="form-control" placeholder="Enter Equip Qty" name="equip_qty">
                                </div>
                                <div class="col-md-4 mt-1">
                                    <label for="regular-form-1" class="form-label">Reference #</label>
                                    <input id="regular-form-1" value="{{ @$cro_master->reference_no }}" type="text"
                                        class="form-control" placeholder="Enter Reference #" name="reference_no">
                                </div>
                                <div class="col-md-4">
                                    <label>Size Type</label>
                                    <div class="mt-1">
                                        <select data-placeholder="Select CRO Type" id="regular-form-1" name="size_type"
                                            class="tom-select w-full">
                                            <option value=""></option>
                                        </select>
                                    </div>
                                </div>
                                <!-- Details Menu -->
                                <div class="mt-5">
                                    <div class="g-col-12 g-col-lg-4 g-col-xxl-3">
                                        <div class="intro-y pe-1">
                                            <div class="box p-2">
                                                <ul class="nav nav-pills rounded-2" role="tablist">
                                                    <li id="cro_details_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5 active"
                                                            data-bs-toggle="pill" data-bs-target="#cro_detail"
                                                            type="button" role="tab" aria-controls="cro_details_tab"
                                                            aria-selected="true">CRO Details</button>
                                                    </li>
                                                    <li id="gate_pass_details_tab" class="nav-item flex-1"
                                                        role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                                            data-bs-target="#gate_pass_details" type="button"
                                                            role="tab" aria-controls="gate_pass_details_tab"
                                                            aria-selected="false">Gate Pass Details</button>
                                                    </li>
                                                    <li id="vessel_details_tab" class="nav-item flex-1"
                                                        role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                                            data-bs-target="#vessel_details" type="button"
                                                            role="tab" aria-controls="vessel_details_tab"
                                                            aria-selected="false">Vessel Details</button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="tab-content mt-2">
                                            <div class="tab-pane fade show active" id="cro_detail" role="tabpanel"
                                                aria-labelledby="cro_details_tab">
                                                <div class="row">
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Overseas
                                                            Agent</label>
                                                        <select class="tom-select" name="overseas_agent_id"
                                                            id="overseas_agent_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($overseas_agent as $item)
                                                                <option
                                                                    {{ @$cro_master->cro_detail->overseas_agent_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Clearing
                                                            Agent</label>
                                                        <select class="tom-select" name="clearing_agent_id"
                                                            id="clearing_agent_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($custom_clearance as $item)
                                                                <option
                                                                    {{ @$cro_master->cro_detail->clearing_agent_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        {{-- <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Clearing Agent" name="clearing_agent"> --}}
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Shipper</label>
                                                        <select class="tom-select" name="shipper_id" id="shipper_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($shippers as $item)
                                                                <option
                                                                    {{ @$cro_master->cro_detail->shipper_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Pickup
                                                            Location</label>
                                                        <select class="tom-select" name="pickup_location"
                                                            id="pickup_location">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$cro_master->cro_detail->pickup_location == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        {{-- <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Pickup Location" name="pickup_location"> --}}
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Port of
                                                            Loading</label>
                                                        <select class="tom-select" name="port_of_loading_id"
                                                            id="port_of_loading_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$cro_master->cro_detail->port_of_loading_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Port Of
                                                            Discharge</label>
                                                        <select class="tom-select" name="port_of_discharge_id"
                                                            id="port_of_discharge_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$cro_master->cro_detail->port_of_discharge_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">
                                                                    {{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Final
                                                            Destination</label>
                                                        <select class="tom-select" name="final_destination_id"
                                                            id="final_destination_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($un_locations as $item)
                                                                <option
                                                                    {{ @$cro_master->cro_detail->final_destination_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Commodity</label>
                                                        <select class="tom-select" name="commodity_id" id="commodity_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($commodities as $item)
                                                                <option
                                                                    {{ @$cro_master->cro_detail->commodity_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Terminal</label>
                                                        <select class="tom-select" name="terminal_id" id="terminal_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($party_locations as $item)
                                                                {{ @$cro_master->cro_detail->terminal_id == $item->id ? 'selected' : '' }}
                                                                value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Empty Depot</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Empty Depot"
                                                            value="{{ @$cro_master->cro_detail->empty_depot }}"
                                                            name="empty_depot">
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Transporter</label>
                                                        <select class="tom-select" name="transporter_id"
                                                            id="transporter_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($transportation as $item)
                                                                {{ @$cro_master->cro_detail->transporter_id == $item->id ? 'selected' : '' }}
                                                                value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        {{-- <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Transporter" name="transporter"> --}}
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane fade" id="gate_pass_details" role="tabpanel"
                                                aria-labelledby="gate_pass_details_tab">
                                                <div class="row">
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Book No</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Book No"
                                                            value="{{ @$cro_master->cro_gatepass->book_no }}"
                                                            name="book_no">
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Date</label>
                                                        <input id="regular-form-1" type="date"
                                                            value="{{ @$cro_master->cro_gatepass->date }}"
                                                            class="form-control" name="date">
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Licence No</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Licence No"
                                                            value="{{ @$cro_master->cro_gatepass->licence_no }}"
                                                            name="licence_no">
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Expiry Date</label>
                                                        <input id="regular-form-1" type="date"
                                                            value="{{ @$cro_master->cro_gatepass->expiry_date }}"
                                                            class="form-control" name="expiry_date">
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Shipping
                                                            Agent</label>
                                                        <select class="tom-select" name="shipping_agent"
                                                            id="shipping_agent">
                                                            <option value="">Please Select</option>
                                                            @foreach ($shipping_line as $item)
                                                                <option
                                                                    {{ @$cro_master->cro_gatepass->shipping_agent == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Gate Pass #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Gate Pass #"
                                                            value="{{ @$cro_master->cro_gatepass->gate_pass_no }}"
                                                            name="gate_pass_no">
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Letter No</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Letter No"
                                                            value="{{ @$cro_master->cro_gatepass->letter_no }}"
                                                            name="letter_no">
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Job #</label>
                                                        <input type="hidden" value="{{ @$cro_master->job_master_id }}" name="job_no">

                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            readonly placeholder="Enter Job #"
                                                            value="{{ @$cro_master->job_master->job_no }}" name="sej_job_no">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane fade" id="vessel_details" role="tabpanel"
                                                aria-labelledby="vessel_details_tab">
                                                <div class="row">
                                                    <div class="col-md-4 mt-10">
                                                        <label for="regular-form-1" class="form-label">Cargo Type:
                                                        </label>
                                                        <input class="form-check-input" type="radio"
                                                            {{ $cro_master->cargo_type == 'General' ? 'checked' : '' }}
                                                            name="cargo_type" id="general" value="General">
                                                        <label class="form-label" for="general">
                                                            General
                                                        </label>
                                                        <input class="form-check-input" type="radio"
                                                            {{ $cro_master->cargo_type == 'Hazardous' ? 'checked' : '' }}
                                                            name="cargo_type" id="hazardous" value="Hazardous">
                                                        <label class="form-label" for="hazardous">
                                                            Hazardous
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Vessel</label>
                                                        <select class="tom-select" name="vessel_id" id="vessel_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($vessels as $item)
                                                                <option
                                                                    {{ @$cro_master->cro_vessel->vessel_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Voyage</label>
                                                        <select class="tom-select" name="voyage_id" id="voyage_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($voyages as $item)
                                                                <option
                                                                    {{ @$cro_master->cro_vessel->voyage_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">
                                                                    {{ $item->voyage_no }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-2 mt-10">
                                                        <input id="regular-form-1" type="checkbox"
                                                            class="form-check-input"
                                                            {{ @$cro_master->cro_vessel->manual == '1' ? 'checked' : '' }}
                                                            name="manual" value="1">
                                                        <label class="form-label" for="manual">
                                                            Manual
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-6">
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Manual"
                                                            value="{{ @$cro_master->cro_vessel->manual_value }}"
                                                            name="manual_value">
                                                    </div>
                                                    <div class="col-md-3 mt-10">
                                                        <input id="regular-form-1" type="checkbox"
                                                            class="form-check-input"
                                                            {{ @$cro_master->cro_vessel->manual == '1' ? 'checked' : '' }}
                                                            value="1" name="print_logo">
                                                        <label class="form-label" for="print_logo">
                                                            Print Logo
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-10">
                                                        <input id="regular-form-1" type="checkbox"
                                                        {{ @$cro_master->cro_vessel->continue_mode == '1' ? 'checked' : '' }}
                                                            class="form-check-input" name="continue_mode" value="1">
                                                        <label class="form-label" for="continue_mode">
                                                            Continue Mode
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-1">
                                                        <label for="regular-form-1" class="form-label">Sailing
                                                            Date</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            name="sailing_date"
                                                            value="{{ @$cro_master->cro_vessel->sailing_date }}">
                                                    </div>
                                                    <div class="col-md-12 mt-1">
                                                        <label for="regular-form-1" class="form-label">Haulage
                                                            Instructions</label>
                                                        <textarea name="haulage_instructions" id="regular-form-1" cols="30" rows="5" class="form-control"
                                                            placeholder="Enter Haulage Instructions">{{ @$cro_master->cro_vessel->haulage_instructions }}</textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
