@extends('layout.master')

@section('title')
CRO-YARAN
@endsection

@section('topbar')
<a href="/cro" class="breadcrumb--active">CRO</a>
@endsection
@section('content')
    {{-- <h2 class="intro-y fs-lg fw-medium mt-10">
        CRO
    </h2> --}}
    <div class="intro-y d-flex align-items-center">
        <div class="d-flex align-items-center">
            <h2 class="intro-y fs-lg fw-medium mt-10">
                CRO
            </h2>
        </div>
        <div class="ms-auto mt-10">
            <button class="btn btn-primary dark-text-theme-10" type="button"
                data-bs-toggle="collapse" data-bs-target="#faq-accordion-collapse-1" aria-expanded="true"
                aria-controls="faq-accordion-collapse-1"> <i data-feather="filter" class="w-4 h-4 me-3"></i> Filters
            </button>
        </div>
    </div>
    <div id="faq-accordion-collapse-1" class="accordion-collapse collapse show mt-5" aria-labelledby="faq-accordion-content-1"
        data-bs-parent="#faq-accordion-1">
        <div class="grid columns-12 gap-6 mt-5">
            <div class="intro-y g-col-12 g-col-lg-12">
                <!-- BEGIN: Form Layout -->
                <div class="intro-y box p-5">
                    <form method="GET" id="myForm" action="{{ url('/cro') }}">
                        <div class="row">
                            <div class="col-md-4">
                                <div>
                                    <label for="filterBy" class="form-label">Select</label>
                                    <select name="filterBy" id="filterBy" class="form-control">
                                        <option value="" {{ request('filterBy') == '' ? 'selected' : '' }}>Select</option>
                                        <option value="id" {{ request('filterBy') == 'id' ? 'selected' : '' }}>CRO No.</option>
                                        <option value="job_master_id" {{ request('filterBy') == 'job_master_id' ? 'selected' : '' }}>Job Number</option>
                                        <option value="client_id" {{ request('filterBy') == 'client_id' ? 'selected' : '' }}>Client ID</option>
                                        <option value="reference_no" {{ request('filterBy') == 'reference_no' ? 'selected' : '' }}>reference #</option>
                                        <option value="overseas_agent_id" {{ request('filterBy') == 'overseas_agent_id' ? 'selected' : '' }}>Overseas Agent ID</option>
                                        <option value="shipper_id" {{ request('filterBy') == 'shipper_id' ? 'selected' : '' }}>Shipper ID</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="filterValue" class="form-label">Name</label>
                                <input type="text" name="filterValue" class="form-control" 
                                value="{{ request('filterValue') }}" placeholder="Enter Name or ID" 
                                name="name" aria-label="Enter Name">
                            </div>
                            <div class="col-md-4 mt-8">
                                <button type="submit" class="btn btn-sm btn-elevated-primary w-24">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20" height="20" class="main-grid-item-icon" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                    <circle cx="11" cy="11" r="8" />
                                    <line x1="21" x2="16.65" y1="21" y2="16.65" />
                                </svg>  
                                    Search</button>
                                    <a href="{{ url('/cro') }}" type="button"
                                    class="btn btn-sm btn-elevated-danger w-24">
                                    {{-- <i data-feather="x"></i> --}}
                                    <!-- https://feathericons.dev/?search=x&iconset=feather -->
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20" height="20" class="main-grid-item-icon" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                    <line x1="18" x2="6" y1="6" y2="18" />
                                    <line x1="6" x2="18" y1="6" y2="18" />
                                </svg>
                                    Clear</a>
                                </div>
                            </form>
                        </div>
                </div>
                <!-- END: Form Layout -->
            </div>
        </div>
    </div>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            <a class="btn btn-primary shadow-md me-2" href="{{ url('/cro/add') }}">Add New</a>
            {{-- <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $rategroups->firstItem() }} to
                {{ $rategroups->lastItem() }} of {{ $rategroups->total() }} entries</div> --}}
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>CRO No</th>
                        <th>CRO Type</th>
                        <th>Job #</th>
                        <th>Issue Date</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($cro_master as $item)
                        <tr>
                            <td>{{ $item->id }}</td>
                            <td>{{ $item->cro_type }}</td>
                            <td>{{ $item->job_master->job_no }}</td>
                            <td>{{ $item->issue_date }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <a class="btn btn-primary me-2 p-2" href="{{ url('/cro/edit/' . $item->id) }}"><i
                                            data-feather="edit" class="w-4 h-4 me-1"></i> Edit </a>
                                    {{-- <a class="btn btn-success me-2 p-2" href="{{ url('/se_bl/add/' . $item->id) }}"><i
                                            data-feather="activity" class="w-4 h-4"></i> </a> --}}
                                    {{-- <div class="g-col-6 g-col-sm-3 g-col-lg-2 g-col-xl-1">
                                    <i data-feather="trash-2" class="d-block mx-auto"></i>
                                    <div class="text-center fs-xs mt-2">trash-2</div>
                                </div> --}}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection