@extends('layout.master')

@section('title')
    Add-SE Agent Invoice-YARAN
@endsection

@section('topbar')
    <a href="/se_agent_invoice" class="breadcrumb-item">SE Agent Invoice</a><i data-feather="chevron-right"
        class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Add</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('se_agent_invoice/add') }}"
                enctype="multipart/form-data" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Add SE Agent Invoice
                        </h2>
                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="mt-5">
                                    <div class="g-col-12 g-col-lg-4 g-col-xxl-3">
                                        <div class="intro-y pe-1">
                                            <div class="box p-2">
                                                <ul class="nav nav-pills rounded-2" role="tablist">
                                                    <li id="invoice_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5 active"
                                                            data-bs-toggle="pill" data-bs-target="#invoice" type="button"
                                                            role="tab" aria-controls="invoice_tab"
                                                            aria-selected="true">Invoice</button>
                                                    </li>
                                                    <li id="charges_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                                            data-bs-target="#charges" type="button" role="tab"
                                                            aria-controls="charges_tab"
                                                            aria-selected="false">Charges</button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="tab-content mt-2">
                                            <div class="tab-pane fade show active" id="invoice" role="tabpanel"
                                                aria-labelledby="invoice_tab">
                                                <div class="row">
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Invoice #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Invoice #" name="tran_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Invoice Date</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            name="invoice_date">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Agent Invoice
                                                            #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Agent Invoice #" name="agent_invoice_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Status</label>
                                                        <select id="regular-form-1" name="bl_status"
                                                            class="tom-select w-full mt-2">
                                                            <option value="1">Active</option>
                                                            <option value="2">Inactive</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Invoice Type</label>
                                                        <select id="regular-form-1" name="invoice_type"
                                                            class="tom-select w-full mt-2">
                                                            <option value="SI">SI</option>
                                                            <option value="CN">CN</option>
                                                            <option value="Zero">Zero</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Overseas Agent</label>
                                                        <select class="tom-select" name="overseas_agent_id" id="overseas_agent_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($overseas_agent as $item)
                                                                <option
                                                                    value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Currency</label>
                                                        <select id="regular-form-1" name="currency"
                                                            class="tom-select w-full mt-2">
                                                            <option value="1">PKR</option>
                                                            <option value="2">USD</option>
                                                            <option value="3">AED</option>
                                                            <option value="4">GPB</option>
                                                            <option value="5">EUR</option>
                                                            <option value="6">BDT</option>
                                                            <option value="7">OMR</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Due Days</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Due Days" name="due_days">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Operation</label>
                                                        <select id="regular-form-1" name="operation_id"
                                                            class="tom-select w-full mt-2">
                                                            @foreach ($operations as $item)
                                                            <option
                                                                value="{{ $item->id }}">{{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Job #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Job #" name="job_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Auto/Manual</label>
                                                        <select id="regular-form-1" name="auto_manual"
                                                            class="tom-select w-full mt-2">
                                                            <option value="1">Auto</option>
                                                            <option value="2">Manual</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Cost Center</label>
                                                        <select id="regular-form-1" name="cost_center"
                                                            class="tom-select w-full mt-2">
                                                            <option value="1">Head Office</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Reference</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Reference" name="reference">
                                                    </div>
                                                    <div class="col-md-6 mt-12">
                                                        <label for="regular-form-1" class="form-label">Job Type</label>
                                                        <input class="form-check-input" type="radio" name="job_type"
                                                            id="single">
                                                        <label class="form-label" for="single">
                                                            Single
                                                        </label>
                                                        <input class="form-check-input" type="radio" name="job_type"
                                                            id="multiple">
                                                        <label class="form-label" for="multiple">
                                                            Multiple
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">SOA Date</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            name="soa_date">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">SOA #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter SOA #" name="soa_no">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane fade" id="charges" role="tabpanel"
                                                aria-labelledby="charges_tab">
                                                <div class="text-end mt-3 me-5">
                                                    <button id="addRowReceivableButton" type="button"
                                                        class="btn btn-primary">Add
                                                        Row</button>
                                                </div>
                                                <div class="row">
                                                    <div class="g-col-12 overflow-auto">
                                                        <table id="receiveableTable" class="table table-bordered mt-n2">
                                                            <thead>
                                                                <tr>
                                                                    <th class="text-nowrap">S.No</th>
                                                                    <th class="text-nowrap">Job #</th>
                                                                    <th class="text-nowrap">Charges Code</th>
                                                                    <th class="text-nowrap">Charge Name</th>
                                                                    <th class="text-nowrap">Charge Descripton</th>
                                                                    <th class="text-nowrap">Size/Type</th>
                                                                    <th class="text-nowrap">Rate Group</th>
                                                                    <th class="text-nowrap">DG/Non-DG</th>
                                                                    <th class="text-nowrap">Container</th>
                                                                    <th class="text-nowrap">HBL #</th>
                                                                    <th class="text-nowrap">MBL #</th>
                                                                    <th class="text-nowrap">DR/CR</th>
                                                                    <th class="text-nowrap">Qty</th>
                                                                    <th class="text-nowrap">Rate</th>
                                                                    <th class="text-nowrap">Amount</th>
                                                                    <th class="text-nowrap">Discount</th>
                                                                    <th class="text-nowrap">Net Amount</th>
                                                                    <th class="text-nowrap">Margin</th>
                                                                    <th class="text-nowrap">Tax</th>
                                                                    <th class="text-nowrap">Tax Amount</th>
                                                                    <th class="text-nowrap">Net Amount Inc Tax</th>
                                                                    <th class="text-nowrap">Currency</th>
                                                                    <th class="text-nowrap">Ex. Rate</th>
                                                                    <th class="text-nowrap">Local Amount</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Remarks</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Remarks" name="remarks">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Voucher #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Voucher #" name="voucher_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Bank
                                                            Details</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Bank Details" name="bank_details">
                                                    </div>
                                                    <div class="col-md-3 mt-10">
                                                        <input id="regular-form-1" type="checkbox"
                                                            class="form-check-input" name="manual_remarks"
                                                            value="1">
                                                        <label class="form-label" for="manual_remarks">
                                                            Manual Remarks
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Total
                                                            Amount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Total Amount" name="grand_total_amount">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Net Amount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Net Amount" name="grand_net_amount">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Discount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Discount" name="grand_discount">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Tax Amount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Tax Amount" name="grand_tax_amount">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Net Amount Inc
                                                            Tax</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Net Amount Inc Tax"
                                                            name="grand_net_amount_inc_tax">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Local
                                                            Amount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Local Amount" name="grand_local_amount">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function() {
        const dropdownOptions = {
            customers: [""],
            vendors: [""],
            charges: {!! json_encode($charges) !!},
            type: ["Inv", "CN"],
            basis: ["Unit"],
            ppcc: ["PP", "CC"],
            sizeType: ["20BK", "20FR", "20OT", "20RE", "20SD", "20TK", "40FR", "40BK", "40HC", "40HCRF",
                "40OT", "40SD", "40VH", "45BK", "45HC", "45OT", "45TK", "45VH", "M3"
            ],
            dgNonDg: ["DG", "Non-DG", "All"],
            currency: {!! json_encode($currencies) !!},
            drCr: ["DR", "CR"],
        };

        function createDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option + '">' + option + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createDynamicDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option.id + '">' + option.name + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createInput(type, name, placeholder) {
            if (type == "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '"value="1" class="form-check-input" placeholder="' +
                    placeholder + '">';
            } else {
                return '<input type="' + type + '" name="' + name +
                    '" class="form-control w-24" placeholder="' +
                    placeholder + '">';
            }
        }

        let rowReceivableCounter = 1;

        function addRowReceivable() {

            let row = '<tr>' +
                '<td class="text-nowrap">' + rowReceivableCounter +
                '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'job_no[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'charge_code[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('charge_id[]', dropdownOptions
                    .charges) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'description[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('size_type[]', dropdownOptions
                    .sizeType) + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'rate_group[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('dg_non_dg[]', dropdownOptions.dgNonDg) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'container[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'hbl_no[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'mbl_no[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('dr_cr[]', dropdownOptions.drCr) + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'qty[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'rate[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'discount[]', '') + '</td>' +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'net_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'margin[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'tax[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'tax_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'net_amount_inc_tax[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('currency[]', dropdownOptions.currency) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'ex_rate[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'local_amount[]', '') + '</td>' +
                '</tr>';
            $('#receiveableTable tbody').append(row);
            rowReceivableCounter++;
        }

        $('#addRowReceivableButton').click(addRowReceivable);
    });
</script>