@extends('layout.master')

@section('title')
    @if ($job_master->operation_id == 1)
        Edit-SE Agent Invoice-YARAN
    @elseif($job_master->operation_id == 2)
        Edit-SI Agent Invoice-YARAN
    @elseif($job_master->operation_id == 3)
        Edit-AE Agent Invoice-YARAN
    @elseif($job_master->operation_id == 4)
        Edit-AI Agent Invoice-YARAN
    @endif
@endsection

@section('topbar')
    @if ($job_master->operation_id == 1)
        <a href="/se_agent_invoice" class="breadcrumb-item">SE Agent Invoice</a>
    @elseif($job_master->operation_id == 2)
        <a href="/si_agent_invoice" class="breadcrumb-item">SI Agent Invoice</a>
    @elseif($job_master->operation_id == 3)
        <a href="/ae_agent_invoice" class="breadcrumb-item">AE Agent Invoice</a>
    @elseif($job_master->operation_id == 4)
        <a href="/ai_agent_invoice" class="breadcrumb-item">AI Agent Invoice</a>
    @endif
    <i data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Edit</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('se_agent_invoice/edit/' . $job_master->id) }}"
                enctype="multipart/form-data" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            @if ($job_master->operation_id == 1)
                                Edit SE Agent Invoice
                            @elseif($job_master->operation_id == 2)
                                Edit SI Agent Invoice
                            @elseif($job_master->operation_id == 3)
                                Edit AE Agent Invoice
                            @elseif($job_master->operation_id == 4)
                                Edit AI Agent Invoice
                            @endif
                        </h2>
                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="mt-5">
                                    <div class="g-col-12 g-col-lg-4 g-col-xxl-3">
                                        <div class="intro-y pe-1">
                                            <div class="box p-2">
                                                <ul class="nav nav-pills rounded-2" role="tablist">
                                                    <li id="invoice_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5 active"
                                                            data-bs-toggle="pill" data-bs-target="#invoice" type="button"
                                                            role="tab" aria-controls="invoice_tab"
                                                            aria-selected="true">Invoice</button>
                                                    </li>
                                                    <li id="charges_tab" class="nav-item flex-1" role="presentation">
                                                        <button class="nav-link w-full pt-2 pb-2.5" data-bs-toggle="pill"
                                                            data-bs-target="#charges" type="button" role="tab"
                                                            aria-controls="charges_tab"
                                                            aria-selected="false">Charges</button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="tab-content mt-2">
                                            <div class="tab-pane fade show active" id="invoice" role="tabpanel"
                                                aria-labelledby="invoice_tab">
                                                <div class="row">
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Invoice
                                                            #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Invoice #" name="tran_no"
                                                            value="{{ $invoice->tran_no }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Invoice
                                                            Date</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            name="invoice_date" value="{{ $invoice->inv_date }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Agent Invoice
                                                            #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Agent Invoice #" name="agent_invoice_no"
                                                            value="{{ $invoice->agent_invoice_no }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Status</label>
                                                        <select id="regular-form-1" name="bl_status"
                                                            class="tom-select w-full mt-2">
                                                            <option value="1"
                                                                {{ $invoice->bl_status == 1 ? 'selected' : '' }}>
                                                                Active</option>
                                                            <option value="2"
                                                                {{ $invoice->bl_status == 2 ? 'selected' : '' }}>
                                                                Inactive</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Invoice Type</label>
                                                        <select id="regular-form-1" name="invoice_type"
                                                            class="tom-select w-full mt-2">
                                                            <option value="SI"
                                                                {{ $invoice->invoice_type == 'SI' ? 'selected' : '' }}>
                                                                SI</option>
                                                            <option value="CN"
                                                                {{ $invoice->invoice_type == 'CN' ? 'selected' : '' }}>
                                                                CN</option>
                                                            <option value="Zero"
                                                                {{ $invoice->invoice_type == 'Zero' ? 'selected' : '' }}>
                                                                Zero</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Overseas
                                                            Agent</label>
                                                        <select class="tom-select" name="overseas_agent_id"
                                                            id="overseas_agent_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($overseas_agent as $item)
                                                                <option
                                                                    {{ $invoice->overseas_agent_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">
                                                                    {{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Currency</label>
                                                        <select id="regular-form-1" name="currency"
                                                            class="tom-select w-full mt-2">
                                                            <option value="1">PKR</option>
                                                            <option value="2">USD</option>
                                                            <option value="3">AED</option>
                                                            <option value="4">GPB</option>
                                                            <option value="5">EUR</option>
                                                            <option value="6">BDT</option>
                                                            <option value="7">OMR</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Due
                                                            Days</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Due Days" name="due_days"
                                                            value="{{ $invoice->due_days }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Operation</label>
                                                        <select id="regular-form-1" name="operation_id"
                                                            class="tom-select w-full mt-2">
                                                            @foreach ($operations as $item)
                                                                <option
                                                                    {{ $job_master->operation_id == $item->id ? 'selected' : '' }}
                                                                    value="{{ $item->id }}">
                                                                    {{ $item->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Job
                                                            #</label>
                                                        {{-- <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Job #" name="job_no"
                                                            value="{{ $job_master->id }}"> --}}
                                                        <input type="hidden" value="{{ $job_master->id }}"
                                                            name="job_no">
                                                        <input readonly type="text" class="form-control"
                                                            placeholder="Enter Job #"
                                                            value="{{ @$job_master->job_no }}"
                                                            name="sej_job_no">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Auto/Manual</label>
                                                        <select id="regular-form-1" name="auto_manual"
                                                            class="tom-select w-full mt-2">
                                                            <option value="1"
                                                                {{ $invoice->auto_manual == 1 ? 'selected' : '' }}>
                                                                Auto</option>
                                                            <option value="2"
                                                                {{ $invoice->auto_manual == 2 ? 'selected' : '' }}>
                                                                Manual</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label>Cost Center</label>
                                                        <select id="regular-form-1" name="cost_center"
                                                            class="tom-select w-full mt-2">
                                                            <option value="1" selected>Head Office</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Reference</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Reference" name="reference"
                                                            value="{{ $invoice->reference }}">
                                                    </div>
                                                    <div class="col-md-6 mt-12">
                                                        <label for="regular-form-1" class="form-label">Job
                                                            Type</label>
                                                        <input class="form-check-input" type="radio" name="job_type"
                                                            id="single"
                                                            {{ $invoice->job_type == 'single' ? 'checked' : '' }}>
                                                        <label class="form-label" for="single">
                                                            Single
                                                        </label>
                                                        <input class="form-check-input" type="radio" name="job_type"
                                                            id="multiple"
                                                            {{ $invoice->job_type == 'multiple' ? 'checked' : '' }}>
                                                        <label class="form-label" for="multiple">
                                                            Multiple
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">SOA
                                                            Date</label>
                                                        <input id="regular-form-1" type="date" class="form-control"
                                                            name="soa_date" value="{{ $invoice->soa_date }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">SOA
                                                            #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter SOA #" name="soa_no"
                                                            value="{{ $invoice->soa_no }}">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane fade" id="charges" role="tabpanel"
                                                aria-labelledby="charges_tab">
                                                <div class="text-end mt-3 me-5">
                                                    <button id="addRowReceivableButton" type="button"
                                                        class="btn btn-primary">Add
                                                        Row</button>
                                                </div>
                                                <div class="row">
                                                    <div class="g-col-12 overflow-auto">
                                                        <table id="receiveableTable" class="table table-bordered mt-n2">
                                                            <thead>
                                                                <tr>
                                                                    <th class="text-nowrap">S.No</th>
                                                                    <th class="text-nowrap">Job #</th>
                                                                    <th class="text-nowrap">Charges Code</th>
                                                                    <th class="text-nowrap">Charge Name</th>
                                                                    <th class="text-nowrap">Charge Descripton</th>
                                                                    <th class="text-nowrap">Size/Type</th>
                                                                    <th class="text-nowrap">Rate Group</th>
                                                                    <th class="text-nowrap">DG/Non-DG</th>
                                                                    <th class="text-nowrap">Container</th>
                                                                    <th class="text-nowrap">HBL #</th>
                                                                    <th class="text-nowrap">MBL #</th>
                                                                    <th class="text-nowrap">DR/CR</th>
                                                                    <th class="text-nowrap">Qty</th>
                                                                    <th class="text-nowrap">Rate</th>
                                                                    <th class="text-nowrap">Amount</th>
                                                                    <th class="text-nowrap">Discount</th>
                                                                    <th class="text-nowrap">Net Amount</th>
                                                                    <th class="text-nowrap">Margin</th>
                                                                    <th class="text-nowrap">Tax</th>
                                                                    <th class="text-nowrap">Tax Amount</th>
                                                                    <th class="text-nowrap">Net Amount Inc Tax</th>
                                                                    <th class="text-nowrap">Currency</th>
                                                                    <th class="text-nowrap">Ex. Rate</th>
                                                                    <th class="text-nowrap">Local Amount</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach ($invoiceCharges as $index => $item)
                                                                    <tr>
                                                                        <input type="hidden"
                                                                            name="job_charge_recievable_id[]"
                                                                            value="{{ $item->job_charge_recievable_id }}">
                                                                        <td>{{ $index + 1 }}</td>
                                                                        <td>
                                                                            <input type="hidden" name="job_no[]"
                                                                                value="{{ $item->job_id }}">

                                                                            <input readonly class="form-control" type="text"
                                                                                name="sej_job_no[]"
                                                                                value="{{ @$item->transaction->job_master->job_no }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="charge_code[]"
                                                                                value="{{ $item->charge_code }}">
                                                                        </td>
                                                                        <td><select class="form-control"
                                                                                name="charge_id[]" id="charge_id">
                                                                                @foreach ($charges as $charge)
                                                                                    <option
                                                                                        {{ $item->charge_id == $charge->id ? 'selected' : '' }}
                                                                                        value="{{ $charge->id }}">
                                                                                        {{ $charge->name }}
                                                                                    </option>
                                                                                @endforeach
                                                                            </select></td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="description[]"
                                                                                value="{{ $item->description }}">
                                                                        </td>
                                                                        <td><select class="form-control"
                                                                                name="size_type[]" id="size_type">
                                                                                <option
                                                                                    {{ $item->size_type == '20BK' ? 'selected' : '' }}
                                                                                    value="20BK">20BK</option>
                                                                                <option
                                                                                    {{ $item->size_type == '20FR' ? 'selected' : '' }}
                                                                                    value="20FR">20FR</option>
                                                                                <option
                                                                                    {{ $item->size_type == '20OT' ? 'selected' : '' }}
                                                                                    value="20OT">20OT</option>
                                                                                <option
                                                                                    {{ $item->size_type == '20RE' ? 'selected' : '' }}
                                                                                    value="20RE">20RE</option>
                                                                                <option
                                                                                    {{ $item->size_type == '20SD' ? 'selected' : '' }}
                                                                                    value="20SD">20SD</option>
                                                                                <option
                                                                                    {{ $item->size_type == '20TK' ? 'selected' : '' }}
                                                                                    value="20TK">20TK</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40FR' ? 'selected' : '' }}
                                                                                    value="40FR">40FR</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40BK' ? 'selected' : '' }}
                                                                                    value="40BK">40BK</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40HC' ? 'selected' : '' }}
                                                                                    value="40HC">40HC</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40HCRF' ? 'selected' : '' }}
                                                                                    value="40HCRF">40HCRF</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40OT' ? 'selected' : '' }}
                                                                                    value="40OT">40OT</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40SD' ? 'selected' : '' }}
                                                                                    value="40SD">40SD</option>
                                                                                <option
                                                                                    {{ $item->size_type == '40VH' ? 'selected' : '' }}
                                                                                    value="40VH">40VH</option>
                                                                                <option
                                                                                    {{ $item->size_type == '45BK' ? 'selected' : '' }}
                                                                                    value="45BK">45BK</option>
                                                                                <option
                                                                                    {{ $item->size_type == '45HC' ? 'selected' : '' }}
                                                                                    value="45HC">45HC</option>
                                                                                <option
                                                                                    {{ $item->size_type == '45OT' ? 'selected' : '' }}
                                                                                    value="45OT">45OT</option>
                                                                                <option
                                                                                    {{ $item->size_type == '45TK' ? 'selected' : '' }}
                                                                                    value="45TK">45TK</option>
                                                                                <option
                                                                                    {{ $item->size_type == '45VH' ? 'selected' : '' }}
                                                                                    value="45VH">45VH</option>
                                                                                <option
                                                                                    {{ $item->size_type == 'M3' ? 'selected' : '' }}
                                                                                    value="M3">M3</option>
                                                                            </select></td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="rate_group[]"
                                                                                value="{{ $item->rate_group }}">
                                                                        </td>
                                                                        <td><select class="form-control"
                                                                                name="dg_non_dg[]" id="dg_non_dg">
                                                                                <option
                                                                                    {{ $item->dg_non_dg == 'DG' ? 'selected' : '' }}
                                                                                    value="DG">
                                                                                    DG</option>
                                                                                <option
                                                                                    {{ $item->dg_non_dg == 'Non-DG' ? 'selected' : '' }}
                                                                                    value="Non-DG">
                                                                                    Non-DG</option>
                                                                                <option
                                                                                    {{ $item->dg_non_dg == 'All' ? 'selected' : '' }}
                                                                                    value="All">
                                                                                    All</option>
                                                                            </select></td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="container[]"
                                                                                value="{{ $item->container }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="hbl_no[]"
                                                                                value="{{ $item->hbl_no }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="mbl_no[]"
                                                                                value="{{ $item->mbl_no }}">
                                                                        </td>
                                                                        <td>
                                                                            <select name="dr_cr[]" id="currency">
                                                                                <option value="DR"
                                                                                    {{ $item->dr_cr == 'DR' ? 'selected' : '' }}>
                                                                                    DR</option>
                                                                                <option value="CR"
                                                                                    {{ $item->dr_cr == 'CR' ? 'selected' : '' }}>
                                                                                    CR</option>
                                                                            </select>
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control w-24"
                                                                                type="text" name="qty[]"
                                                                                value="{{ $item->qty }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="rate[]"
                                                                                value="{{ $item->rate }}">
                                                                        </td>
                                                                        <td><select name="currency[]" id="currency">
                                                                                @foreach ($currencies as $currency)
                                                                                    <option
                                                                                        {{ $item->currency == $currency->id ? 'selected' : '' }}
                                                                                        value="{{ $currency->id }}">
                                                                                        {{ $currency->name }}
                                                                                    </option>
                                                                                @endforeach
                                                                            </select></td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="amount[]"
                                                                                value="{{ $item->amount }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="discount[]"
                                                                                value="{{ $item->discount }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="net_amount[]"
                                                                                value="{{ $item->net_amount }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="margin[]"
                                                                                value="{{ $item->margin }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control w-30"
                                                                                type="text" name="tax[]"
                                                                                value="{{ $item->tax }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="tax_amount[]"
                                                                                value="{{ $item->tax_amount }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="net_amount_inc_tax[]"
                                                                                value="{{ $item->net_amount }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="ex_rate[]"
                                                                                value="{{ $item->ex_rate }}">
                                                                        </td>
                                                                        <td>
                                                                            <input class="form-control" type="text"
                                                                                name="local_amount[]"
                                                                                value="{{ $item->local_amount }}">
                                                                        </td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Remarks</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Remarks" name="remarks"
                                                            value="{{ $invoice->remarks }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Voucher
                                                            #</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Voucher #" name="voucher_no"
                                                            value="{{ $invoice->voucher_no }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Bank
                                                            Details</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Bank Details" name="bank_details"
                                                            value="{{ $invoice->bank_details }}">
                                                    </div>
                                                    <div class="col-md-3 mt-10">
                                                        <input id="regular-form-1" type="checkbox"
                                                            class="form-check-input" name="manual_remarks" value="1"
                                                            {{ $invoice->manual_remarks == 1 ? 'checked' : '' }}>
                                                        <label class="form-label" for="manual_remarks">
                                                            Manual Remarks
                                                        </label>
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Total
                                                            Amount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Total Amount" name="grand_total_amount"
                                                            value="{{ $invoice->grand_total_amount }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Net
                                                            Amount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Net Amount" name="grand_net_amount"
                                                            value="{{ $invoice->grand_net_amount }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Discount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Discount" name="grand_discount"
                                                            value="{{ $invoice->grand_discount }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Tax
                                                            Amount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Tax Amount" name="grand_tax_amount"
                                                            value="{{ $invoice->grand_tax_amount }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Net Amount
                                                            Inc Tax</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Net Amount Inc Tax"
                                                            name="grand_net_amount_inc_tax"
                                                            value="{{ $invoice->grand_net_amount_inc_tax }}">
                                                    </div>
                                                    <div class="col-md-3 mt-2">
                                                        <label for="regular-form-1" class="form-label">Local
                                                            Amount</label>
                                                        <input id="regular-form-1" type="text" class="form-control"
                                                            placeholder="Enter Local Amount" name="grand_local_amount"
                                                            value="{{ $invoice->grand_local_amount }}">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function() {
        const dropdownOptions = {
            customers: [""],
            vendors: [""],
            charges: {!! json_encode($charges) !!},
            type: ["Inv", "CN"],
            basis: ["Unit"],
            ppcc: ["PP", "CC"],
            sizeType: ["20BK", "20FR", "20OT", "20RE", "20SD", "20TK", "40FR", "40BK", "40HC", "40HCRF",
                "40OT", "40SD", "40VH", "45BK", "45HC", "45OT", "45TK", "45VH", "M3"
            ],
            dgNonDg: ["DG", "Non-DG", "All"],
            currency: {!! json_encode($currencies) !!},
            drCr: ["DR", "CR"],
        };

        function createDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option + '">' + option + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createDynamicDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option.id + '">' + option.name + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createInput(type, name, placeholder) {
            if (type == "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '"value="1" class="form-check-input" placeholder="' +
                    placeholder + '">';
            } else {
                return '<input type="' + type + '" name="' + name +
                    '" class="form-control w-24" placeholder="' +
                    placeholder + '">';
            }
        }

        let rowReceivableCounter = 1;

        function addRowReceivable() {

            let row = '<tr>' +
                '<td class="text-nowrap">' + rowReceivableCounter +
                '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'job_no[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'charge_code[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('charge_id[]', dropdownOptions
                    .charges) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'description[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('size_type[]', dropdownOptions
                    .sizeType) + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'rate_group[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('dg_non_dg[]', dropdownOptions.dgNonDg) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'container[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'hbl_no[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'mbl_no[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('dr_cr[]', dropdownOptions.drCr) + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'qty[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'rate[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'discount[]', '') + '</td>' +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'net_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'margin[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'tax[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'tax_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'net_amount_inc_tax[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('currency[]', dropdownOptions.currency) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'ex_rate[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'local_amount[]', '') + '</td>' +
                '</tr>';
            $('#receiveableTable tbody').append(row);
            rowReceivableCounter++;
        }

        $('#addRowReceivableButton').click(addRowReceivable);
    });
</script>
