@extends('layout.master')

@section('title')
    @if (Request::is('se_agent_invoice'))
        SE Agent Invoice-YARAN
    @elseif(Request::is('si_agent_invoice'))
        SI Agent Invoice-YARAN
    @elseif(Request::is('ae_agent_invoice'))
        AE Agent Invoice-YARAN
    @elseif(Request::is('ai_agent_invoice'))
        AI Agent Invoice-YARAN
    @endif
@endsection

@section('topbar')
    @if (Request::is('se_agent_invoice'))
        <a href="/se_agent_invoice" class="breadcrumb--active">SE Agent Invoice</a>
    @elseif(Request::is('si_agent_invoice'))
        <a href="/si_agent_invoice" class="breadcrumb--active">SI Agent Invoice</a>
    @elseif(Request::is('ae_agent_invoice'))
        <a href="/ae_agent_invoice" class="breadcrumb--active">AE Agent Invoice</a>
    @elseif(Request::is('ai_agent_invoice'))
        <a href="/ai_agent_invoice" class="breadcrumb--active">AI Agent Invoice</a>
    @endif
    {{-- <a href="/se_agent_invoice" class="breadcrumb--active">SE Agent Invoice</a> --}}
@endsection
@section('content')
    <h2 class="intro-y fs-lg fw-medium mt-10">
        @if (Request::is('se_agent_invoice'))
            SE Agent Invoice
        @elseif(Request::is('si_agent_invoice'))
            SI Agent Invoice
        @elseif(Request::is('ae_agent_invoice'))
            AE Agent Invoice
        @elseif(Request::is('ai_agent_invoice'))
            AI Agent Invoice
        @endif
    </h2>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            {{-- <a class="btn btn-primary shadow-md me-2" href="{{ url('/se_agent_invoice/add') }}">Add New</a> --}}
            {{-- <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $rategroups->firstItem() }} to
                {{ $rategroups->lastItem() }} of {{ $rategroups->total() }} entries</div> --}}
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Tran #</th>
                        <th>Job #</th>
                        <th>Inv Date</th>
                        <th>Reference</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($agent_invoice as $invoice)
                        <tr>
                            <td>{{ $invoice->tran_no }}</td>
                            <td>{{ $invoice->job_master->job_no }}</td>
                            <td>{{ $invoice->inv_date }}</td>
                            <td>{{ $invoice->reference }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    @if ($invoice->operation_id == 1)
                                        <a class="btn btn-primary me-2 p-2"
                                            href="{{ url('/se_agent_invoice/edit/' . $invoice->id) }}"><i data-feather="edit"
                                                class="w-4 h-4"></i> Edit</a>
                                    @elseif ($invoice->operation_id == 2)
                                        <a class="btn btn-primary me-2 p-2"
                                            href="{{ url('/si_agent_invoice/edit/' . $invoice->id) }}"><i data-feather="edit"
                                                class="w-4 h-4 me-1"></i>
                                            Edit </a>
                                    @elseif ($invoice->operation_id == 3)
                                        <a class="btn btn-primary me-2 p-2"
                                            href="{{ url('/ae_agent_invoice/edit/' . $invoice->id) }}"><i data-feather="edit"
                                                class="w-4 h-4 me-1"></i>
                                            Edit </a>
                                    @elseif ($invoice->operation_id == 4)
                                        <a class="btn btn-primary me-2 p-2"
                                            href="{{ url('/ai_agent_invoice/edit/' . $invoice->id) }}"><i data-feather="edit"
                                                class="w-4 h-4 me-1"></i>
                                            Edit </a>
                                    @endif
                                    <button id="showPrintBtn{{ $invoice->id }}" class="btn btn-success me-2 p-2 showPrintBtn"
                                        data-bs-toggle="modal" data-bs-target="#printModal" data-item-id="{{ $invoice->id }}"><i
                                            data-feather="file-text" class="w-4 h-4 me-1"></i> Print </button>
                                    {{-- <a target="_blank" href={{ url('se_invoice_print/' . $invoice->id) }}
                                        class="btn btn-success me-2 p-2"><i data-feather="file-text"
                                            class="w-4 h-4 me-1"></i>Print</a> --}}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @include('sea_export.se_agent_invoice.modals.print')
@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('.showPrintBtn').forEach(button => {
            button.addEventListener('click', function() {
                const invoiceID = this.getAttribute('data-item-id');

                document.getElementById('selectedInvoiceID').value = invoiceID;
            });
        });
    });

    $(document).ready(function() {
        $('input[name="show_hide_panel"]').change(function() {
            if ($(this).is(':checked')) {
                $('#show_panel').removeClass('d-none');
            } else {
                $('#show_panel').addClass('d-none');
            }
        });
        $('input[name="print_invoice_note"]').change(function() {
            if ($(this).is(':checked')) {
                $('#invoice_note_div').removeClass('d-none');
            } else {
                $('#invoice_note_div').addClass('d-none');
            }
        });
    });

    function updatePrintLink() {
        const invoiceId = document.getElementById('selectedInvoiceID').value;
        const hide_shipper_consignee = document.getElementById('hide_shipper_consignee').checked;
        const hide_consignee = document.getElementById('hide_consignee').checked;
        const hide_port_of_loading = document.getElementById('hide_port_of_loading').checked;
        const hide_port_of_discharge = document.getElementById('hide_port_of_discharge').checked;
        const hide_exchange_rate = document.getElementById('hide_exchange_rate').checked;
        const hide_hbl = document.getElementById('hide_hbl').checked;
        const hide_mbl = document.getElementById('hide_mbl').checked;
        const print_logo = document.getElementById('print_logo').checked;
        const print_on_letterhead = document.getElementById('print_on_letterhead').checked;
        // const print_balance = document.getElementById('print_balance').checked;
        const show_container = document.getElementById('show_container').checked;
        const show_bank = document.getElementById('show_bank').checked;
        const hide_volume = document.getElementById('hide_volume').checked;
        const show_remarks = document.getElementById('show_remarks').checked;
        const hide_sales_rep_and_ref_no = document.getElementById('hide_sales_rep_and_ref_no').checked;
        const msg_of_system_generated_invoice = document.getElementById('msg_of_system_generated_invoice').checked;
        const print_invoice_note = document.getElementById('print_invoice_note').checked;
        const hide_sa_line = document.getElementById('hide_sa_line').checked;
        const invoice_note = document.getElementById('invoice_note').value;

        // Set the href attribute with the updated URL
        printLink.href =
            `{{ url('agent_invoice_print') }}/${encodeURIComponent(invoiceId)}?hide_shipper_consignee=${encodeURIComponent(hide_shipper_consignee)}&hide_consignee=${encodeURIComponent(hide_consignee)}&hide_port_of_loading=${encodeURIComponent(hide_port_of_loading)}&hide_sa_line=${encodeURIComponent(hide_sa_line)}&hide_port_of_discharge=${encodeURIComponent(hide_port_of_discharge)}&hide_exchange_rate=${encodeURIComponent(hide_exchange_rate)}&hide_hbl=${encodeURIComponent(hide_hbl)}&hide_mbl=${encodeURIComponent(hide_mbl)}&print_logo=${encodeURIComponent(print_logo)}&print_on_letterhead=${encodeURIComponent(print_on_letterhead)}&show_container=${encodeURIComponent(show_container)}&show_bank=${encodeURIComponent(show_bank)}&hide_volume=${encodeURIComponent(hide_volume)}&show_remarks=${encodeURIComponent(show_remarks)}&hide_sales_rep_and_ref_no=${encodeURIComponent(hide_sales_rep_and_ref_no)}&msg_of_system_generated_invoice=${encodeURIComponent(msg_of_system_generated_invoice)}&print_invoice_note=${encodeURIComponent(print_invoice_note)}&invoice_note=${encodeURIComponent(invoice_note)}`;
    }
</script>
