@extends('layout.master')

@section('title')
    @if ($job_master->operation_id == 1)
        EDIT-SE Bill-YARAN
    @elseif($job_master->operation_id == 2)
        EDIT-SI Bill-YARAN
    @elseif($job_master->operation_id == 3)
        EDIT-AE Bill-YARAN
    @elseif($job_master->operation_id == 4)
        EDIT-AI Bill-YARAN
    @endif
    {{-- Edit-SE Bill-YARAN --}}
@endsection

@section('topbar')
    @if ($job_master->operation_id == 1)
        <a href="/se_bill" class="breadcrumb-item">SE Bill</a>
    @elseif($job_master->operation_id == 2)
        <a href="/si_bill" class="breadcrumb-item">SI Bill</a>
    @elseif($job_master->operation_id == 3)
        <a href="/ae_bill" class="breadcrumb-item">AE Bill</a>
    @elseif($job_master->operation_id == 4)
        <a href="/ai_bill" class="breadcrumb-item">AI Bill</a>
    @endif

    <i data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Edit</a>
@endsection
@section('content')
    <div class="row  mt-5">
        <div class="  col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/se_bill/edit/' . $job_master->id) }}">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            @if (Request::is('se_bill/edit/' . $job_master->id))
                                Edit SE Bill
                            @elseif(Request::is('si_bill/edit/' . $job_master->id))
                                Edit SI Bill
                            @elseif(Request::is('ae_bill/edit/' . $job_master->id))
                                Edit AE Bill
                            @elseif(Request::is('ai_bill/edit/' . $job_master->id))
                                Edit AI Bill
                            @endif
                        </h2>
                        @if ($bill->operation_id == 1)
                            <a class="btn btn-primary me-2 p-2"
                                href="{{ $bill->receipt_payment_details->isNotEmpty() ? url('/receipt/edit/' . $bill->receipt_payment_details->sortByDesc('created_at')->first()->receipt_payment_id) : url('/se_receipt/add?bill_id=' . $bill->id) }}">
                                <i data-feather="file-text" class="w-4 h-4 me-1"></i>
                                Job Payment
                            </a>
                        @elseif ($bill->operation_id == 2)
                            <a class="btn btn-primary me-2 p-2"
                                href="{{ $bill->receipt_payment_details->isNotEmpty() ? url('/receipt/edit/' . $bill->receipt_payment_details->sortByDesc('created_at')->first()->receipt_payment_id) : url('/si_receipt/add?bill_id=' . $bill->id) }}">
                                <i data-feather="file-text" class="w-4 h-4 me-1"></i>
                                Job Payment
                            </a>
                        @elseif ($bill->operation_id == 3)
                            <a class="btn btn-primary me-2 p-2"
                                href="{{ $bill->receipt_payment_details->isNotEmpty() ? url('/receipt/edit/' . $bill->receipt_payment_details->sortByDesc('created_at')->first()->receipt_payment_id) : url('/ae_receipt/add?bill_id=' . $bill->id) }}">
                                <i data-feather="file-text" class="w-4 h-4 me-1"></i>
                                Job Payment
                            </a>
                        @elseif ($bill->operation_id == 4)
                            <a class="btn btn-primary me-2 p-2"
                                href="{{ $bill->receipt_payment_details->isNotEmpty() ? url('/receipt/edit/' . $bill->receipt_payment_details->sortByDesc('created_at')->first()->receipt_payment_id) : url('/ai_receipt/add?bill_id=' . $bill->id) }}">
                                <i data-feather="file-text" class="w-4 h-4 me-1"></i>
                                Job Payment
                            </a>
                        @endif
                        <button type="button" id="showPrintBtn{{ $bill->id }}"
                            class="btn btn-success me-2 p-2 showPrintBtn" data-bs-toggle="modal"
                            data-bs-target="#printModal" data-item-id="{{ $bill->id }}">
                            <i data-feather="file-text" class="w-4 h-4 me-1"></i> Print
                        </button>
                    </div>
                    <div class="d-flex justify-content-end " style="margin-right:2%">
                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Save</button>
                        <a href="javascript:history.back()" class="btn btn-secondary waves-effect">
                            Back
                        </a>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row">
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Tran #</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Tran #" value="{{ $bill->tran_no }}" name="tran_no" readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Bill Date</label>
                                    <input id="regular-form-1" type="date" class="form-control"
                                        value="{{ $bill->bill_date }}" name="bill_date" readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Reference</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Reference" value="{{ $bill->reference }}" name="reference">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Status</label>
                                    <select id="regular-form-1" name="status" class="tom-select w-full mt-2">
                                        <option {{ $bill->status == '1' ? 'selected' : '' }} value="1">Active</option>
                                        <option {{ $bill->status == '0' ? 'selected' : '' }} value="2">Not Active
                                        </option>
                                    </select>
                                </div>
                                {{-- <div class="col-md-3 mt-2">
                                    <label>Category</label>
                                    <select id="regular-form-1" name="category" class="tom-select w-full mt-2">
                                        <option value="1"></option>
                                    </select>
                                </div> --}}
                                {{-- <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Sequence #</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Sequence #" value="{{ $bill->sequence_no }}" name="sequence_no">
                                </div> --}}
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Ref. Bill #</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Ref. Bill #" value="{{ $bill->ref_bill }}" name="ref_bill_no"
                                        readonly>
                                </div>
                                <div class="col-md-3 mt-12">
                                    <input class="form-check-input" type="radio" value="settled" name="settlement"
                                        {{ $bill->settlement == 'settled' ? 'checked' : '' }} id="settled">
                                    <label class="form-label" for="settled">
                                        Settled
                                    </label>
                                    <input class="form-check-input" type="radio" value="un_settled" name="settlement"
                                        {{ $bill->settlement == 'un_settled' ? 'checked' : '' }} id="un_settled">
                                    <label class="form-label" for="un_settled">
                                        Un-Settled
                                    </label>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Vendor</label>
                                    <select class="tom-select" name="vendor_id" id="vendor_id" disabled>
                                        <option value="">Please Select</option>
                                        @foreach ($vendors as $item)
                                            <option {{ $bill->vendor_id == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                {{-- <div class="col-md-3 mt-2">
                                    <label>Currency</label>
                                    <select id="regular-form-1" name="currency" class="tom-select w-full mt-2">
                                        <option value="1">PKR</option>
                                        <option value="2">USD</option>
                                        <option value="3">AED</option>
                                        <option value="4">GPB</option>
                                        <option value="5">EUR</option>
                                        <option value="6">BDT</option>
                                        <option value="7">OMR</option>
                                    </select>
                                </div> --}}
                                <div class="col-md-3 mt-2">
                                    <label>Invoice Type</label>
                                    <select id="regular-form-1" name="invoice_type" class="tom-select w-full mt-2">
                                        <option {{ $bill->invoice_type == 'PI' ? 'selected' : '' }} value="PI">PI
                                        </option>
                                        <option {{ $bill->invoice_type == 'DR' ? 'selected' : '' }} value="DR">DR
                                        </option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Operation</label>
                                    <select id="regular-form-1" name="operation_id" class="tom-select w-full mt-2"
                                        disabled>
                                        @foreach ($operations as $item)
                                            <option {{ $job_master->operation_id == $item->id ? 'selected' : '' }}
                                                value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Aut/Man</label>
                                    <select id="regular-form-1" name="aut_man" class="tom-select w-full mt-2">
                                        <option {{ $bill->aut_man == 'auto' ? 'selected' : '' }} value="auto">Auto
                                        </option>
                                        <option {{ $bill->aut_man == 'manual' ? 'selected' : '' }} value="manual">Manual
                                        </option>
                                    </select>
                                </div>
                                <div class="col-md-3 mt-12">
                                    <input class="form-check-input" type="radio" value="single"
                                        name="single_multiple"{{ $bill->single_multiple == 'single' ? 'checked' : '' }}
                                        id="single">
                                    <label class="form-label" for="single">
                                        Single
                                    </label>
                                    <input class="form-check-input" type="radio" value="multiple"
                                        name="single_multiple" {{ $bill->single_multiple == 'multiple' ? 'checked' : '' }}
                                        id="multiple">
                                    <label class="form-label" for="multiple">
                                        Multiple
                                    </label>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Job #</label>
                                    {{-- <input id="regular-form-1" type="text"
                                        value="{{ $job_master->id }}" class="form-control"
                                        placeholder="Enter Job #" name="job_no"> --}}
                                    <input type="hidden" value="{{ @$job_master->id }}" name="job_no">
                                    <input readonly type="text" class="form-control" placeholder="Enter Job #"
                                        value="{{ @$job_master->job_no }}" name="sej_job_no" readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Cost Center</label>
                                    <select id="regular-form-1" name="cost_center" class="tom-select w-full mt-2">
                                        <option {{ $bill->cost_center == 'Head Office' ? 'selected' : '' }}
                                            value="Head Office">Head Office</option>
                                    </select>
                                </div>
                                <div class="col-md-2 mt-10">
                                    <input id="regular-form-1" type="checkbox" value="1" class="form-check-input"
                                        {{ $bill->auto_round_off == '1' ? 'checked' : '' }} name="auto_round_off">
                                    <label class="form-label" for="auto_round_off">
                                        Auto Round Off
                                    </label>
                                </div>
                                <div class="col-md-2 mt-10">
                                    <input id="regular-form-1" type="checkbox" value="1" class="form-check-input"
                                        {{ $bill->rebate == '1' ? 'checked' : '' }} name="rebate">
                                    <label class="form-label" for="rebate">
                                        Rebate
                                    </label>
                                </div>
                                <div class="col-md-2 mt-10">
                                    <input id="regular-form-1" type="checkbox" value="1" class="form-check-input"
                                        {{ $bill->manual == '1' ? 'checked' : '' }} name="manual">
                                    <label class="form-label" for="manual">
                                        Manual
                                    </label>
                                </div>
                                <div class="col-md-3 mt-10">
                                    <input id="regular-form-1" type="checkbox" value="1" class="form-check-input"
                                        {{ $bill->continue_mode == '1' ? 'checked' : '' }} name="continue_mode">
                                    <label class="form-label" for="continue_mode">
                                        Continue Mode
                                    </label>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Due Days</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Due Days" value="{{ $bill->due_days }}" name="due_days">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Vndr Tax Inv
                                        No</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Vndr Tax Inv No" value="{{ $bill->vndr_tax_inv_no }}"
                                        name="vndr_tax_inv_no">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Vndr Cmercial Inv
                                        No</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Vndr Cmercial Inv No"
                                        value="{{ $bill->vndr_cmercial_inv_no }}" name="vndr_cmercial_inv_no">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Vndr Inv
                                        Date</label>
                                    <input id="regular-form-1" type="date" class="form-control"
                                        value="{{ $bill->vndr_inv_date }}" name="vndr_inv_date">
                                </div>
                                <div class="col-md-6 mt-10">
                                    <input id="regular-form-1" type="checkbox" class="form-check-input"
                                        name="show_terminal" {{ $bill->show_terminal == '1' ? 'checked' : '' }}
                                        value="1">
                                    <label class="form-label" for="show_terminal">
                                        Show Terminal
                                    </label>
                                </div>
                                {{-- <div class="col-md-6 mt-10">
                                    <input id="regular-form-1" type="checkbox" class="form-check-input" name="show_bl_no">
                                    <label class="form-label" for="show_bl_no">
                                        Show BL No
                                    </label>
                                </div> --}}
                            </div>
                            {{-- <div class="text-end mt-3 me-5">
                                <button id="addRowReceivableButton" type="button" class="btn btn-primary">Add
                                    Row</button>
                            </div> --}}
                            <div class="row">
                                <div class="g-col-12 overflow-auto ">
                                    <table class="table table-bordered mt-n2">
                                        <thead>
                                            <tr>
                                                <th class="text-nowrap">S.No</th>
                                                <th class="text-nowrap">Charge Name</th>
                                                <th class="text-nowrap">Charge Descripton</th>
                                                <th class="text-nowrap">Size/Type</th>
                                                <th class="text-nowrap">Rate Group</th>
                                                <th class="text-nowrap">DG/Non-DG</th>
                                                <th class="text-nowrap">Container</th>
                                                <th class="text-nowrap">Qty</th>
                                                <th class="text-nowrap">Rate</th>
                                                <th class="text-nowrap">Currency</th>
                                                <th class="text-nowrap">Amount</th>
                                                <th class="text-nowrap">Discount</th>
                                                <th class="text-nowrap">Net Amount</th>
                                                <th class="text-nowrap">Margin</th>
                                                <th class="text-nowrap">Tax</th>
                                                <th class="text-nowrap">Tax Amount</th>
                                                <th class="text-nowrap">Net Amount Inc Tax</th>
                                                <th class="text-nowrap">Ex. Rate</th>
                                                <th class="text-nowrap">Local Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($bill->bill_charges as $index => $item)
                                                <tr>
                                                    <input type="hidden" name="job_charge_payable_id[]"
                                                        value="{{ $item->job_charge_payable_id }}">
                                                    <td>{{ $index + 1 }}</td>
                                                    <td><select class="form-control" name="charge_id[]" id="charge_id"
                                                            disabled>
                                                            @foreach ($charges as $charge)
                                                                <option
                                                                    {{ $item->charge_id == $charge->id ? 'selected' : '' }}
                                                                    value="{{ $charge->id }}">
                                                                    {{ $charge->name }}</option>
                                                            @endforeach
                                                        </select></td>
                                                    <td>
                                                        <input class="form-control" type="text" name="description[]"
                                                            readonly value="{{ $item->description }}">
                                                    </td>
                                                    <td><select class="form-control" name="size_type[]" id="size_type"
                                                            disabled>
                                                            <option {{ $item->size_type == '20BK' ? 'selected' : '' }}
                                                                value="20BK">20BK</option>
                                                            <option {{ $item->size_type == '20FR' ? 'selected' : '' }}
                                                                value="20FR">20FR</option>
                                                            <option {{ $item->size_type == '20OT' ? 'selected' : '' }}
                                                                value="20OT">20OT</option>
                                                            <option {{ $item->size_type == '20RE' ? 'selected' : '' }}
                                                                value="20RE">20RE</option>
                                                            <option {{ $item->size_type == '20SD' ? 'selected' : '' }}
                                                                value="20SD">20SD</option>
                                                            <option {{ $item->size_type == '20TK' ? 'selected' : '' }}
                                                                value="20TK">20TK</option>
                                                            <option {{ $item->size_type == '40FR' ? 'selected' : '' }}
                                                                value="40FR">40FR</option>
                                                            <option {{ $item->size_type == '40BK' ? 'selected' : '' }}
                                                                value="40BK">40BK</option>
                                                            <option {{ $item->size_type == '40HC' ? 'selected' : '' }}
                                                                value="40HC">40HC</option>
                                                            <option {{ $item->size_type == '40HCRF' ? 'selected' : '' }}
                                                                value="40HCRF">40HCRF</option>
                                                            <option {{ $item->size_type == '40OT' ? 'selected' : '' }}
                                                                value="40OT">40OT</option>
                                                            <option {{ $item->size_type == '40SD' ? 'selected' : '' }}
                                                                value="40SD">40SD</option>
                                                            <option {{ $item->size_type == '40VH' ? 'selected' : '' }}
                                                                value="40VH">40VH</option>
                                                            <option {{ $item->size_type == '45BK' ? 'selected' : '' }}
                                                                value="45BK">45BK</option>
                                                            <option {{ $item->size_type == '45HC' ? 'selected' : '' }}
                                                                value="45HC">45HC</option>
                                                            <option {{ $item->size_type == '45OT' ? 'selected' : '' }}
                                                                value="45OT">45OT</option>
                                                            <option {{ $item->size_type == '45TK' ? 'selected' : '' }}
                                                                value="45TK">45TK</option>
                                                            <option {{ $item->size_type == '45VH' ? 'selected' : '' }}
                                                                value="45VH">45VH</option>
                                                            <option {{ $item->size_type == 'M3' ? 'selected' : '' }}
                                                                value="M3">M3</option>
                                                        </select></td>
                                                    <td>
                                                        <input class="form-control" type="text" name="rate_group[]"
                                                            readonly value="{{ $item->rate_group }}">
                                                    </td>
                                                    <td><select class="form-control" name="dg_non_dg[]" id="dg_non_dg"
                                                            disabled>
                                                            <option {{ $item->dg_non_dg == 'DG' ? 'selected' : '' }}
                                                                value="DG">
                                                                DG</option>
                                                            <option {{ $item->dg_non_dg == 'Non-DG' ? 'selected' : '' }}
                                                                value="Non-DG">
                                                                Non-DG</option>
                                                            <option {{ $item->dg_non_dg == 'All' ? 'selected' : '' }}
                                                                value="All">
                                                                All</option>
                                                        </select></td>
                                                    <td>
                                                        <input class="form-control" type="text" name="container[]"
                                                            readonly value="{{ $item->container }}">
                                                    </td>
                                                    <td>
                                                        <input class="form-control w-24" type="text" name="qty[]"
                                                            readonly value="{{ $item->qty }}">
                                                    </td>
                                                    <td>
                                                        <input class="form-control w-24" type="text" name="rate[]"
                                                            readonly value="{{ $item->rate }}">
                                                    </td>
                                                    <td><select class="form-control" name="currency[]" id="currency"
                                                            disabled>
                                                            <option {{ $item->currency == 1 ? 'selected' : '' }}
                                                                value="1">
                                                                PKR</option>
                                                            <option {{ $item->currency == 2 ? 'selected' : '' }}
                                                                value="2">
                                                                USD</option>
                                                            <option {{ $item->currency == 3 ? 'selected' : '' }}
                                                                value="3">
                                                                AED</option>
                                                            <option {{ $item->currency == 4 ? 'selected' : '' }}
                                                                value="4">
                                                                GBP</option>
                                                            <option {{ $item->currency == 5 ? 'selected' : '' }}
                                                                value="5">
                                                                EUR</option>
                                                            <option {{ $item->currency == 6 ? 'selected' : '' }}
                                                                value="6">
                                                                BDT</option>
                                                            <option {{ $item->currency == 7 ? 'selected' : '' }}
                                                                value="7">
                                                                OMR</option>
                                                        </select></td>
                                                    <td>
                                                        <input class="form-control" type="text" name="amount[]"
                                                            readonly value="{{ $item->amount }}">
                                                    </td>
                                                    <td>
                                                        <input class="form-control" type="text" name="discount[]"
                                                            readonly value="{{ $item->discount }}">
                                                    </td>
                                                    <td>
                                                        <input class="form-control" type="text" name="net_amount[]"
                                                            readonly value="{{ $item->net_amount }}">
                                                    </td>
                                                    <td>
                                                        <input class="form-control" type="text" name="margin[]"
                                                            readonly value="{{ $item->margin }}">
                                                    </td>
                                                    <td>
                                                        <input class="form-control w-24" type="text" name="tax[]"
                                                            readonly value="{{ $item->tax }}">
                                                    </td>
                                                    <td>
                                                        <input class="form-control" type="text" name="tax_amount[]"
                                                            readonly value="{{ $item->tax_amount }}">
                                                    </td>
                                                    <td>
                                                        <input class="form-control" type="text"
                                                            name="net_amount_inc_tax[]" readonly
                                                            value="{{ $item->net_amount_inc_tax }}">
                                                    </td>
                                                    <td>
                                                        <input class="form-control" type="text" name="ex_rate[]"
                                                            readonly value="{{ $item->ex_rate }}">
                                                    </td>
                                                    <td>
                                                        <input class="form-control" type="text" name="local_amount[]"
                                                            readonly value="{{ $item->local_amount }}">
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Remarks</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Remarks" value="{{ $bill->remarks }}" name="remarks"
                                        readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Voucher #</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Voucher #" value="{{ @$transaction_master->voucher_no ?? ''}}"
                                        name="voucher_no" readonly>
                                </div>

                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Total
                                        Amount</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Total Amount" value="{{ $bill->grand_total_amount }}"
                                        name="grand_total_amount" readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Net Amount</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Net Amount" value="{{ $bill->grand_net_amount }}"
                                        name="grand_net_amount" readonly>
                                </div>
                                <div class="col-md-3 mt-10">
                                    <input id="regular-form-1" type="checkbox"
                                        {{ $bill->manual_remarks == '1' ? 'checked' : '' }} class="form-check-input"
                                        value="1" name="manual_remarks" disabled>
                                    <label class="form-label" for="manual_remarks">
                                        Manual Remarks
                                    </label>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Discount</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Discount" value="{{ $bill->grand_discount }}"
                                        name="grand_discount" readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Tax Amount</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Tax Amount" value="{{ $bill->grand_tax_amount }}"
                                        name="grand_tax_amount" readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Net Amount Inc
                                        Tax</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Net Amount Inc Tax"
                                        value="{{ $bill->grand_net_amount_inc_tax }}" name="grand_net_amount_inc_tax"
                                        readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Local
                                        Amount</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Local Amount" value="{{ $bill->grand_local_amount }}"
                                        name="grand_local_amount" readonly>
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label for="regular-form-1" class="form-label">Total
                                        Deduction</label>
                                    <input id="regular-form-1" type="text" class="form-control"
                                        placeholder="Enter Total Deduction" value="{{ $bill->total_deduction }}"
                                        name="total_deduction" readonly>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    @include('sea_export.se_bill.modal.print')
@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('.showPrintBtn').forEach(button => {
            button.addEventListener('click', function() {
                const billID = this.getAttribute('data-item-id');
                const form = document.getElementById(
                    'printForm');
                form.setAttribute('action',`/bill_print/${billID}`);
            });
        });
    });
</script>
<script>
    $(document).ready(function() {
        const dropdownOptions = {
            customers: [""],
            vendors: [""],
            charges: {!! json_encode($charges) !!},
            type: ["Inv", "CN"],
            basis: ["Unit"],
            ppcc: ["PP", "CC"],
            sizeType: ["20BK", "20FR", "20OT", "20RE", "20SD", "20TK", "40FR", "40BK", "40HC", "40HCRF",
                "40OT", "40SD", "40VH", "45BK", "45HC", "45OT", "45TK", "45VH", "M3"
            ],
            dgNonDg: ["DG", "Non-DG", "All"],
            currency: ["PKR", "USD", "AED", "GBP", "EUR", "BDT", "OMR"],
        };

        function createDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option + '">' + option + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createDynamicDropdown(name, options) {
            let dropdown = '<select name="' + name + '" class="form-control w-24">';
            options.forEach(option => {
                dropdown += '<option value="' + option.id + '">' + option.name + '</option>';
            });
            dropdown += '</select>';
            return dropdown;
        }

        function createInput(type, name, placeholder) {
            if (type == "checkbox") {
                return '<input type="' + type + '" name="' + name +
                    '"value="1" class="form-check-input" placeholder="' +
                    placeholder + '">';
            } else {
                return '<input type="' + type + '" name="' + name +
                    '" class="form-control w-24" placeholder="' +
                    placeholder + '">';
            }
        }

        let rowReceivableCounter = 1;

        function addRowReceivable() {

            let row = '<tr>' +
                '<td class="text-nowrap">' + rowReceivableCounter +
                '<input type="hidden" name="receivable_rows" value=' + rowReceivableCounter + '>' + '</td>' +
                '<td class="text-nowrap">' + createDynamicDropdown('charge_id[]', dropdownOptions
                    .charges) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'description[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('size_type[]', dropdownOptions
                    .sizeType) + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'rate_group[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('dg_non_dg[]', dropdownOptions.dgNonDg) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'container[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'qty[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'rate[]', '') + '</td>' +
                '<td class="text-nowrap">' + createDropdown('currency[]', dropdownOptions.currency) +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'discount[]', '') + '</td>' +
                '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'net_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'margin[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'tax[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'tax_amount[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'net_amount_inc_tax[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'ex_rate[]', '') + '</td>' +
                '<td class="text-nowrap">' + createInput('text', 'local_amount[]', '') + '</td>' +
                '</tr>';
            $('#receiveableTable tbody').append(row);
            rowReceivableCounter++;
        }

        $('#addRowReceivableButton').click(addRowReceivable);
    });
</script>
