@extends('layout.master')

@section('title')
    @if (Request::is('se_bill'))
        SE Bill-YARAN
    @elseif(Request::is('si_bill'))
        SI Bill-YARAN
    @elseif(Request::is('ae_bill'))
        AE Bill-YARAN
    @elseif(Request::is('ai_bill'))
        AI Bill-YARAN
    @endif
    {{-- SE Bill-YARAN --}}
@endsection

@section('topbar')
    @if (Request::is('se_bill'))
        <a href="/se_bill" class="breadcrumb--active">SE Bill</a>
    @elseif(Request::is('si_bill'))
        <a href="/si_bill" class="breadcrumb--active">SI Bill</a>
    @elseif(Request::is('ae_bill'))
        <a href="/ae_bill" class="breadcrumb--active">AE Bill</a>
    @elseif(Request::is('ai_bill'))
        <a href="/ai_bill" class="breadcrumb--active">AI Bill</a>
    @endif
@endsection
@section('content')
    {{-- <h2 class="intro-y fs-lg fw-medium mt-10">
        @if (Request::is('se_bill'))
            SE Bill
        @elseif(Request::is('si_bill'))
            SI Bill
        @elseif(Request::is('ae_bill'))
            AE Bill
        @elseif(Request::is('ai_bill'))
            AI Bill
        @endif
    </h2> --}}
    <div class="intro-y d-flex align-items-center">
        <div class="d-flex align-items-center">
            <h2 class="intro-y fs-lg fw-medium mt-6">
                @if (Request::is('se_bill'))
                    SE Bill
                @elseif(Request::is('si_bill'))
                    SI Bill
                @elseif(Request::is('ae_bill'))
                    AE Bill
                @elseif(Request::is('ai_bill'))
                    AI Bill
                @endif
            </h2>
        </div>
        <div class="ms-auto mt-10">
            <button class="btn btn-primary dark-text-theme-10" type="button" data-bs-toggle="collapse"
                data-bs-target="#faq-accordion-collapse-1" aria-expanded="true" aria-controls="faq-accordion-collapse-1"> <i
                    data-feather="filter" class="w-4 h-4 me-3"></i> Filters
            </button>
        </div>
    </div>
    <div id="faq-accordion-collapse-1" class="accordion-collapse collapse show mt-5" aria-labelledby="faq-accordion-content-1"
        data-bs-parent="#faq-accordion-1">
        <div class="grid columns-12 gap-6 mt-5">
            <div class="intro-y g-col-12 g-col-lg-12">
                <!-- BEGIN: Form Layout -->
                <div class="intro-y box p-5">
                    <form method="GET" id="myForm" action="{{ url('/se_bill') }}">
                        <div class="row">
                            <div class="col-md-4">
                                <div>
                                    <label for="filterBy" class="form-label">Select</label>
                                    <select name="filterBy" id="filterBy" class="form-control">
                                        <option value="" {{ request('filterBy') == '' ? 'selected' : '' }}>Select
                                        </option>
                                        <option value="id" {{ request('filterBy') == 'id' ? 'selected' : '' }}>Bill #
                                        </option>
                                        <option value="ref_bill_no"
                                            {{ request('filterBy') == 'ref_bill_no' ? 'selected' : '' }}>Reference</option>
                                        <option value="vendor_id"
                                            {{ request('filterBy') == 'vendor_id' ? 'selected' : '' }}>vendor_id</option>
                                        <option value="job_master_id"
                                            {{ request('filterBy') == 'job_master_id' ? 'selected' : '' }}>Job #</option>
                                        <option value="invoice_type"
                                            {{ request('filterBy') == 'invoice_type' ? 'selected' : '' }}>Invoice Category
                                        </option>
                                        <option value="status" {{ request('filterBy') == 'status' ? 'selected' : '' }}>Bill
                                            Status</option>
                                        <option value="vndr_tax_inv_no"
                                            {{ request('filterBy') == 'vndr_tax_inv_no' ? 'selected' : '' }}>Vendor Tax Inv
                                            No</option>
                                        <option value="vndr_cmercial_inv_no"
                                            {{ request('filterBy') == 'vndr_cmercial_inv_no' ? 'selected' : '' }}>Vendor
                                            cmercial Inv No</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="filterValue" class="form-label">Name</label>
                                <input type="text" name="filterValue" class="form-control"
                                    value="{{ request('filterValue') }}" placeholder="Enter Name or ID"
                                    aria-label="Enter Name">
                            </div>
                            <div class="col-md-4 mt-8">
                                <button type="submit" class="btn btn-sm btn-elevated-primary w-24">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20"
                                        height="20" class="main-grid-item-icon" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                        <circle cx="11" cy="11" r="8" />
                                        <line x1="21" x2="16.65" y1="21" y2="16.65" />
                                    </svg>
                                    Search</button>
                                <a href="{{ url('/se_bill') }}" type="button" class="btn btn-sm btn-elevated-danger w-24">
                                    {{-- <i data-feather="x"></i> --}}
                                    <!-- https://feathericons.dev/?search=x&iconset=feather -->
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20"
                                        height="20" class="main-grid-item-icon" fill="none" stroke="currentColor"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                        <line x1="18" x2="6" y1="6" y2="18" />
                                        <line x1="6" x2="18" y1="6" y2="18" />
                                    </svg>
                                    Clear</a>
                            </div>
                    </form>
                </div>
            </div>
            <!-- END: Form Layout -->
        </div>
    </div>
    </div>
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2">
            {{-- @if (Request::is('se_bill'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/se_bill/add') }}">Add New</a>
            @elseif(Request::is('si_bill'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/si_bill/add') }}">Add New</a>
            @elseif(Request::is('ae_bill'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/ae_bill/add') }}">Add New</a>
            @elseif(Request::is('ai_bill'))
                <a class="btn btn-primary shadow-md me-2" href="{{ url('/ai_bill/add') }}">Add New</a>
            @endif --}}
            <div class="d-none d-md-block mx-auto text-gray-600">Showing {{ $bills->firstItem() }} to
                {{ $bills->lastItem() }} of {{ $bills->total() }} entries</div>
        </div>
        <!-- BEGIN: Data List -->

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2">
                <thead>
                    <tr>
                        <th>Tran #</th>
                        <th>Job #</th>
                        <th>Bill Date</th>
                        <th>Reference</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($bills as $bill)
                        <tr>
                            <td>{{ $bill->tran_no }}</td>
                            <td>{{ @$bill->job_master->job_no }}</td>
                            <td>{{ $bill->bill_date }}</td>
                            <td>{{ $bill->reference }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    @if (Request::is('se_bill'))
                                        <a title="Edit" class="tooltip btn btn-primary me-2 p-2"
                                            href="{{ url('/se_bill/edit/' . $bill->job_master_id) . '?bill_invoice=' . $bill->tran_no }}"><i
                                                data-feather="edit" class="w-4 h-4"></i> </a>
                                    @elseif(Request::is('si_bill'))
                                        <a title="Edit" class="tooltip btn btn-primary me-2 p-2"
                                            href="{{ url('/si_bill/edit/' . $bill->job_master_id) . '?bill_invoice=' . $bill->tran_no }}"><i
                                                data-feather="edit" class="w-4 h-4"></i> </a>
                                    @elseif(Request::is('ae_bill'))
                                        <a title="Edit" class="tooltip btn btn-primary me-2 p-2"
                                            href="{{ url('/ae_bill/edit/' . $bill->job_master_id) . '?bill_invoice=' . $bill->tran_no }}"><i
                                                data-feather="edit" class="w-4 h-4"></i> </a>
                                    @elseif(Request::is('ai_bill'))
                                        <a title="Edit" class="tooltip btn btn-primary me-2 p-2"
                                            href="{{ url('/ai_bill/edit/' . $bill->job_master_id) . '?bill_invoice=' . $bill->tran_no }}"><i
                                                data-feather="edit" class="w-4 h-4"></i> </a>
                                    @endif
                                    <button id="showPrintBtn{{ $bill->id }}"
                                        class="btn btn-success me-2 p-2 showPrintBtn" data-bs-toggle="modal"
                                        data-bs-target="#printModal" data-item-id="{{ $bill->id }}"><i
                                            data-feather="file-text" class="w-4 h-4 me-1"></i> Print </button>
                                    {{-- <a target="_blank" href={{ url('bill_print/' . $bill->id) }}
                                        class="btn btn-success me-2 p-2"><i data-feather="file-text"
                                            class="w-4 h-4 me-1"></i>Print</a> --}}

                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <!-- Pagination -->
        <div class="g-col-12">
            <div class="d-flex justify-content-end align-items-end">
                <div class="me-3">
                    <label for="perPage" class="form-label">Show Items:</label>
                    <select id="perPage" name="perPage" class="form-select" onchange="changePerPage(this)">
                        <option value="100" @if ($perPage == 100) selected @endif>100</option>
                        <option value="200" @if ($perPage == 200) selected @endif>200</option>
                        <option value="250" @if ($perPage == 250) selected @endif>250</option>
                    </select>
                </div>
                <div class="ms-3">
                    <?php echo $bills->appends(request()->query())->links('pagination::bootstrap-4'); ?>
                </div>
            </div>
        </div>
        {{-- end Pagination --}}
    </div>
    @include('sea_export.se_bill.modal.print')

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.showPrintBtn').forEach(button => {
                button.addEventListener('click', function() {
                    const billID = this.getAttribute('data-item-id');
                    const form = document.getElementById(
                        'printForm');
                    form.setAttribute('action', `/bill_print/${billID}`);
                });
            });
        });
    </script>
    <script>
        function changePerPage(select) {
            const perPage = select.value;
            const urlParams = new URLSearchParams(window.location.search);
    
            // Add or update your own parameters
            urlParams.set('perPage', perPage);
    
            // Construct the new URL
            const newUrl = `{{ url('/se_bill') }}?${urlParams.toString()}`;
    
            // Redirect to the new URL
            window.location.href = newUrl;
    
        }
    </script>
@endsection