<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>YARAN - JOB BILL - PRINT</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap"
        rel="stylesheet">
    <style>
        P {
            font-size: 12px;
        }

        @media print {
            table {
                page-break-inside: auto;
            }

            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }

            .no-print {
                display: none;
            }
        }

        @media print {
            @page {
                size: A4;
                margin: 0;
            }

            .container {
                width: 100%;
                margin: 0;
                padding: 0;
            }

            table {
                width: 100%;
                border-collapse: collapse;
            }

            th,
            td {
                padding: 4px;
            }
        }

        @media print {
            .container {
                width: 100%;
                margin: 0;
            }

            table {
                page-break-inside: auto;
                width: 100%;
            }

            th,
            td {
                page-break-inside: avoid;
            }

            @page {
                size: auto;
                margin: 0;
            }
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: "Poppins", sans-serif;

        }

        table {
            width: 100%;
            height: 60px;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid black;
            padding: 4px;
            text-align: left;
            font-size: 12px;
        }

        .column1 {
            width: 50%;
        }

        .column2 {
            width: 50%;
        }

        .sr,
        .name,
        .rate,
        .amount,
        .dis,
        .tax,
        .total,
        .qty,
        .curr {
            text-align: right;
            font-size: 11.8px;

        }

        .column-heading {
            background-color: rgb(194, 186, 186);
            text-align: center;
        }

        .sr {
            width: 5%;
            text-align: left;
        }

        .name {
            width: 25%;
            text-align: left;
        }
    </style>
</head>

<body>
    <div class="container" style="margin: 0px 60px; width: 88.1%; font-size: 16px;">
        <div class="logo-heading" style="display: flex;gap: 15%;align-items: center;text-align: center;">
            <div class="logo" style="{{ $print_logo == 'on' ? '' : 'visibility: hidden;' }}">
                {{-- <img src="logo.png" alt="" style="width: 150px; padding-bottom: px;border-top: none;"> --}}
                <img src="{{ url('logo2.png') }}" alt=""
                    style="width: 150px; padding-bottom: px;border-top: none;">
            </div>
            <div class="heading">
                <h3>YARAN SHIPPING LINE</h3>
                <p>Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.</p>
                <p style="font-size: 12px;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <div style="border:3px solid;width: 68%;border-top: none; border-right: none; border-left: none;"></div>
            <h3>Job Bill</h3>
            <div style="border:3px solid;width: 8%; border-right: none; border-left: none;border-top: none;"></div>
        </div>

        <table style="font-size: 10px;">

            <tr>
                <td>
                    <h4>PAYABLE TO</h4>
                    <p>{{ @$bill->vendor->name }} <br>
                        {{ @$bill->vendor->address }}
                    </p>
                </td>
                <td>
                    <table style="border: none !important">
                        <tr style="border: none !important">
                            <td style="border: none !important">
                                <h4>Bill No</h4>
                                <p>{{ @$bill->tran_no }}</p>
                            </td>
                            <td colspan="2" style="border: none !important">
                                <h4>Bill Date</h4>
                                <p>{{ @$bill->bill_date }}</p>
                            </td>
                        </tr>
                        <tr style="border: none !important">
                            <td style="border: none !important">
                                <h4>Currency</h4>
                                <p>{{ @$bill->bill_charges[0]->currency_name->name }}</p>
                            </td>
                            <td style="border: none !important">
                                <h4>Exchange Rate</h4>
                                <p>{{ @$bill->bill_charges[0]->ex_rate }}</p>
                            </td>
                            <td style="border: none !important">
                                <h4>Refrence No</h4>
                                <p>{{ @$bill->ref_bill_no }}</p>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td class="column1">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>Shipper</h4>
                        <p>{{ @$bill->job_master->job_detail->shipper->name }}</p>
                </td>
                <td class="column2">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>Consignee</h4>
                        <p>{{ @$bill->job_master->job_detail->consignee->name }}</p>
                    </div>
                </td>
            </tr>
            <tr>
                <td class="column1">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>MBL No.</h4>
                        <h4>Bill of Lading</h4>
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        <p>{{ @$bill->job_master->bl_master->mbl_no }}</p>
                        <p>{{ @$bill->job_master->bl_master->hbl_no }}</p>
                    </div>
                </td>
                <td class="column2">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>Sailing Date</h4>
                        <h4>Job No</h4>
                        <h4>Job Date</h4>
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        <p>{{ \Carbon\Carbon::parse(@$bill->job_master->job_vessel->voyage->export_sailing_date)->format('d/m/Y') }}
                        </p>
                        <p>{{ @$bill->job_master->job_no }}</p>
                        {{-- <p>{{ @$invoice->job_master->job_date }}</p> --}}
                        <p>{{ \Carbon\Carbon::parse(@$bill->job_master->job_date)->format('d/m/Y') }}
                        </p>
                    </div>
                </td>
            </tr>
            <tr>
                <td class="column1">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>Vessel / Voyage</h4>
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        <p>{{ @$bill->job_master->job_vessel->vessel->name }} /
                            {{ @$bill->job_master->job_vessel->voyage->voyage_no }}</p>
                    </div>
                </td>
                <td class="column2">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>Cost Center</h4>
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        <p>{{ @$bill->job_master->cost_center }}</p>
                    </div>
                    @if ($print_sales_rep == 'on')
                        <div style="display: flex; justify-content:space-between;">
                            <h4>Sales Rep</h4>
                        </div>
                        <div style="display: flex; justify-content:space-between;">
                            <p>{{ @$bill->job_master->job_detail->sales_rep->employee_name }}</p>
                        </div>
                    @endif
                </td>
            </tr>
            <tr>
                <td class="column1">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>Port of Loading</h4>
                        <h4>Port of Discharge</h4>
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        <p>{{ @$bill->job_master->job_routing->port_of_loading->name }}</p>
                        <p>{{ @$bill->job_master->job_routing->port_of_discharge->name }}</p>
                    </div>
                </td>
                <td class="column2">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>Destination Port</h4>
                        @if ($hide_shipping_line != 'on')
                            <h4>Shipping Line</h4>
                        @endif
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        <p>{{ @$bill->job_master->job_routing->final_destination->name }}</p>
                        @if ($hide_shipping_line != 'on')
                            <p>{{ @$bill->job_master->job_detail->shipping_line->name }}</p>
                        @endif

                    </div>
                </td>
            </tr>
            <tr>
                <td class="column2" style="display: flex; gap: 110px; border: 1px solid; width: 100%;height: 47px;">
                    <div>
                        <h4>Volume</h4>
                        <p>{{ @$bill->job_master->job_weight->vol }}</p>
                    </div>
                    <div>
                        <h4>Weight</h4>
                        <p>{{ @$bill->job_master->job_weight->weight }}</p>
                    </div>
                    <div>
                        <h4>PCS</h4>
                        <p>{{ @$bill->job_master->job_weight->pcs }}</p>
                    </div>
                </td>
                <td class="column2">
                    <div style="display: flex; justify-content:space-between;">
                        <h4>File No :</h4>
                        @if ($print_container_sizetype == 'on')
                            <h4>Container Size Type :</h4>
                        @endif
                    </div>
                    <div style="display: flex; justify-content:space-between;">
                        <p>{{ @$bill->job_master->file_no }}</p>
                        @if ($print_container_sizetype == 'on')
                            @foreach ($bill->job_master->job_equipments as $job_equipment)
                                <p>{{ $job_equipment->quantity . 'x' . $job_equipment->size_type }}</p>
                            @endforeach
                        @endif
                        {{-- <p>283.300000</p> --}}
                    </div>
                </td>
            </tr>
            @if ($print_container_no == 'on')
                <tr>
                    <td colspan="2" style="border: 1px solid;">
                        <div style="display: flex; gap: 30px;">
                            <h3>Container No </h3>
                            <p>{{ $containerNo }}</p>
                        </div>
                    </td>
                </tr>
            @endif

        </table>
        <table>
            <!-- Table Headings -->
            <tr>
                <th class="column-heading">SR#</th>
                <th class="column-heading">Charge</th>
                <th class="column-heading">Qty</th>
                <th class="column-heading">Rate</th>
                <th class="column-heading">Curr</th>
                <th class="column-heading">Ex.Rate</th>
                <th class="column-heading">FC Amount</th>
                <th class="column-heading">Local Amount </th>
            </tr>

            <!-- Table Rows -->
            @if ($bill->bill_charges)
                @foreach ($bill->bill_charges as $index => $charges)
                    <tr>
                        <td class="sr">{{ $index + 1 }}</td>
                        <td class="name">{{ $charges->charge->name }}</td>
                        <td class="qty">{{ $charges->qty }}</td>
                        <td class="rate">{{ $charges->rate }}</td>
                        <td class="curr">{{ $charges->currency_name->name }}</td>
                        <td class="dis">{{ $charges->ex_rate }}</td>
                        <td class="amount">{{ $charges->net_amount_inc_tax }}</td>
                        <td class="tax">{{ $charges->local_amount }}</td>
                    </tr>
                @endforeach
            @endif
        </table>
        <div class="total-discount"
            style="border: 1px solid;display: flex;justify-content: space-between;width: 100%;height: 100px;padding: 8px;">
            <div class="discount">
                <h4>Discount Amount</h4>
            </div>
            <div class="discount">
                <p>{{ @$bill->grand_discount }}</p>
            </div>
            <div class="discount">
                <h4>Tax Amount</h4>
            </div>
            <div class="discount">
                <p>{{ @$bill->grand_tax_amount }}</p>
            </div>
            <div class="discount">
                <h4>Invoice Total</h4>
            </div>
            <div class="discount">
                <p>{{ @$bill->grand_local_amount }}</p>
            </div>
        </div>
        <div class="note" style="display: flex;">
            <div style="border: 1px solid; width: 50%; padding: 0px 5px;">
                <h4>In-Words</h4>
                @php
                    $formatter = new \NumberFormatter('en', \NumberFormatter::SPELLOUT);
                    $amountInWords = strtoupper($formatter->format(@$bill->grand_local_amount));
                @endphp
                <p>PKR {{ @$amountInWords }}</p>
            </div>
            <div style="border: 1px solid;width: 50%; padding: 0px 5px;">
                <h4>Total Amount</h4>
                <p>{{ @$bill->grand_local_amount }}</p>
            </div>
        </div>
        @if ($print_remarks == 'on')
            <div class="note" style="display: flex; margin-top: 15px">
                <div style="border: 1px solid;width: 100%; padding: 0px 5px;">
                    <h4>Remarks :</h4>
                    <p>{{ @$bill->remarks }}</p>
                </div>
            </div>
        @endif
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            window.print(); // Trigger the print dialog once the page loads
        });
    </script>
</body>

</html>
