<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>YARAN - JOB BILL - PRINT</title>
</head>

<body style="font-family: Poppins, sans-serif; font-size: 12px; margin: 0; padding: 0;">
    <div style="margin: 0px 60px; width: 88.1%;">
        <table style="width: 100%;">
            <tr>
                <td style="width: 30%;">
                    @if ($print_logo == 'on')
                        <img src="{{ url('logo2.png') }}" alt="Company Logo"
                            style="width: 80px !important; height: 50px !important; max-width: 80px !important; max-height: 50px !important; object-fit: contain;"
                            width="80" height="50">
                    @endif
                </td>
                <td style="text-align: center;">
                    @if ($print_on_letterhead == 'on')
                        <h3 style="margin: 0;">YARAN SHIPPING LINE</h3>
                        <p style="margin: 0;">Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                        </p>
                        <p style="margin: 0;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
                    @endif
                </td>
                <td style="width: 30%;"></td>
            </tr>
        </table>

        <table style="width: 100%; margin-top: 10px;">
            <tr>
                <td style="border-top: 3px solid black; border-bottom: 3px solid black; width: 68%;"></td>
                <td style="text-align: center;">
                    <h3>Job Bill</h3>
                </td>
                <td style="border-top: 3px solid black; border-bottom: 3px solid black; width: 8%;"></td>
            </tr>
        </table>

        <!-- PAYABLE TO + BILL INFO -->
        <table style="width: 100%; border-collapse: collapse; margin-top: 10px;">
            <tr>
                <td style="border: 1px solid black; vertical-align: top; padding: 6px;">
                    <strong>PAYABLE TO</strong><br>
                    {{ @$bill->vendor->name }}<br>
                    {{ @$bill->vendor->address }}
                </td>
                <td style="border: 1px solid black; padding: 0;">
                    <table style="width: 100%; border-collapse: collapse;">
                        <tr>
                            <td style="padding: 4px;"><strong>Bill No</strong><br>{{ @$bill->tran_no }}</td>
                            <td style="padding: 4px;"><strong>Bill Date</strong><br>{{ @$bill->bill_date }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 4px;">
                                <strong>Currency</strong><br>{{ @$bill->bill_charges[0]->currency_name->name }}</td>
                            <td style="padding: 4px;"><strong>Exchange
                                    Rate</strong><br>{{ @$bill->bill_charges[0]->ex_rate }}</td>
                            <td style="padding: 4px;"><strong>Reference No</strong><br>{{ @$bill->ref_bill_no }}</td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>

        <!-- SHIPPER + CONSIGNEE -->
        <table style="width: 100%; border-collapse: collapse;">
            <tr>
                <td style="border: 1px solid black; padding: 6px;">
                    <strong>Shipper</strong>: {{ @$bill->job_master->job_detail->shipper->name }}
                </td>
                <td style="border: 1px solid black; padding: 6px;">
                    <strong>Consignee</strong>: {{ @$bill->job_master->job_detail->consignee->name }}
                </td>
            </tr>
        </table>

        <!-- B/L + JOB INFO -->
        <table style="width: 100%; border-collapse: collapse;">
            <tr>
                <td style="border: 1px solid black; padding: 6px;">
                    <strong>MBL No.</strong>: {{ @$bill->job_master->bl_master->mbl_no }}<br>
                    <strong>Bill of Lading</strong>: {{ @$bill->job_master->bl_master->hbl_no }}
                </td>
                <td style="border: 1px solid black; padding: 6px;">
                    <strong>Sailing Date</strong>:
                    {{ \Carbon\Carbon::parse(@$bill->job_master->job_vessel->voyage->export_sailing_date)->format('d/m/Y') }}<br>
                    <strong>Job No</strong>: {{ @$bill->job_master->job_no }}<br>
                    <strong>Job Date</strong>:
                    {{ \Carbon\Carbon::parse(@$bill->job_master->job_date)->format('d/m/Y') }}
                </td>
            </tr>
        </table>

        <!-- VESSEL/VOYAGE + COST CENTER -->
        <table style="width: 100%; border-collapse: collapse;">
            <tr>
                <td style="border: 1px solid black; padding: 6px;">
                    <strong>Vessel / Voyage</strong>: {{ @$bill->job_master->job_vessel->vessel->name }} /
                    {{ @$bill->job_master->job_vessel->voyage->voyage_no }}
                </td>
                <td style="border: 1px solid black; padding: 6px;">
                    <strong>Cost Center</strong>: {{ @$bill->job_master->cost_center }}<br>
                    @if ($print_sales_rep == 'on')
                        <strong>Sales Rep</strong>: {{ @$bill->job_master->job_detail->sales_rep->employee_name }}
                    @endif
                </td>
            </tr>
        </table>

        <!-- PORTS + SHIPPING LINE -->
        <table style="width: 100%; border-collapse: collapse;">
            <tr>
                <td style="border: 1px solid black; padding: 6px;">
                    <strong>Port of Loading</strong>: {{ @$bill->job_master->job_routing->port_of_loading->name }}<br>
                    <strong>Port of Discharge</strong>: {{ @$bill->job_master->job_routing->port_of_discharge->name }}
                </td>
                <td style="border: 1px solid black; padding: 6px;">
                    <strong>Destination Port</strong>:
                    {{ @$bill->job_master->job_routing->final_destination->name }}<br>
                    @if ($hide_shipping_line != 'on')
                        <strong>Shipping Line</strong>: {{ @$bill->job_master->job_detail->shipping_line->name }}
                    @endif
                </td>
            </tr>
        </table>

        <!-- VOLUME / FILE / CONTAINER SIZE -->
        <table style="width: 100%; border-collapse: collapse;">
            <tr>
                <td style="border: 1px solid black; padding: 6px;">
                    <strong>Volume</strong>: {{ @$bill->job_master->job_weight->vol }}<br>
                    <strong>Weight</strong>: {{ @$bill->job_master->job_weight->weight }}<br>
                    <strong>PCS</strong>: {{ @$bill->job_master->job_weight->pcs }}
                </td>
                <td style="border: 1px solid black; padding: 6px;">
                    <strong>File No</strong>: {{ @$bill->job_master->file_no }}<br>
                    @if ($print_container_sizetype == 'on')
                        <strong>Container Size Type</strong>:
                        @foreach ($bill->job_master->job_equipments as $job_equipment)
                            {{ $job_equipment->quantity . 'x' . $job_equipment->size_type }}&nbsp;
                        @endforeach
                    @endif
                </td>
            </tr>
        </table>

        @if ($print_container_no == 'on')
            <table style="width: 100%; border-collapse: collapse;">
                <tr>
                    <td colspan="2" style="border: 1px solid black; padding: 6px;">
                        <strong>Container No</strong>: {{ $containerNo }}
                    </td>
                </tr>
            </table>
        @endif

        <!-- CHARGES TABLE -->
        <table style="width: 100%; border-collapse: collapse; margin-top: 10px;">
            <tr style="background: #ccc;">
                <th>SR#</th>
                <th>Charge</th>
                <th>Qty</th>
                <th>Rate</th>
                <th>Curr</th>
                <th>Ex.Rate</th>
                <th>FC Amount</th>
                <th>Local Amount</th>
            </tr>
            @foreach ($bill->bill_charges as $index => $charges)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $charges->charge->name }}</td>
                    <td style="text-align: right;">{{ $charges->qty }}</td>
                    <td style="text-align: right;">{{ $charges->rate }}</td>
                    <td style="text-align: center;">{{ $charges->currency_name->name }}</td>
                    <td style="text-align: right;">{{ $charges->ex_rate }}</td>
                    <td style="text-align: right;">{{ $charges->net_amount_inc_tax }}</td>
                    <td style="text-align: right;">{{ $charges->local_amount }}</td>
                </tr>
            @endforeach
        </table>

        <!-- TOTALS -->
        <table style="width: 100%; border: 1px solid black; margin-top: 10px;">
            <tr>
                <td style="padding: 8px;"><strong>Discount Amount</strong>: {{ @$bill->grand_discount }}</td>
                <td style="padding: 8px;"><strong>Tax Amount</strong>: {{ @$bill->grand_tax_amount }}</td>
                <td style="padding: 8px;"><strong>Invoice Total</strong>: {{ @$bill->grand_local_amount }}</td>
            </tr>
        </table>

        <!-- IN WORDS + TOTAL -->
        <table style="width: 100%; border-collapse: collapse; margin-top: 10px;">
            <tr>
                <td style="border: 1px solid black; padding: 6px;">
                    <strong>In Words</strong>: PKR
                    {{ strtoupper((new \NumberFormatter('en', \NumberFormatter::SPELLOUT))->format(@$bill->grand_local_amount)) }}
                </td>
                <td style="border: 1px solid black; padding: 6px;">
                    <strong>Total Amount</strong>: {{ @$bill->grand_local_amount }}
                </td>
            </tr>
        </table>

        @if ($print_remarks == 'on')
            <table style="width: 100%; border-collapse: collapse; margin-top: 10px;">
                <tr>
                    <td style="border: 1px solid black; padding: 6px;">
                        <strong>Remarks:</strong> {{ @$bill->remarks }}
                    </td>
                </tr>
            </table>
        @endif
    </div>

</body>

</html>
